/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.util.SimpleDiffUtility;
import java.util.Iterator;

public class AddressIteratorConverter
implements AddressIterator {
    private Program iteratorsProgram;
    private AddressIterator iterator;
    private Program otherProgram;
    Address nextAddress;

    public AddressIteratorConverter(Program iteratorsProgram, AddressIterator iterator, Program otherProgram) {
        this.iteratorsProgram = iteratorsProgram;
        this.iterator = iterator;
        this.otherProgram = otherProgram;
    }

    public boolean hasNext() {
        if (this.nextAddress != null) {
            return true;
        }
        while (this.iterator.hasNext()) {
            Address address = this.iterator.next();
            Address convertedAddress = SimpleDiffUtility.getCompatibleAddress((Program)this.iteratorsProgram, (Address)address, (Program)this.otherProgram);
            if (convertedAddress == null) continue;
            this.nextAddress = convertedAddress;
            return true;
        }
        return false;
    }

    public Address next() {
        if (this.nextAddress != null) {
            Address convertedAddress = this.nextAddress;
            this.nextAddress = null;
            return convertedAddress;
        }
        if (this.hasNext()) {
            return this.nextAddress;
        }
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Iterator<Address> iterator() {
        return this;
    }
}

