/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.flatapi;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.function.DeleteFunctionCmd;
import ghidra.app.cmd.label.DeleteLabelCmd;
import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.clear.ClearCmd;
import ghidra.app.plugin.core.clear.ClearOptions;
import ghidra.app.plugin.core.searchmem.RegExSearchData;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.AddressEvaluator;
import ghidra.program.util.string.FoundString;
import ghidra.program.util.string.FoundStringCallback;
import ghidra.program.util.string.PascalStringSearcher;
import ghidra.program.util.string.StringSearcher;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.ListAccumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.search.memory.MemSearchResult;
import ghidra.util.search.memory.RegExMemSearcherAlgorithm;
import ghidra.util.search.memory.SearchInfo;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class FlatProgramAPI {
    public static final int MAX_REFERENCES_TO = 4096;
    protected Program currentProgram;
    protected TaskMonitor monitor;
    private int transactionID = -1;

    protected FlatProgramAPI() {
    }

    public FlatProgramAPI(Program program) {
        this(program, TaskMonitor.DUMMY);
    }

    public FlatProgramAPI(Program program, TaskMonitor monitor) {
        this.currentProgram = program;
        this.monitor = monitor;
        AutoAnalysisManager.getAnalysisManager(program);
    }

    protected void set(Program program, TaskMonitor monitor) {
        this.currentProgram = program;
        this.monitor = monitor;
    }

    public Program getCurrentProgram() {
        return this.currentProgram;
    }

    public TaskMonitor getMonitor() {
        return this.monitor;
    }

    public final void start() {
        if (this.currentProgram == null) {
            return;
        }
        if (this.transactionID == -1) {
            this.transactionID = this.currentProgram.startTransaction(this.getClass().getName());
        }
    }

    public final void end(boolean commit) {
        if (this.currentProgram == null) {
            return;
        }
        if (this.transactionID != -1) {
            this.currentProgram.endTransaction(this.transactionID, commit);
            this.transactionID = -1;
        }
    }

    public final File getProgramFile() {
        File f = new File(this.currentProgram.getExecutablePath());
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public final boolean disassemble(Address address) {
        DisassembleCommand cmd = new DisassembleCommand(address, null, true);
        return cmd.applyTo((DomainObject)this.currentProgram, this.monitor);
    }

    @Deprecated
    public void analyze(Program program) {
        this.analyzeAll(program);
    }

    public void analyzeAll(Program program) {
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        mgr.reAnalyzeAll(null);
        this.analyzeChanges(program);
    }

    public void analyzeChanges(Program program) {
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        PluginTool analysisTool = mgr.getAnalysisTool();
        if (analysisTool == null || analysisTool.threadIsBackgroundTaskThread()) {
            mgr.startAnalysis(this.monitor, true);
        } else {
            mgr.waitForAnalysis(null, this.monitor);
        }
    }

    public final void clearListing(Address address) throws CancelledException {
        this.clearListing(address, address);
    }

    public final void clearListing(Address start, Address end) throws CancelledException {
        this.currentProgram.getListing().clearCodeUnits(start, end, false, this.monitor);
    }

    public final void clearListing(AddressSetView set) throws CancelledException {
        AddressRangeIterator iter = set.getAddressRanges();
        while (iter.hasNext() && !this.monitor.isCancelled()) {
            AddressRange range = (AddressRange)iter.next();
            this.clearListing(range.getMinAddress(), range.getMaxAddress());
        }
    }

    public final boolean clearListing(AddressSetView set, boolean code, boolean symbols, boolean comments, boolean properties, boolean functions, boolean registers, boolean equates, boolean userReferences, boolean analysisReferences, boolean importReferences, boolean defaultReferences, boolean bookmarks) {
        ClearOptions options = new ClearOptions();
        options.setClearCode(code);
        options.setClearSymbols(symbols);
        options.setClearComments(comments);
        options.setClearProperties(properties);
        options.setClearFunctions(functions);
        options.setClearRegisters(registers);
        options.setClearEquates(equates);
        options.setClearUserReferences(userReferences);
        options.setClearAnalysisReferences(analysisReferences);
        options.setClearImportReferences(importReferences);
        options.setClearDefaultReferences(defaultReferences);
        options.setClearBookmarks(bookmarks);
        ClearCmd cmd = new ClearCmd(set, options);
        return cmd.applyTo((DomainObject)this.currentProgram, this.monitor);
    }

    public final MemoryBlock createMemoryBlock(String name, Address start, InputStream input, long length, boolean overlay) throws Exception {
        if (input == null) {
            return this.currentProgram.getMemory().createUninitializedBlock(name, start, length, overlay);
        }
        return this.currentProgram.getMemory().createInitializedBlock(name, start, input, length, this.monitor, overlay);
    }

    public final MemoryBlock createMemoryBlock(String name, Address start, byte[] bytes, boolean overlay) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        return this.currentProgram.getMemory().createInitializedBlock(name, start, (InputStream)input, (long)bytes.length, this.monitor, overlay);
    }

    public final MemoryBlock getMemoryBlock(String name) {
        return this.currentProgram.getMemory().getBlock(name);
    }

    public final MemoryBlock getMemoryBlock(Address address) {
        return this.currentProgram.getMemory().getBlock(address);
    }

    public final MemoryBlock[] getMemoryBlocks() {
        return this.currentProgram.getMemory().getBlocks();
    }

    public final void removeMemoryBlock(MemoryBlock block) throws Exception {
        this.currentProgram.getMemory().removeBlock(block, this.monitor);
    }

    public final Symbol createLabel(Address address, String name, boolean makePrimary) throws Exception {
        return this.createLabel(address, name, makePrimary, SourceType.USER_DEFINED);
    }

    @Deprecated
    public final Symbol createSymbol(Address address, String name, boolean makePrimary) throws Exception {
        return this.createLabel(address, name, makePrimary);
    }

    public final Symbol createLabel(Address address, String name, boolean makePrimary, SourceType sourceType) throws Exception {
        return this.createLabel(address, name, null, makePrimary, sourceType);
    }

    public final Symbol createLabel(Address address, String name, Namespace namespace, boolean makePrimary, SourceType sourceType) throws Exception {
        SetLabelPrimaryCmd cmd;
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        Symbol symbol = symbolTable.createLabel(address, name, namespace, sourceType);
        if (makePrimary && !symbol.isPrimary() && (cmd = new SetLabelPrimaryCmd(address, name, namespace)).applyTo((DomainObject)this.currentProgram)) {
            symbol = cmd.getSymbol();
        }
        return symbol;
    }

    @Deprecated
    public final Symbol createSymbol(Address address, String name, boolean makePrimary, boolean makeUnique, SourceType sourceType) throws Exception {
        return this.createLabel(address, name, makePrimary, sourceType);
    }

    public final void addEntryPoint(Address address) {
        this.currentProgram.getSymbolTable().addExternalEntryPoint(address);
    }

    public final void removeEntryPoint(Address address) {
        this.currentProgram.getSymbolTable().removeExternalEntryPoint(address);
    }

    public final boolean removeSymbol(Address address, String name) {
        DeleteLabelCmd cmd = new DeleteLabelCmd(address, name);
        return cmd.applyTo((DomainObject)this.currentProgram);
    }

    public final boolean setPlateComment(Address address, String comment) {
        SetCommentCmd cmd = new SetCommentCmd(address, 3, comment);
        return cmd.applyTo((DomainObject)this.currentProgram);
    }

    public final boolean setPreComment(Address address, String comment) {
        SetCommentCmd cmd = new SetCommentCmd(address, 1, comment);
        return cmd.applyTo((DomainObject)this.currentProgram);
    }

    public final boolean setPostComment(Address address, String comment) {
        SetCommentCmd cmd = new SetCommentCmd(address, 2, comment);
        return cmd.applyTo((DomainObject)this.currentProgram);
    }

    public final boolean setEOLComment(Address address, String comment) {
        SetCommentCmd cmd = new SetCommentCmd(address, 0, comment);
        return cmd.applyTo((DomainObject)this.currentProgram);
    }

    public final boolean setRepeatableComment(Address address, String comment) {
        SetCommentCmd cmd = new SetCommentCmd(address, 4, comment);
        return cmd.applyTo((DomainObject)this.currentProgram);
    }

    public final String getPlateComment(Address address) {
        return this.currentProgram.getListing().getComment(3, address);
    }

    public final String getPreComment(Address address) {
        return this.currentProgram.getListing().getComment(1, address);
    }

    public final String getPostComment(Address address) {
        return this.currentProgram.getListing().getComment(2, address);
    }

    public final String getEOLComment(Address address) {
        return this.currentProgram.getListing().getComment(0, address);
    }

    public final String getRepeatableComment(Address address) {
        return this.currentProgram.getListing().getComment(4, address);
    }

    public final Address find(Address start, byte value) {
        return this.find(start, new byte[]{value});
    }

    public final Address find(Address start, byte[] values) {
        if (start == null) {
            start = this.currentProgram.getMinAddress();
        }
        return this.currentProgram.getMemory().findBytes(start, values, null, true, this.monitor);
    }

    public final Address findBytes(Address start, String byteString) {
        Address[] matchingAddresses = this.findBytes(start, byteString, 1);
        if (matchingAddresses.length == 0) {
            return null;
        }
        return matchingAddresses[0];
    }

    public final Address[] findBytes(Address start, String byteString, int matchLimit) {
        return this.findBytes(start, byteString, matchLimit, 1);
    }

    public final Address[] findBytes(Address start, String byteString, int matchLimit, int alignment) {
        if (start == null) {
            start = this.currentProgram.getMinAddress();
        }
        if (matchLimit <= 0) {
            matchLimit = 500;
        }
        Memory memory = this.currentProgram.getMemory();
        AddressFactory factory = this.currentProgram.getAddressFactory();
        AddressSet addressRange = factory.getAddressSet(start, memory.getMaxAddress());
        Address[] bytes = this.findBytes((AddressSetView)addressRange, byteString, matchLimit, alignment, false);
        return bytes;
    }

    public final Address[] findBytes(AddressSetView set, String byteString, int matchLimit, int alignment) {
        return this.findBytes(set, byteString, matchLimit, alignment, false);
    }

    public final Address[] findBytes(AddressSetView set, String byteString, int matchLimit, int alignment, boolean searchAcrossAddressGaps) {
        if (matchLimit <= 0) {
            matchLimit = 500;
        }
        RegExSearchData searchData = RegExSearchData.createRegExSearchData(byteString);
        SearchInfo searchInfo = new SearchInfo(searchData, matchLimit, false, true, alignment, true, null);
        Memory memory = this.currentProgram.getMemory();
        AddressSet intersection = memory.getLoadedAndInitializedAddressSet().intersect(set);
        RegExMemSearcherAlgorithm searcher = new RegExMemSearcherAlgorithm(searchInfo, (AddressSetView)intersection, this.currentProgram, searchAcrossAddressGaps);
        ListAccumulator accumulator = new ListAccumulator();
        searcher.search((Accumulator<MemSearchResult>)accumulator, this.monitor);
        List<Address> addresses = accumulator.stream().map(r -> r.getAddress()).collect(Collectors.toList());
        return addresses.toArray(new Address[addresses.size()]);
    }

    public final Address find(String text) {
        Address addr = null;
        this.monitor.setMessage("Searching plate comments...");
        addr = this.findComment(3, text);
        if (addr != null) {
            return addr;
        }
        this.monitor.setMessage("Searching pre comments...");
        addr = this.findComment(1, text);
        if (addr != null) {
            return addr;
        }
        this.monitor.setMessage("Searching labels...");
        SymbolIterator symiter = this.currentProgram.getSymbolTable().getAllSymbols(true);
        while (symiter.hasNext() && !this.monitor.isCancelled()) {
            Symbol sym = symiter.next();
            if (!this.currentProgram.getMemory().contains(sym.getAddress()) || sym.getName().indexOf(text) < 0) continue;
            return sym.getAddress();
        }
        this.monitor.setMessage("Searching code units...");
        CodeUnitIterator cuIter = this.currentProgram.getListing().getCodeUnits(true);
        while (cuIter.hasNext() && !this.monitor.isCancelled()) {
            String str;
            Data data;
            Object obj;
            CodeUnit cu = cuIter.next();
            if (cu.getMnemonicString().indexOf(text) >= 0) {
                return cu.getMinAddress();
            }
            if (cu instanceof Instruction) {
                Instruction instr = (Instruction)cu;
                int nOps = instr.getNumOperands();
                for (int i = 0; i < nOps; ++i) {
                    Object[] objs;
                    for (Object element : objs = instr.getOpObjects(i)) {
                        String str2 = element.toString();
                        if (str2 == null || str2.indexOf(text) < 0) continue;
                        return instr.getMinAddress();
                    }
                }
            }
            if (!(cu instanceof Data) || (obj = (data = (Data)cu).getValue()) == null || (str = obj.toString()) == null || str.indexOf(text) < 0) continue;
            return data.getMinAddress();
        }
        this.monitor.setMessage("Searching eol comments...");
        addr = this.findComment(0, text);
        if (addr != null) {
            return addr;
        }
        this.monitor.setMessage("Searching repeatable comments...");
        addr = this.findComment(4, text);
        if (addr != null) {
            return addr;
        }
        this.monitor.setMessage("Searching post comments...");
        addr = this.findComment(2, text);
        if (addr != null) {
            return addr;
        }
        return null;
    }

    public List<FoundString> findStrings(AddressSetView addressSet, int minimumStringLength, int alignment, boolean requireNullTermination, boolean includeAllCharWidths) {
        ArrayList<FoundString> list = new ArrayList<FoundString>();
        FoundStringCallback foundStringCallback = foundString -> list.add(foundString);
        StringSearcher searcher = new StringSearcher(this.currentProgram, minimumStringLength, alignment, includeAllCharWidths, requireNullTermination);
        searcher.search(addressSet, foundStringCallback, true, this.monitor);
        return list;
    }

    public List<FoundString> findPascalStrings(AddressSetView addressSet, int minimumStringLength, int alignment, boolean includePascalUnicode) {
        ArrayList<FoundString> list = new ArrayList<FoundString>();
        FoundStringCallback foundStringCallback = foundString -> list.add(foundString);
        PascalStringSearcher searcher = new PascalStringSearcher(this.currentProgram, minimumStringLength, alignment, includePascalUnicode);
        searcher.search(addressSet, foundStringCallback, true, this.monitor);
        return list;
    }

    public final Function createFunction(Address entryPoint, String name) {
        CreateFunctionCmd cmd = new CreateFunctionCmd(name, entryPoint, null, name != null ? SourceType.USER_DEFINED : SourceType.DEFAULT);
        if (cmd.applyTo((DomainObject)this.currentProgram, this.monitor)) {
            return this.currentProgram.getListing().getFunctionAt(entryPoint);
        }
        return null;
    }

    public final void removeFunction(Function function) {
        this.removeFunctionAt(function.getEntryPoint());
    }

    public final void removeFunctionAt(Address entryPoint) {
        DeleteFunctionCmd cmd = new DeleteFunctionCmd(entryPoint);
        cmd.applyTo((DomainObject)this.currentProgram);
    }

    public final Function getFunctionAt(Address entryPoint) {
        return this.currentProgram.getListing().getFunctionAt(entryPoint);
    }

    public final Function getFunctionContaining(Address address) {
        return this.currentProgram.getListing().getFunctionContaining(address);
    }

    public final Function getFunctionBefore(Function function) {
        if (function == null) {
            return null;
        }
        Address start = function.getEntryPoint();
        return this.getFunctionBefore(start);
    }

    public final Function getFunctionBefore(Address address) {
        FunctionIterator iterator = this.currentProgram.getListing().getFunctions(address, false);
        if (!iterator.hasNext()) {
            return null;
        }
        Function func = (Function)iterator.next();
        if (address.equals((Object)func.getEntryPoint())) {
            func = null;
            if (iterator.hasNext()) {
                func = (Function)iterator.next();
            }
        }
        return func;
    }

    public final Function getFunctionAfter(Function function) {
        if (function == null) {
            return null;
        }
        Address start = function.getEntryPoint();
        return this.getFunctionAfter(start);
    }

    public final Function getFunctionAfter(Address address) {
        FunctionIterator iterator = this.currentProgram.getListing().getFunctions(address, true);
        if (!iterator.hasNext()) {
            return null;
        }
        Function func = (Function)iterator.next();
        if (address.equals((Object)func.getEntryPoint())) {
            func = null;
            if (iterator.hasNext()) {
                func = (Function)iterator.next();
            }
        }
        return func;
    }

    @Deprecated
    public final Function getFunction(String name) {
        List globalFunctions = this.currentProgram.getListing().getGlobalFunctions(name);
        return globalFunctions.isEmpty() ? null : (Function)globalFunctions.get(0);
    }

    public final List<Function> getGlobalFunctions(String name) {
        return this.currentProgram.getListing().getGlobalFunctions(name);
    }

    public final Function getFirstFunction() {
        FunctionIterator iterator = this.currentProgram.getListing().getFunctions(true);
        if (iterator.hasNext()) {
            return (Function)iterator.next();
        }
        return null;
    }

    public final Function getLastFunction() {
        FunctionIterator iterator = this.currentProgram.getListing().getFunctions(false);
        if (iterator.hasNext()) {
            return (Function)iterator.next();
        }
        return null;
    }

    public final Instruction getFirstInstruction() {
        Address address = this.currentProgram.getMinAddress();
        InstructionIterator iterator = this.currentProgram.getListing().getInstructions(address, true);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public final Instruction getFirstInstruction(Function function) {
        Address address = function.getEntryPoint();
        return this.getInstructionAt(address);
    }

    public final Instruction getLastInstruction() {
        Address address = this.currentProgram.getMinAddress();
        InstructionIterator iterator = this.currentProgram.getListing().getInstructions(address, false);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public final Instruction getInstructionAt(Address address) {
        return this.currentProgram.getListing().getInstructionAt(address);
    }

    public final Instruction getInstructionContaining(Address address) {
        return this.currentProgram.getListing().getInstructionContaining(address);
    }

    public final Instruction getInstructionBefore(Instruction instruction) {
        return this.getInstructionBefore(instruction.getMinAddress());
    }

    public final Instruction getInstructionBefore(Address address) {
        return this.currentProgram.getListing().getInstructionBefore(address);
    }

    public final Instruction getInstructionAfter(Instruction instruction) {
        return this.getInstructionAfter(instruction.getMaxAddress());
    }

    public final Instruction getInstructionAfter(Address address) {
        return this.currentProgram.getListing().getInstructionAfter(address);
    }

    public final Data getFirstData() {
        Address address = this.currentProgram.getMinAddress();
        DataIterator iterator = this.currentProgram.getListing().getData(address, true);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public final Data getLastData() {
        Address address = this.currentProgram.getMaxAddress();
        DataIterator iterator = this.currentProgram.getListing().getData(address, false);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public final Data getDataAt(Address address) {
        return this.currentProgram.getListing().getDefinedDataAt(address);
    }

    public final Data getDataContaining(Address address) {
        return this.currentProgram.getListing().getDefinedDataContaining(address);
    }

    public final Data getDataBefore(Data data) {
        return this.getDataBefore(data.getMinAddress());
    }

    public final Data getDataBefore(Address address) {
        return this.currentProgram.getListing().getDefinedDataBefore(address);
    }

    public final Data getDataAfter(Data data) {
        return this.getDataAfter(data.getMaxAddress());
    }

    public final Data getDataAfter(Address address) {
        return this.currentProgram.getListing().getDefinedDataAfter(address);
    }

    public final Data getUndefinedDataAt(Address address) {
        return this.currentProgram.getListing().getUndefinedDataAt(address);
    }

    public final Data getUndefinedDataBefore(Address address) {
        return this.currentProgram.getListing().getUndefinedDataBefore(address, this.monitor);
    }

    public final Data getUndefinedDataAfter(Address address) {
        return this.currentProgram.getListing().getUndefinedDataAfter(address, this.monitor);
    }

    @Deprecated
    public final Symbol getSymbolAt(Address address, String name) {
        SymbolIterator symbols = this.currentProgram.getSymbolTable().getSymbolsAsIterator(address);
        for (Symbol symbol : symbols) {
            if (!symbol.getName().equals(name)) continue;
            return symbol;
        }
        return null;
    }

    public final Symbol getSymbolAt(Address address, String name, Namespace namespace) {
        return this.currentProgram.getSymbolTable().getSymbol(name, address, namespace);
    }

    public final Symbol getSymbolAfter(Symbol symbol) {
        return this.getSymbolAfter(symbol.getAddress());
    }

    public final Symbol getSymbolAfter(Address address) {
        SymbolIterator iterator = this.currentProgram.getSymbolTable().getPrimarySymbolIterator(address.add(1L), true);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public final Symbol getSymbolBefore(Symbol symbol) {
        return this.getSymbolBefore(symbol.getAddress());
    }

    public final Symbol getSymbolBefore(Address address) {
        SymbolIterator iterator = this.currentProgram.getSymbolTable().getSymbolIterator(address.subtract(1L), false);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public final Symbol getSymbolAt(Address address) {
        return this.currentProgram.getSymbolTable().getPrimarySymbol(address);
    }

    @Deprecated
    public final Symbol getSymbol(String name, Namespace namespace) {
        List symbols = this.currentProgram.getSymbolTable().getSymbols(name, namespace);
        if (symbols.size() == 1) {
            return (Symbol)symbols.get(0);
        }
        if (symbols.size() > 1) {
            throw new IllegalStateException("There are multiple symbols named " + name + " in namespace " + namespace);
        }
        return null;
    }

    public final List<Symbol> getSymbols(String name, Namespace namespace) {
        return this.currentProgram.getSymbolTable().getSymbols(name, namespace);
    }

    public final Namespace getNamespace(Namespace parent, String namespaceName) {
        return this.currentProgram.getSymbolTable().getNamespace(namespaceName, parent);
    }

    @Deprecated
    public final ProgramFragment createFragment(String fragmentName, Address start, Address end) throws DuplicateNameException, NotFoundException {
        ProgramModule module = this.currentProgram.getListing().getDefaultRootModule();
        return this.createFragment(module, fragmentName, start, end);
    }

    public final ProgramFragment createFragment(String fragmentName, Address start, long length) throws DuplicateNameException, NotFoundException {
        ProgramModule module = this.currentProgram.getListing().getDefaultRootModule();
        return this.createFragment(module, fragmentName, start, length);
    }

    @Deprecated
    public final ProgramFragment createFragment(ProgramModule module, String fragmentName, Address start, Address end) throws DuplicateNameException, NotFoundException {
        ProgramFragment fragment = this.getFragment(module, fragmentName);
        if (fragment == null) {
            fragment = module.createFragment(fragmentName);
        }
        fragment.move(start, end.subtract(1L));
        return fragment;
    }

    public final ProgramFragment createFragment(ProgramModule module, String fragmentName, Address start, long length) throws DuplicateNameException, NotFoundException {
        ProgramFragment fragment = this.getFragment(module, fragmentName);
        if (fragment == null) {
            fragment = module.createFragment(fragmentName);
        }
        fragment.move(start, start.add(length - 1L));
        return fragment;
    }

    public final ProgramFragment getFragment(ProgramModule module, String fragmentName) {
        Group[] groups;
        for (Group group : groups = module.getChildren()) {
            if (!group.getName().equals(fragmentName)) continue;
            return (ProgramFragment)group;
        }
        return null;
    }

    public final AddressSet createAddressSet() {
        return new AddressSet();
    }

    public final AddressFactory getAddressFactory() {
        if (this.currentProgram != null) {
            return this.currentProgram.getAddressFactory();
        }
        return null;
    }

    public final DataType[] getDataTypes(String name) {
        ArrayList list = new ArrayList();
        this.currentProgram.getDataTypeManager().findDataTypes(name, list);
        DataType[] dtarr = new DataType[list.size()];
        list.toArray(dtarr);
        return dtarr;
    }

    public final Data createData(Address address, DataType datatype) throws Exception {
        Listing listing = this.currentProgram.getListing();
        Data d = listing.getDefinedDataAt(address);
        if (d != null) {
            if (d.getDataType().isEquivalent(datatype)) {
                return d;
            }
            throw new CodeUnitInsertionException("Data conflict at address " + address);
        }
        return listing.createData(address, datatype);
    }

    public final Data createByte(Address address) throws Exception {
        return this.createData(address, (DataType)new ByteDataType());
    }

    public final Data createWord(Address address) throws Exception {
        return this.createData(address, (DataType)new WordDataType());
    }

    public final Data createDWord(Address address) throws Exception {
        return this.createData(address, (DataType)new DWordDataType());
    }

    public final void createDwords(Address start, int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            Address address = start.add((long)(i * DWordDataType.dataType.getLength()));
            this.createDWord(address);
        }
    }

    public final Data createQWord(Address address) throws Exception {
        return this.createData(address, (DataType)new QWordDataType());
    }

    public final Data createFloat(Address address) throws Exception {
        return this.createData(address, (DataType)new FloatDataType());
    }

    public final Data createDouble(Address address) throws Exception {
        return this.createData(address, (DataType)new DoubleDataType());
    }

    public final Data createChar(Address address) throws Exception {
        return this.createData(address, (DataType)new CharDataType());
    }

    public final Data createAsciiString(Address address) throws Exception {
        return this.createData(address, (DataType)new TerminatedStringDataType());
    }

    public final Data createAsciiString(Address address, int length) throws CodeUnitInsertionException {
        Data d;
        Listing listing = this.currentProgram.getListing();
        StringDataType dt = StringDataType.dataType;
        if (length <= 0) {
            dt = TerminatedStringDataType.dataType;
            length = -1;
        }
        if ((d = listing.getDefinedDataAt(address)) != null) {
            if (d.getDataType().isEquivalent((DataType)dt) || length > 0 && length != d.getLength()) {
                throw new CodeUnitInsertionException("Data conflict at address " + address);
            }
        } else {
            d = listing.createData(address, (DataType)dt, length);
        }
        return d;
    }

    public final Data createUnicodeString(Address address) throws Exception {
        return this.createData(address, (DataType)new TerminatedUnicodeDataType());
    }

    public final void removeData(Data data) throws Exception {
        this.clearListing(data.getMinAddress(), data.getMaxAddress());
    }

    public final void removeDataAt(Address address) throws Exception {
        Data data = this.getDataContaining(address);
        if (data != null) {
            this.removeData(data);
        }
    }

    public final void removeInstruction(Instruction instruction) throws Exception {
        this.clearListing(instruction.getMinAddress(), instruction.getMaxAddress());
    }

    public final void removeInstructionAt(Address address) throws Exception {
        Instruction instruction = this.getInstructionContaining(address);
        if (instruction != null) {
            this.removeInstruction(instruction);
        }
    }

    public final Reference addInstructionXref(Address from, Address to, int opIndex, FlowType type) {
        return this.currentProgram.getReferenceManager().addMemoryReference(from, to, (RefType)type, SourceType.USER_DEFINED, opIndex);
    }

    public final Address toAddr(int offset) {
        return this.toAddr((long)offset & 0xFFFFFFFFL);
    }

    public final Address toAddr(long offset) {
        return this.currentProgram.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
    }

    public final Address toAddr(String addressString) {
        return AddressEvaluator.evaluate((Program)this.currentProgram, (String)addressString);
    }

    public final byte getByte(Address address) throws MemoryAccessException {
        return this.currentProgram.getMemory().getByte(address);
    }

    public final byte[] getBytes(Address address, int length) throws MemoryAccessException {
        byte[] bytes = new byte[length];
        this.currentProgram.getMemory().getBytes(address, bytes);
        return bytes;
    }

    public final void setByte(Address address, byte value) throws MemoryAccessException {
        this.currentProgram.getMemory().setByte(address, value);
    }

    public final void setBytes(Address address, byte[] values) throws MemoryAccessException {
        this.currentProgram.getMemory().setBytes(address, values);
    }

    public final short getShort(Address address) throws MemoryAccessException {
        return this.currentProgram.getMemory().getShort(address);
    }

    public final void setShort(Address address, short value) throws MemoryAccessException {
        this.currentProgram.getMemory().setShort(address, value);
    }

    public final int getInt(Address address) throws MemoryAccessException {
        return this.currentProgram.getMemory().getInt(address);
    }

    public final void setInt(Address address, int value) throws MemoryAccessException {
        this.currentProgram.getMemory().setInt(address, value);
    }

    public final long getLong(Address address) throws MemoryAccessException {
        return this.currentProgram.getMemory().getLong(address);
    }

    public final void setLong(Address address, long value) throws MemoryAccessException {
        this.currentProgram.getMemory().setLong(address, value);
    }

    public final float getFloat(Address address) throws MemoryAccessException {
        int bits = this.currentProgram.getMemory().getInt(address);
        return Float.intBitsToFloat(bits);
    }

    public final void setFloat(Address address, float value) throws MemoryAccessException {
        int bits = Float.floatToIntBits(value);
        this.currentProgram.getMemory().setInt(address, bits);
    }

    public final double getDouble(Address address) throws MemoryAccessException {
        long bits = this.currentProgram.getMemory().getLong(address);
        return Double.longBitsToDouble(bits);
    }

    public final void setDouble(Address address, double value) throws MemoryAccessException {
        long bits = Double.doubleToLongBits(value);
        this.currentProgram.getMemory().setLong(address, bits);
    }

    public final Reference[] getReferencesFrom(Address address) {
        return this.currentProgram.getReferenceManager().getReferencesFrom(address);
    }

    public final Reference[] getReferencesTo(Address address) {
        int count = this.currentProgram.getReferenceManager().getReferenceCountTo(address);
        if (count > 4096) {
            count = 4096;
        }
        int index = 0;
        Reference[] references = new Reference[count];
        ReferenceIterator iterator = this.currentProgram.getReferenceManager().getReferencesTo(address);
        while (iterator.hasNext()) {
            this.monitor.setMessage("Loading references to " + address + ": " + index + " of " + count);
            if (this.monitor.isCancelled() || index == 4096) break;
            references[index++] = iterator.next();
        }
        return references;
    }

    public final Reference getReference(Instruction instruction, Address toAddress) {
        Reference[] references;
        for (Reference reference : references = this.currentProgram.getReferenceManager().getReferencesFrom(instruction.getMinAddress())) {
            if (!reference.getToAddress().equals((Object)toAddress)) continue;
            return reference;
        }
        return null;
    }

    public final Reference getReference(Data data, Address toAddress) {
        Reference[] references;
        for (Reference reference : references = this.currentProgram.getReferenceManager().getReferencesFrom(data.getMinAddress())) {
            if (!reference.getToAddress().equals((Object)toAddress)) continue;
            return reference;
        }
        return null;
    }

    public final Reference createMemoryReference(Instruction instruction, int operandIndex, Address toAddress, RefType flowType) {
        ReferenceManager referenceManager = this.currentProgram.getReferenceManager();
        Reference ref = referenceManager.addMemoryReference(instruction.getMinAddress(), toAddress, flowType, SourceType.USER_DEFINED, operandIndex);
        return ref;
    }

    public final Reference createMemoryReference(Data data, Address toAddress, RefType dataRefType) {
        ReferenceManager referenceManager = this.currentProgram.getReferenceManager();
        Reference ref = referenceManager.addMemoryReference(data.getMinAddress(), toAddress, dataRefType, SourceType.USER_DEFINED, 0);
        return ref;
    }

    public final Reference createExternalReference(Instruction instruction, int operandIndex, String libraryName, String externalLabel, Address externalAddr) throws Exception {
        RefType refType = RefType.DATA;
        FlowType flowType = instruction.getFlowType();
        if (flowType.isComputed()) {
            if (flowType.isCall()) {
                refType = RefType.COMPUTED_CALL;
            } else if (flowType.isJump()) {
                refType = RefType.COMPUTED_JUMP;
            }
        } else if (flowType.isCall()) {
            refType = RefType.UNCONDITIONAL_CALL;
        } else if (flowType.isJump()) {
            refType = RefType.UNCONDITIONAL_JUMP;
        }
        return this.createExternalReference(instruction, operandIndex, libraryName, externalLabel, externalAddr, refType);
    }

    public final Reference createExternalReference(Instruction instruction, int operandIndex, String libraryName, String externalLabel, Address externalAddr, RefType refType) throws Exception {
        ReferenceManager referenceManager = this.currentProgram.getReferenceManager();
        Reference reference = referenceManager.addExternalReference(instruction.getMinAddress(), libraryName, externalLabel, externalAddr, SourceType.USER_DEFINED, operandIndex, refType);
        return reference;
    }

    public final Reference createExternalReference(Data data, String libraryName, String externalLabel, Address externalAddr) throws Exception {
        ReferenceManager referenceManager = this.currentProgram.getReferenceManager();
        Reference reference = referenceManager.addExternalReference(data.getMinAddress(), libraryName, externalLabel, externalAddr, SourceType.USER_DEFINED, 0, RefType.DATA);
        return reference;
    }

    public final Reference createStackReference(Instruction instruction, int operandIndex, int stackOffset, boolean isWrite) {
        ReferenceManager referenceManager = this.currentProgram.getReferenceManager();
        RefType type = isWrite ? RefType.WRITE : RefType.READ;
        Reference ref = referenceManager.addStackReference(instruction.getMinAddress(), operandIndex, stackOffset, type, SourceType.USER_DEFINED);
        return ref;
    }

    public final void removeReference(Reference reference) {
        this.currentProgram.getReferenceManager().delete(reference);
    }

    public final void setReferencePrimary(Reference reference) {
        this.currentProgram.getReferenceManager().setPrimary(reference, true);
    }

    public final void setReferencePrimary(Reference reference, boolean primary) {
        this.currentProgram.getReferenceManager().setPrimary(reference, primary);
    }

    public final Equate createEquate(Instruction instruction, int operandIndex, String equateName) throws Exception {
        Object[] operandObject;
        for (Object object : operandObject = instruction.getOpObjects(operandIndex)) {
            if (!(object instanceof Scalar)) continue;
            Scalar scalar = (Scalar)object;
            long scalarValue = scalar.getUnsignedValue();
            Equate equate = this.currentProgram.getEquateTable().createEquate(equateName, scalarValue);
            equate.addReference(instruction.getMinAddress(), operandIndex);
            return equate;
        }
        throw new InvalidInputException("Unable to create equate on non-scalar instruction operand at " + instruction.getMinAddress());
    }

    public final Equate createEquate(Data data, String equateName) throws Exception {
        Object value = data.getValue();
        if (value instanceof Scalar) {
            Scalar scalar = (Scalar)value;
            long scalarValue = scalar.getUnsignedValue();
            Equate equate = this.currentProgram.getEquateTable().createEquate(equateName, scalarValue);
            equate.addReference(data.getMinAddress(), 0);
            return equate;
        }
        throw new InvalidInputException("Unable to create equate on non-scalar value at " + data.getMinAddress());
    }

    public final Equate getEquate(Instruction instruction, int operandIndex, long value) {
        return this.currentProgram.getEquateTable().getEquate(instruction.getMinAddress(), operandIndex, value);
    }

    public final List<Equate> getEquates(Instruction instruction, int operandIndex) {
        return this.currentProgram.getEquateTable().getEquates(instruction.getMinAddress(), operandIndex);
    }

    public final Equate getEquate(Data data) {
        Object obj = data.getValue();
        if (obj instanceof Scalar) {
            return this.currentProgram.getEquateTable().getEquate(data.getMinAddress(), 0, ((Scalar)obj).getValue());
        }
        return null;
    }

    public final void removeEquate(Instruction instruction, int operandIndex, long value) {
        Address address = instruction.getMinAddress();
        Equate equate = this.currentProgram.getEquateTable().getEquate(address, operandIndex, value);
        equate.removeReference(address, operandIndex);
        if (equate.getReferenceCount() == 0) {
            this.currentProgram.getEquateTable().removeEquate(equate.getName());
        }
    }

    public final void removeEquates(Instruction instruction, int operandIndex) {
        Address address = instruction.getMinAddress();
        List equates = this.currentProgram.getEquateTable().getEquates(address, operandIndex);
        for (Equate equate : equates) {
            equate.removeReference(address, operandIndex);
            if (equate.getReferenceCount() != 0 || equate.getReferenceCount() != 0) continue;
            this.currentProgram.getEquateTable().removeEquate(equate.getName());
        }
    }

    public final void removeEquate(Data data) {
        Address address = data.getMinAddress();
        List equates = this.currentProgram.getEquateTable().getEquates(address, 0);
        for (Equate equate : equates) {
            equate.removeReference(address, 0);
            if (equate.getReferenceCount() != 0 || equate.getReferenceCount() != 0) continue;
            this.currentProgram.getEquateTable().removeEquate(equate.getName());
        }
    }

    public final Bookmark createBookmark(Address address, String category, String note) {
        Bookmark[] existingBookmarks = this.getBookmarks(address);
        if (existingBookmarks != null && existingBookmarks.length > 0) {
            existingBookmarks[0].set(category, note);
            return existingBookmarks[0];
        }
        BookmarkManager bkm = this.currentProgram.getBookmarkManager();
        return bkm.setBookmark(address, "Note", category, note);
    }

    public final Bookmark[] getBookmarks(Address address) {
        return this.currentProgram.getBookmarkManager().getBookmarks(address, "Note");
    }

    public final void removeBookmark(Bookmark bookmark) {
        this.currentProgram.getBookmarkManager().removeBookmark(bookmark);
    }

    public final FileDataTypeManager openDataTypeArchive(File archiveFile, boolean readOnly) throws Exception {
        FileDataTypeManager dtfm = FileDataTypeManager.openFileArchive((File)archiveFile, (!readOnly ? 1 : 0) != 0);
        return dtfm;
    }

    public void saveProgram(Program program) throws Exception {
        this.saveProgram(program, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProgram(Program program, List<String> path) throws Exception {
        if (program == null) {
            return;
        }
        if (program.getDomainFile().isInWritableProject()) {
            if (program == this.currentProgram) {
                this.end(true);
            }
            try {
                program.save(this.getClass().getName(), this.monitor);
            }
            finally {
                if (program == this.currentProgram) {
                    this.start();
                }
            }
            return;
        }
        DomainFolder folder = this.getProjectRootFolder();
        if (path != null) {
            for (String folderName : path) {
                if (folderName == null || folderName.isEmpty()) continue;
                DomainFolder existingFolder = folder.getFolder(folderName);
                if (existingFolder == null) {
                    folder = folder.createFolder(folderName);
                    continue;
                }
                folder = existingFolder;
            }
        }
        if (program == this.currentProgram) {
            this.end(true);
        }
        try {
            folder.createFile(program.getName(), (DomainObject)program, this.monitor);
        }
        catch (DuplicateFileException e) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MMM.yyyy_HH.mm.ss");
            String time = formatter.format(new Date());
            folder.createFile(program.getName() + "_" + time, (DomainObject)program, this.monitor);
        }
        finally {
            if (program == this.currentProgram) {
                this.start();
            }
        }
        this.monitor.setCancelEnabled(true);
        folder.setActive();
    }

    public DomainFolder getProjectRootFolder() {
        Project project = AppInfo.getActiveProject();
        ProjectData projectData = project.getProjectData();
        DomainFolder folder = projectData.getRootFolder();
        return folder;
    }

    private Address findComment(int type, String text) {
        Listing listing = this.currentProgram.getListing();
        Memory memory = this.currentProgram.getMemory();
        AddressIterator iter = listing.getCommentAddressIterator(type, (AddressSetView)memory, true);
        while (iter.hasNext() && !this.monitor.isCancelled()) {
            Address addr = iter.next();
            String plate = listing.getComment(type, addr);
            if (plate.indexOf(text) < 0) continue;
            return addr;
        }
        return null;
    }
}

