/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.tree.GTreeNode;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FSBRootNode
extends FSBNode {
    private FileSystemRef fsRef;
    private FSBFileNode prevNode;
    private List<FSBRootNode> subRootNodes = new ArrayList<FSBRootNode>();
    private FSBRootNode modelNode;

    FSBRootNode(FileSystemRef fsRef) {
        this(fsRef, null);
    }

    FSBRootNode(FileSystemRef fsRef, FSBFileNode prevNode) {
        this.fsRef = fsRef;
        this.prevNode = prevNode;
        this.modelNode = this;
    }

    public GTreeNode clone() throws CloneNotSupportedException {
        FSBRootNode clone = (FSBRootNode)super.clone();
        clone.fsRef = null;
        return clone;
    }

    public void dispose() {
        this.releaseFSRefsIfModelNode();
        super.dispose();
    }

    void swapBackPrevModelNodeAndDispose() {
        if (this != this.modelNode) {
            this.modelNode.swapBackPrevModelNodeAndDispose();
            return;
        }
        int indexInParent = this.getIndexInParent();
        GTreeNode parent = this.getParent();
        parent.removeNode((GTreeNode)this);
        parent.addNode(indexInParent, (GTreeNode)this.prevNode);
        this.dispose();
    }

    public FileSystemRef getFSRef() {
        return this.modelNode.fsRef;
    }

    private void releaseFSRefsIfModelNode() {
        if (this != this.modelNode) {
            return;
        }
        for (FSBRootNode subFSBRootNode : this.subRootNodes) {
            subFSBRootNode.releaseFSRefsIfModelNode();
        }
        this.subRootNodes.clear();
        FileSystemService.getInstance().releaseFileSystemImmediate(this.fsRef);
        this.fsRef = null;
    }

    @Override
    public void updateFileAttributes(TaskMonitor monitor) throws CancelledException {
        if (this != this.modelNode) {
            this.modelNode.updateFileAttributes(monitor);
            return;
        }
        for (GTreeNode node : this.getChildren()) {
            monitor.checkCanceled();
            if (!(node instanceof FSBFileNode)) continue;
            ((FSBFileNode)node).updateFileAttributes(monitor);
        }
    }

    @Override
    public String getName() {
        return this.modelNode.fsRef != null && !this.modelNode.fsRef.isClosed() ? this.modelNode.fsRef.getFilesystem().getName() : " Missing ";
    }

    @Override
    public String getToolTip() {
        return this.getName();
    }

    public boolean isLeaf() {
        return false;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        if (this.fsRef != null) {
            try {
                return FSBNode.createNodesFromFileList(this.fsRef.getFilesystem().getListing(null), monitor);
            }
            catch (IOException e) {
                FSUtilities.displayException((Object)this, null, "Error Opening File System", "Problem generating children at root of file system", e);
            }
        }
        return List.of();
    }

    @Override
    public FSRL getFSRL() {
        return this.modelNode.fsRef.getFilesystem().getFSRL();
    }
}

