/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.services.FileImporterService;
import ghidra.app.util.FileOpenDataFlavorHandler;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DataTreeFlavorHandler;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.List;
import util.CollectionUtils;

public final class JavaFileListHandler
implements DataTreeFlavorHandler,
FileOpenDataFlavorHandler {
    public void handle(PluginTool tool, Object transferData, DropTargetDropEvent e, DataFlavor f) {
        FileImporterService importer = (FileImporterService)tool.getService(FileImporterService.class);
        if (importer == null) {
            Msg.showError((Object)this, null, (String)"Could Not Import", (Object)"Could not find Importer Service");
            return;
        }
        DomainFolder folder = tool.getProject().getProjectData().getRootFolder();
        this.doImport(importer, folder, transferData);
    }

    public void handle(PluginTool tool, DataTree dataTree, GTreeNode destinationNode, Object transferData, int dropAction) {
        FileImporterService importer = (FileImporterService)tool.getService(FileImporterService.class);
        if (importer == null) {
            Msg.showError((Object)this, (Component)dataTree, (String)"Could Not Import", (Object)"Could not find Importer Service");
            return;
        }
        DomainFolder folder = this.getDomainFolder(destinationNode);
        this.doImport(importer, folder, transferData);
    }

    private void doImport(FileImporterService importer, DomainFolder folder, Object files) {
        List fileList = CollectionUtils.asList((List)((List)files), File.class);
        Swing.runLater(() -> {
            if (fileList.size() == 1 && ((File)fileList.get(0)).isFile()) {
                importer.importFile(folder, (File)fileList.get(0));
            } else {
                importer.importFiles(folder, fileList);
            }
        });
    }

    private DomainFolder getDomainFolder(GTreeNode destinationNode) {
        if (destinationNode instanceof DomainFolderNode) {
            return ((DomainFolderNode)destinationNode).getDomainFolder();
        }
        if (destinationNode instanceof DomainFileNode) {
            DomainFolderNode parent = (DomainFolderNode)destinationNode.getParent();
            return parent.getDomainFolder();
        }
        return null;
    }
}

