/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.FunctionProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Function;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.FunctionSignatureSourceFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;

public class FunctionSignatureSourceFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Signature Source";
    private Color literalColor;

    public FunctionSignatureSourceFieldFactory() {
        super(FIELD_NAME);
    }

    public FunctionSignatureSourceFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.literalColor = displayOptions.getColor(OptionsGui.SEPARATOR.getColorOptionName(), OptionsGui.SEPARATOR.getDefaultColor());
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
        this.literalColor = options.getColor(OptionsGui.SEPARATOR.getColorOptionName(), Color.BLACK);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        if (!this.enabled) {
            return null;
        }
        if (proxy instanceof FunctionProxy) {
            FunctionProxy functionProxy = (FunctionProxy)proxy;
            Function function = functionProxy.getObject();
            SourceType source = function.getSignatureSource();
            String sourceStr = "<" + source.toString() + ">";
            AttributedString as = new AttributedString(sourceStr, this.literalColor, this.getMetrics());
            return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)new TextFieldElement(as, 0, 0), this.startX + varWidth, this.width, this.hlProvider);
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj<?> proxy = bf.getProxy();
        if (proxy instanceof FunctionProxy) {
            FunctionProxy functionProxy = (FunctionProxy)proxy;
            Function function = functionProxy.getObject();
            return new FunctionSignatureSourceFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), function.getSignatureSource().toString(), col);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (loc instanceof FunctionSignatureSourceFieldLocation) {
            FunctionSignatureSourceFieldLocation sigSourceLoc = (FunctionSignatureSourceFieldLocation)loc;
            return new FieldLocation(index, fieldNum, 0, sigSourceLoc.getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Function.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 2;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new FunctionSignatureSourceFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }

    @Override
    public Color getDefaultColor() {
        return OptionsGui.SEPARATOR.getDefaultColor();
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
    }
}

