/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffBuilder;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.util.HTMLUtilities;
import ghidra.util.StringUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TypeDefDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    private final TypeDef typeDef;
    private List<String> warningLines;
    protected List<ValidatableLine> headerContent;
    protected List<ValidatableLine> bodyContent;
    private String truncatedHtmlData;

    private TypeDefDataTypeHTMLRepresentation(TypeDef typeDef, List<String> warningLines, List<ValidatableLine> headerLines, List<ValidatableLine> bodyLines) {
        this.typeDef = typeDef;
        this.warningLines = warningLines;
        this.headerContent = headerLines;
        this.bodyContent = bodyLines;
        List<ValidatableLine> trimmedHeaderContent = this.buildHeaderText((DataType)typeDef, true);
        List<ValidatableLine> trimmedBodyContent = this.buildBodyText(this.getBaseDataType(), true);
        this.truncatedHtmlData = TypeDefDataTypeHTMLRepresentation.buildHTMLText(typeDef, warningLines, trimmedHeaderContent, trimmedBodyContent, true);
    }

    public TypeDefDataTypeHTMLRepresentation(TypeDef typeDef) {
        this.typeDef = typeDef;
        this.warningLines = this.buildWarnings();
        this.headerContent = this.buildHeaderText((DataType)typeDef, false);
        this.bodyContent = this.buildBodyText(this.getBaseDataType(), false);
        this.originalHTMLData = TypeDefDataTypeHTMLRepresentation.buildHTMLText(typeDef, this.warningLines, this.headerContent, this.bodyContent, false);
        List<ValidatableLine> trimmedHeaderContent = this.buildHeaderText((DataType)typeDef, true);
        List<ValidatableLine> trimmedBodyContent = this.buildBodyText(this.getBaseDataType(), true);
        this.truncatedHtmlData = TypeDefDataTypeHTMLRepresentation.buildHTMLText(typeDef, this.warningLines, trimmedHeaderContent, trimmedBodyContent, true);
    }

    protected DataType getBaseDataType() {
        return TypeDefDataTypeHTMLRepresentation.getBaseDataType((DataType)this.typeDef);
    }

    @Override
    public String getHTMLString() {
        return "<HTML>" + this.truncatedHtmlData + "</HTML>";
    }

    @Override
    public String getHTMLContentString() {
        return this.truncatedHtmlData;
    }

    private static DataType getBaseDataType(DataType dataType) {
        DataType basedataType = dataType;
        while (basedataType instanceof TypeDef) {
            basedataType = ((TypeDef)basedataType).getDataType();
            while (basedataType instanceof Pointer) {
                basedataType = ((Pointer)basedataType).getDataType();
            }
        }
        return basedataType;
    }

    protected List<String> buildWarnings() {
        DataType baseType = this.typeDef.getBaseDataType();
        if (!(baseType instanceof Composite) || !baseType.isZeroLength()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("WARNING! Refers to Empty " + (baseType instanceof Structure ? "Structure" : "Union"));
        return list;
    }

    @Override
    protected TextLine buildFooterText(DataType dataType) {
        if (dataType.isZeroLength()) {
            return new TextLine("0");
        }
        return super.buildFooterText(dataType);
    }

    protected List<ValidatableLine> buildHeaderText(DataType dataType, boolean trim) {
        TypeDef baseDataType = this.typeDef;
        ArrayList<ValidatableLine> lines = new ArrayList<ValidatableLine>();
        while (baseDataType instanceof TypeDef) {
            StringBuilder buffy = new StringBuilder();
            String baseDtString = baseDataType.toString();
            if (trim) {
                baseDtString = StringUtilities.trimMiddle((String)baseDtString, (int)80);
            }
            String encodedBaseDt = HTMLUtilities.friendlyEncodeHTML((String)baseDtString);
            buffy.append("<TT>").append(encodedBaseDt).append("</TT>").append("<BR>");
            lines.add(new TextLine(buffy.toString()));
            baseDataType = baseDataType.getDataType();
            while (baseDataType instanceof Pointer) {
                baseDataType = ((Pointer)baseDataType).getDataType();
            }
        }
        return lines;
    }

    private List<ValidatableLine> buildBodyText(DataType baseDataType, boolean trim) {
        ArrayList<ValidatableLine> lines = new ArrayList<ValidatableLine>();
        if (baseDataType instanceof BuiltInDataType) {
            TypeDefDataTypeHTMLRepresentation.buildHTMLTextForBuiltIn(lines, baseDataType);
        } else {
            TypeDefDataTypeHTMLRepresentation.buildHTMLTextForBaseDataType(lines, baseDataType, trim);
        }
        return lines;
    }

    private static String buildHTMLText(TypeDef typeDef, List<String> warningLines, List<ValidatableLine> headerLines, List<ValidatableLine> bodyLines, boolean trim) {
        StringBuilder buffy = new StringBuilder();
        for (String warning : warningLines) {
            String string = TypeDefDataTypeHTMLRepresentation.wrapStringInColor(warning, Color.RED);
            buffy.append(string).append("<BR>");
        }
        for (TextLine textLine : headerLines) {
            String headerLine = textLine.getText();
            if (trim) {
                headerLine = TypeDefDataTypeHTMLRepresentation.truncateAsNecessary(headerLine, 80);
            }
            headerLine = TypeDefDataTypeHTMLRepresentation.wrapStringInColor(textLine.getText(), textLine.getTextColor());
            buffy.append(headerLine);
        }
        buffy.append("<BR>");
        buffy.append("TypeDef Base Data Type: ").append("<BR>");
        for (TextLine textLine : bodyLines) {
            String bodyLine = textLine.getText();
            bodyLine = TypeDefDataTypeHTMLRepresentation.wrapStringInColor(textLine.getText(), textLine.getTextColor());
            buffy.append(bodyLine);
        }
        return buffy.toString();
    }

    private static void buildHTMLTextForBuiltIn(List<ValidatableLine> lines, DataType basedataType) {
        lines.add(new TextLine("<DIV STYLE='margin-left: 10px;'>"));
        lines.add(new TextLine("<TT>"));
        String dataTypeDescriptionOrName = TypeDefDataTypeHTMLRepresentation.getDataTypeDescriptionOrName(basedataType);
        String encodedDescriptionOrName = HTMLUtilities.friendlyEncodeHTML((String)dataTypeDescriptionOrName);
        lines.add(new TextLine(encodedDescriptionOrName));
        lines.add(new TextLine("</TT>"));
        StringBuilder buffy = TypeDefDataTypeHTMLRepresentation.addDataTypeLength(basedataType, new StringBuilder());
        lines.add(new TextLine(buffy.toString()));
        lines.add(new TextLine("</DIV>"));
    }

    private static String getDataTypeDescriptionOrName(DataType dataType) {
        String description = dataType.getDescription();
        if (description == null || description.length() == 0) {
            return dataType.getName();
        }
        return description;
    }

    private static void buildHTMLTextForBaseDataType(List<ValidatableLine> lines, DataType basedataType, boolean trim) {
        lines.add(new TextLine("<DIV STYLE='margin-left: 10px;'>"));
        HTMLDataTypeRepresentation baseRepresentation = ToolTipUtils.getHTMLRepresentation(basedataType);
        String baseHTML = baseRepresentation.getFullHTMLContentString();
        if (trim) {
            baseHTML = baseRepresentation.getHTMLContentString();
        }
        lines.add(new TextLine(baseHTML));
        if (baseHTML.indexOf("Length: ") < 0) {
            StringBuilder buffy = TypeDefDataTypeHTMLRepresentation.addDataTypeLength(basedataType, new StringBuilder());
            lines.add(new TextLine(buffy.toString()));
        }
        lines.add(new TextLine("</DIV>"));
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof TypeDefDataTypeHTMLRepresentation)) {
            return this.completelyDifferentDiff(otherRepresentation);
        }
        TypeDefDataTypeHTMLRepresentation typeDefRepresentation = (TypeDefDataTypeHTMLRepresentation)otherRepresentation;
        DataType myBaseDataType = this.getBaseDataType();
        DataType otherBaseDataType = typeDefRepresentation.getBaseDataType();
        HTMLDataTypeRepresentation myBaseRepresentation = ToolTipUtils.getHTMLRepresentation(myBaseDataType);
        HTMLDataTypeRepresentation otherBaseRepresentation = ToolTipUtils.getHTMLRepresentation(otherBaseDataType);
        HTMLDataTypeRepresentation[] diffs = this.doDiff(myBaseRepresentation, otherBaseRepresentation);
        ArrayList<ValidatableLine> header = new ArrayList<ValidatableLine>(this.headerContent);
        ArrayList<ValidatableLine> body = new ArrayList<ValidatableLine>();
        if (diffs != null) {
            body.add(new TextLine(diffs[0].getFullHTMLContentString()));
        }
        ArrayList<ValidatableLine> otherHeader = new ArrayList<ValidatableLine>(typeDefRepresentation.headerContent);
        ArrayList<ValidatableLine> otherBody = new ArrayList<ValidatableLine>();
        if (diffs != null) {
            otherBody.add(new TextLine(diffs[1].getFullHTMLContentString()));
        }
        DataTypeDiff headerDiff = DataTypeDiffBuilder.diffHeader(this.getDiffInput(header), this.getDiffInput(otherHeader));
        List<String> noWarnings = Collections.emptyList();
        return new HTMLDataTypeRepresentation[]{new TypeDefDataTypeHTMLRepresentation(this.typeDef, noWarnings, headerDiff.getLeftLines(), body), new TypeDefDataTypeHTMLRepresentation(typeDefRepresentation.typeDef, noWarnings, headerDiff.getRightLines(), otherBody)};
    }

    private HTMLDataTypeRepresentation[] doDiff(HTMLDataTypeRepresentation myBaseRepresentation, HTMLDataTypeRepresentation otherBaseRepresentation) {
        HTMLDataTypeRepresentation[] diffs = myBaseRepresentation.diff(otherBaseRepresentation);
        return diffs;
    }
}

