/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbol;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DebugCOFFSymbolAux
implements StructConverter {
    public static final byte IMAGE_SIZEOF_AUX_SYMBOL = 18;
    private AuxSym sym;
    private AuxFile file;
    private AuxSection section;

    static DebugCOFFSymbolAux createDebugCOFFSymbolAux(FactoryBundledWithBinaryReader reader, int index, DebugCOFFSymbol symbol) throws IOException {
        DebugCOFFSymbolAux debugCOFFSymbolAux = (DebugCOFFSymbolAux)reader.getFactory().create(DebugCOFFSymbolAux.class, new Object[0]);
        debugCOFFSymbolAux.initDebugCOFFSymbolAux(reader, index, symbol);
        return debugCOFFSymbolAux;
    }

    private void initDebugCOFFSymbolAux(FactoryBundledWithBinaryReader reader, int index, DebugCOFFSymbol symbol) throws IOException {
        switch (symbol.getStorageClass()) {
            case 103: {
                this.file = AuxFile.createAuxFile(reader, index);
                break;
            }
            case 2: 
            case 101: {
                this.sym = AuxSym.createAuxSym(reader, index);
                break;
            }
            case 3: {
                this.section = AuxSection.createAuxSection(reader, index);
                break;
            }
        }
    }

    public String toString() {
        if (this.file != null) {
            return this.file.getName();
        }
        if (this.sym != null) {
            return "Tag=" + Integer.toHexString(this.sym.getTagIndex()) + "  TvIndex=" + Integer.toHexString(this.sym.getTvIndex());
        }
        if (this.section != null) {
            return "Section=" + Integer.toHexString(this.section.getNumber()) + "  Len=" + Integer.toHexString(this.section.getLength()) + "  NumOfRelocs=" + this.section.getNumberOfRelocations() + "  NumOfLineNums=" + this.section.getNumberOfLinenumbers() + "  Checksum=" + Integer.toHexString(this.section.getCheckSum());
        }
        return super.toString();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String structureName = StructConverterUtil.parseName(DebugCOFFSymbolAux.class);
        StructureDataType structure = new StructureDataType(structureName, 18);
        return structure;
    }

    public static class AuxSection
    implements StructConverter {
        private int length;
        private short numberOfRelocations;
        private short numberOfLinenumbers;
        private int checkSum;
        private short number;
        private byte selection;

        private static AuxSection createAuxSection(FactoryBundledWithBinaryReader reader, int index) throws IOException {
            AuxSection auxSection = (AuxSection)reader.getFactory().create(AuxSection.class, new Object[0]);
            auxSection.initAuxSection(reader, index);
            return auxSection;
        }

        private void initAuxSection(FactoryBundledWithBinaryReader reader, int index) throws IOException {
            this.length = reader.readInt(index);
            this.numberOfRelocations = reader.readShort(index += 4);
            this.numberOfLinenumbers = reader.readShort(index += 2);
            this.checkSum = reader.readInt(index += 2);
            this.number = reader.readShort(index += 4);
            this.selection = reader.readByte(index += 2);
            ++index;
        }

        int getLength() {
            return this.length;
        }

        int getNumberOfRelocations() {
            return this.numberOfRelocations;
        }

        int getNumberOfLinenumbers() {
            return this.numberOfLinenumbers;
        }

        int getCheckSum() {
            return this.checkSum;
        }

        int getNumber() {
            return this.number;
        }

        int getSelection() {
            return this.selection;
        }

        @Override
        public DataType toDataType() throws DuplicateNameException, IOException {
            return StructConverterUtil.toDataType(this);
        }
    }

    public static class AuxFile
    implements StructConverter {
        private String name;

        private static AuxFile createAuxFile(FactoryBundledWithBinaryReader reader, int index) throws IOException {
            AuxFile auxFile = (AuxFile)reader.getFactory().create(AuxFile.class, new Object[0]);
            auxFile.initAuxFile(reader, index);
            return auxFile;
        }

        private void initAuxFile(FactoryBundledWithBinaryReader reader, int index) throws IOException {
            this.name = reader.readAsciiString(index, 18);
        }

        String getName() {
            return this.name;
        }

        @Override
        public DataType toDataType() throws DuplicateNameException, IOException {
            String structureName = StructConverterUtil.parseName(DebugCOFFSymbolAux.class);
            StructureDataType structure = new StructureDataType(structureName, 0);
            structure.add(STRING, 18, "name", null);
            return structure;
        }
    }

    public static class AuxSym
    implements StructConverter {
        private int tagIndex;
        private short miscLnSzLinenumber;
        private short miscLnSzSize;
        private int miscTotalSize;
        private int fncAryFunctionPointerToLinenumber;
        private int fncAryFunctionPointerToNextFunction;
        private short[] fncAryArrayDimension = new short[4];
        private short tvIndex;

        private static AuxSym createAuxSym(FactoryBundledWithBinaryReader reader, int index) throws IOException {
            AuxSym auxSym = (AuxSym)reader.getFactory().create(AuxSym.class, new Object[0]);
            auxSym.initAuxSym(reader, index);
            return auxSym;
        }

        private void initAuxSym(FactoryBundledWithBinaryReader reader, int index) throws IOException {
            this.tagIndex = reader.readInt(index);
            this.miscLnSzLinenumber = reader.readShort(index += 4);
            this.miscLnSzSize = reader.readShort(index + 2);
            this.miscTotalSize = reader.readInt(index);
            this.fncAryFunctionPointerToLinenumber = reader.readInt(index += 4);
            this.fncAryFunctionPointerToNextFunction = reader.readInt(index + 4);
            this.fncAryArrayDimension = reader.readShortArray(index, 4);
            this.tvIndex = reader.readShort(index += 8);
            index += 2;
        }

        int getTagIndex() {
            return this.tagIndex;
        }

        short getMiscLnSzLinenumber() {
            return this.miscLnSzLinenumber;
        }

        short getMiscLnSzSize() {
            return this.miscLnSzSize;
        }

        int getMiscTotalSize() {
            return this.miscTotalSize;
        }

        int getFncAryFunctionPointerToLinenumber() {
            return this.fncAryFunctionPointerToLinenumber;
        }

        int getFncAryFunctionPointerToNextFunction() {
            return this.fncAryFunctionPointerToNextFunction;
        }

        short[] getFncAryArrayDimension() {
            return this.fncAryArrayDimension;
        }

        short getTvIndex() {
            return this.tvIndex;
        }

        @Override
        public DataType toDataType() throws DuplicateNameException, IOException {
            return StructConverterUtil.toDataType(this);
        }
    }
}

