/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macos.rm;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.macos.rm.ResourceMap;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnsignedInteger3DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ReferenceListEntry
implements StructConverter {
    private short id;
    private short nameOffset;
    private byte attributes;
    private int dataOffset;
    private int handle;
    private String _name;

    ReferenceListEntry(BinaryReader reader, ResourceMap map) throws IOException {
        this.id = reader.readNextShort();
        this.nameOffset = reader.readNextShort();
        this.attributes = reader.readNextByte();
        this.dataOffset = this.read3ByteValue(reader);
        this.handle = reader.readNextInt();
        this._name = map.getStringAt(this.nameOffset);
    }

    private int read3ByteValue(BinaryReader reader) throws IOException {
        int value1 = reader.readNextByte() & 0xFF;
        int value2 = reader.readNextByte() & 0xFF;
        int value3 = reader.readNextByte() & 0xFF;
        if (reader.isLittleEndian()) {
            return value3 << 16 | value2 << 8 | value1;
        }
        return value1 << 16 | value2 << 8 | value3;
    }

    public short getID() {
        return this.id;
    }

    public String getName() {
        return this._name;
    }

    public short getNameOffset() {
        return this.nameOffset;
    }

    public byte getAttributes() {
        return this.attributes;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public int getHandle() {
        return this.handle;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = StructConverterUtil.parseName(ReferenceListEntry.class);
        StructureDataType struct = new StructureDataType(name, 0);
        struct.add(WORD, "id", null);
        struct.add(WORD, "nameOffset", null);
        struct.add(BYTE, "attributes", null);
        struct.add((DataType)new UnsignedInteger3DataType(), "dataOffset", null);
        struct.add(DWORD, "handle", null);
        return struct;
    }
}

