/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.BuildVersionCommand;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupsCommand;
import ghidra.app.util.bin.format.macho.commands.DyldInfoCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLinkerCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicSymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.EncryptedInformationCommand;
import ghidra.app.util.bin.format.macho.commands.EntryPointCommand;
import ghidra.app.util.bin.format.macho.commands.FileSetEntryCommand;
import ghidra.app.util.bin.format.macho.commands.FixedVirtualMemoryFileCommand;
import ghidra.app.util.bin.format.macho.commands.FixedVirtualMemorySharedLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.IdentCommand;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.app.util.bin.format.macho.commands.LinkerOptionCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.PrebindChecksumCommand;
import ghidra.app.util.bin.format.macho.commands.PreboundDynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.RoutinesCommand;
import ghidra.app.util.bin.format.macho.commands.RunPathCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.commands.SourceVersionCommand;
import ghidra.app.util.bin.format.macho.commands.SubClientCommand;
import ghidra.app.util.bin.format.macho.commands.SubFrameworkCommand;
import ghidra.app.util.bin.format.macho.commands.SubLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.SubUmbrellaCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.TwoLevelHintsCommand;
import ghidra.app.util.bin.format.macho.commands.UnsupportedLoadCommand;
import ghidra.app.util.bin.format.macho.commands.UuidCommand;
import ghidra.app.util.bin.format.macho.commands.VersionMinCommand;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadCommand;
import ghidra.util.Msg;
import java.io.IOException;
import java.lang.reflect.Field;

public final class LoadCommandTypes {
    public static final int LC_REQ_DYLD = Integer.MIN_VALUE;
    public static final int LC_SEGMENT = 1;
    public static final int LC_SYMTAB = 2;
    public static final int LC_SYMSEG = 3;
    public static final int LC_THREAD = 4;
    public static final int LC_UNIXTHREAD = 5;
    public static final int LC_LOADFVMLIB = 6;
    public static final int LC_IDFVMLIB = 7;
    public static final int LC_IDENT = 8;
    public static final int LC_FVMFILE = 9;
    public static final int LC_PREPAGE = 10;
    public static final int LC_DYSYMTAB = 11;
    public static final int LC_LOAD_DYLIB = 12;
    public static final int LC_ID_DYLIB = 13;
    public static final int LC_LOAD_DYLINKER = 14;
    public static final int LC_ID_DYLINKER = 15;
    public static final int LC_PREBOUND_DYLIB = 16;
    public static final int LC_ROUTINES = 17;
    public static final int LC_SUB_FRAMEWORK = 18;
    public static final int LC_SUB_UMBRELLA = 19;
    public static final int LC_SUB_CLIENT = 20;
    public static final int LC_SUB_LIBRARY = 21;
    public static final int LC_TWOLEVEL_HINTS = 22;
    public static final int LC_PREBIND_CKSUM = 23;
    public static final int LC_LOAD_WEAK_DYLIB = -2147483624;
    public static final int LC_SEGMENT_64 = 25;
    public static final int LC_ROUTINES_64 = 26;
    public static final int LC_UUID = 27;
    public static final int LC_RPATH = -2147483620;
    public static final int LC_CODE_SIGNATURE = 29;
    public static final int LC_SEGMENT_SPLIT_INFO = 30;
    public static final int LC_REEXPORT_DYLIB = -2147483617;
    public static final int LC_LAZY_LOAD_DYLIB = 32;
    public static final int LC_ENCRYPTION_INFO = 33;
    public static final int LC_DYLD_INFO = 34;
    public static final int LC_DYLD_INFO_ONLY = -2147483614;
    public static final int LC_LOAD_UPWARD_DYLIB = -2147483613;
    public static final int LC_VERSION_MIN_MACOSX = 36;
    public static final int LC_VERSION_MIN_IPHONEOS = 37;
    public static final int LC_FUNCTION_STARTS = 38;
    public static final int LC_DYLD_ENVIRONMENT = 39;
    public static final int LC_MAIN = -2147483608;
    public static final int LC_DATA_IN_CODE = 41;
    public static final int LC_SOURCE_VERSION = 42;
    public static final int LC_DYLIB_CODE_SIGN_DRS = 43;
    public static final int LC_ENCRYPTION_INFO_64 = 44;
    public static final int LC_LINKER_OPTIONS = 45;
    public static final int LC_OPTIMIZATION_HINT = 46;
    public static final int LC_VERSION_MIN_TVOS = 47;
    public static final int LC_VERSION_MIN_WATCHOS = 48;
    public static final int LC_NOTE = 49;
    public static final int LC_BUILD_VERSION = 50;
    public static final int LC_DYLD_EXPORTS_TRIE = -2147483597;
    public static final int LC_DYLD_CHAINED_FIXUPS = -2147483596;
    public static final int LC_FILESET_ENTRY = -2147483595;

    public static LoadCommand getLoadCommand(FactoryBundledWithBinaryReader reader, MachHeader header) throws IOException, MachException {
        int type = reader.peekNextInt();
        switch (type) {
            case 1: {
                return SegmentCommand.createSegmentCommand(reader, header.is32bit());
            }
            case 2: {
                return SymbolTableCommand.createSymbolTableCommand(reader, header);
            }
            case 3: {
                return SymbolCommand.createSymbolCommand(reader);
            }
            case 4: 
            case 5: {
                return ThreadCommand.createThreadCommand(reader, header);
            }
            case 6: 
            case 7: {
                return FixedVirtualMemorySharedLibraryCommand.createFixedVirtualMemorySharedLibraryCommand(reader);
            }
            case 8: {
                return IdentCommand.createIdentCommand(reader);
            }
            case 9: {
                return FixedVirtualMemoryFileCommand.createFixedVirtualMemoryFileCommand(reader);
            }
            case 10: {
                return UnsupportedLoadCommand.createUnsupportedLoadCommand(reader, type);
            }
            case 11: {
                return DynamicSymbolTableCommand.createDynamicSymbolTableCommand(reader, header);
            }
            case -2147483613: 
            case 12: 
            case 13: 
            case 39: {
                return DynamicLibraryCommand.createDynamicLibraryCommand(reader);
            }
            case 14: 
            case 15: {
                return DynamicLinkerCommand.createDynamicLinkerCommand(reader);
            }
            case 16: {
                return PreboundDynamicLibraryCommand.createPreboundDynamicLibraryCommand(reader);
            }
            case 17: {
                return RoutinesCommand.createRoutinesCommand(reader, header.is32bit());
            }
            case 18: {
                return SubFrameworkCommand.createSubFrameworkCommand(reader);
            }
            case 19: {
                return SubUmbrellaCommand.createSubUmbrellaCommand(reader);
            }
            case 20: {
                return SubClientCommand.createSubClientCommand(reader);
            }
            case 21: {
                return SubLibraryCommand.createSubLibraryCommand(reader);
            }
            case 22: {
                return TwoLevelHintsCommand.createTwoLevelHintsCommand(reader);
            }
            case 23: {
                return PrebindChecksumCommand.createPrebindChecksumCommand(reader);
            }
            case -2147483624: {
                return DynamicLibraryCommand.createDynamicLibraryCommand(reader);
            }
            case 25: {
                return SegmentCommand.createSegmentCommand(reader, header.is32bit());
            }
            case 26: {
                return RoutinesCommand.createRoutinesCommand(reader, header.is32bit());
            }
            case 27: {
                return UuidCommand.createUuidCommand(reader);
            }
            case -2147483620: {
                return RunPathCommand.createRunPathCommand(reader);
            }
            case 29: 
            case 30: 
            case 38: 
            case 41: 
            case 43: 
            case 46: {
                return LinkEditDataCommand.createLinkEditDataCommand(reader);
            }
            case -2147483617: {
                return DynamicLibraryCommand.createDynamicLibraryCommand(reader);
            }
            case 33: 
            case 44: {
                return EncryptedInformationCommand.createEncryptedInformationCommand(reader, header.is32bit());
            }
            case -2147483614: 
            case 34: {
                return DyldInfoCommand.createDyldInfoCommand(reader);
            }
            case 36: 
            case 37: 
            case 47: 
            case 48: {
                return VersionMinCommand.createVersionMinCommand(reader);
            }
            case -2147483608: {
                return EntryPointCommand.createEntryPointCommand(reader);
            }
            case 42: {
                return SourceVersionCommand.createSourceVersionCommand(reader);
            }
            case 32: {
                return DynamicLibraryCommand.createDynamicLibraryCommand(reader);
            }
            case 50: {
                return BuildVersionCommand.createBuildVersionCommand(reader);
            }
            case 45: {
                return LinkerOptionCommand.createLinkerOptionCommand(reader);
            }
            case -2147483597: {
                return LinkEditDataCommand.createLinkEditDataCommand(reader);
            }
            case -2147483596: {
                return DyldChainedFixupsCommand.createDyldChainedFixupsCommand(reader);
            }
            case -2147483595: {
                return FileSetEntryCommand.createFileSetEntryCommand(reader, header.is32bit());
            }
        }
        Msg.warn((Object)header, (Object)("Unsupported load command " + Integer.toHexString(type)));
        return UnsupportedLoadCommand.createUnsupportedLoadCommand(reader, type);
    }

    public static final String getLoadCommentTypeName(int type) {
        Field[] fields;
        for (Field field : fields = LoadCommandTypes.class.getDeclaredFields()) {
            if (!field.getName().startsWith("LC_")) continue;
            try {
                Integer value = (Integer)field.get(null);
                if (type != value) continue;
                return field.getName();
            }
            catch (Exception e) {
                break;
            }
        }
        return "Unknown load command type: " + Integer.toHexString(type);
    }
}

