/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.encoding;

import java.util.HashMap;
import java.util.Map;

public enum DWARFIdentifierCase {
    DW_ID_case_sensitive(0),
    DW_ID_up_case(1),
    DW_ID_down_case(2),
    DW_ID_case_insensitive(3);

    private final int value;
    private static final Map<Integer, DWARFIdentifierCase> valueMap;

    private DWARFIdentifierCase(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DWARFIdentifierCase find(long key) {
        DWARFIdentifierCase access = valueMap.get((int)key);
        if (access != null) {
            return access;
        }
        throw new IllegalArgumentException("Invalid Integer value: " + key);
    }

    static {
        valueMap = new HashMap<Integer, DWARFIdentifierCase>();
        for (DWARFIdentifierCase access : DWARFIdentifierCase.values()) {
            valueMap.put(access.getValue(), access);
        }
    }
}

