/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ObfuscatedFileByteProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ObfuscatedInputStream
extends InputStream {
    private InputStream delegate;
    private long currentPosition;

    public ObfuscatedInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        super.close();
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int bytesRead = this.read(buffer, 0, 1);
        return bytesRead == 1 ? Byte.toUnsignedInt(buffer[0]) : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.delegate.read(b, off, len);
        int i = 0;
        while (i < bytesRead) {
            int xorMaskIndex = (int)(this.currentPosition % (long)ObfuscatedFileByteProvider.XOR_MASK_BYTES.length);
            byte xorMask = ObfuscatedFileByteProvider.XOR_MASK_BYTES[xorMaskIndex];
            int n = off + i;
            b[n] = (byte)(b[n] ^ xorMask);
            ++i;
            ++this.currentPosition;
        }
        return bytesRead;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2 || args.length > 1 && args[0].equals("--help")) {
            System.err.println("De-Obfuscator Usage:");
            System.err.println("\t" + ObfuscatedInputStream.class.getName() + " obfuscated_input_filename_path plain_dest_output_filename_path");
            System.err.println("");
            System.err.println("\tExample:");
            System.err.println("\t\t" + ObfuscatedInputStream.class.getName() + " /tmp/myuserid-Ghidra/fscache2/aa/bb/aabbccddeeff00112233445566778899 /tmp/aabbccddeeff00112233445566778899.plaintext");
            System.err.println("");
            return;
        }
        File obfuscatedInputFile = new File(args[0]);
        File plainTextOutputFile = new File(args[1]);
        try (ObfuscatedInputStream is = new ObfuscatedInputStream(new FileInputStream(obfuscatedInputFile));
             FileOutputStream os = new FileOutputStream(plainTextOutputFile);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
        }
    }
}

