/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.match;

import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MatchSymbol {
    private MatchSymbol() {
    }

    public static List<MatchedSymbol> matchSymbol(Program aProgram, AddressSetView setA, Program bProgram, AddressSetView setB, int minSymbolNameLength, boolean includeOneToOneOnly, boolean includeExternals, TaskMonitor monitor) throws CancelledException {
        HashMap<SymbolIdentifier, Match> symbolMatches = new HashMap<SymbolIdentifier, Match>();
        ArrayList<MatchedSymbol> matchedSymbols = new ArrayList<MatchedSymbol>();
        HashMap<SymbolPath, Boolean> aUniqueSymbolPathMap = null;
        HashMap<SymbolPath, Boolean> bUniqueSymbolPathMap = null;
        if (!includeOneToOneOnly) {
            aUniqueSymbolPathMap = new HashMap<SymbolPath, Boolean>();
            bUniqueSymbolPathMap = new HashMap<SymbolPath, Boolean>();
        }
        monitor.setIndeterminate(false);
        monitor.initialize((long)(aProgram.getSymbolTable().getNumSymbols() + bProgram.getSymbolTable().getNumSymbols()));
        MatchSymbol.hashSymbols(aProgram, setA, minSymbolNameLength, includeExternals, monitor, aUniqueSymbolPathMap, symbolMatches, true, !includeOneToOneOnly);
        MatchSymbol.hashSymbols(bProgram, setB, minSymbolNameLength, includeExternals, monitor, bUniqueSymbolPathMap, symbolMatches, false, !includeOneToOneOnly);
        Collection<Match> entries = symbolMatches.values();
        long progress = monitor.getProgress();
        if (includeOneToOneOnly) {
            monitor.setMaximum(progress + (long)symbolMatches.size());
            monitor.setProgress(progress);
            monitor.setMessage("Eliminate non-unique matches");
            Iterator<Match> matchIterator = entries.iterator();
            while (matchIterator.hasNext()) {
                monitor.incrementProgress(1L);
                monitor.checkCanceled();
                Match match = matchIterator.next();
                if (match.aSymbols.size() == 1 && match.bSymbols.size() == 1) continue;
                matchIterator.remove();
            }
        }
        progress = monitor.getProgress();
        monitor.setMaximum(progress + (long)symbolMatches.size());
        monitor.setProgress(progress);
        monitor.setMessage("Finding symbol matches");
        for (Match match : entries) {
            monitor.incrementProgress(1L);
            monitor.checkCanceled();
            List<SymbolIdentifier> aSymbols = match.aSymbols;
            List<SymbolIdentifier> bSymbols = match.bSymbols;
            for (SymbolIdentifier aSymbolIdentifier : aSymbols) {
                Boolean aHasUniqueName = null;
                if (aUniqueSymbolPathMap != null) {
                    aHasUniqueName = aUniqueSymbolPathMap.get(aSymbolIdentifier.symbolPath);
                }
                for (SymbolIdentifier bSymbolIdentifier : bSymbols) {
                    if (!includeOneToOneOnly) {
                        if (Boolean.TRUE.equals(aHasUniqueName) && aSymbolIdentifier.symbolPath.equals((Object)bSymbolIdentifier.symbolPath) && Boolean.TRUE.equals(bUniqueSymbolPathMap.get(bSymbolIdentifier.symbolPath))) continue;
                        SymbolPath aSymbolPath = aSymbolIdentifier.symbolPath;
                        SymbolPath namespacePath = aSymbolPath.getParent();
                        if (!aSymbolIdentifier.isExternalSymbol() && namespacePath != null && !aSymbolPath.equals((Object)bSymbolIdentifier.symbolPath) && NamespaceUtils.getNonFunctionNamespace((Program)bProgram, (SymbolPath)namespacePath) != null) continue;
                    }
                    ++match.retainedMatchCount;
                    MatchedSymbol symbolMatch = new MatchedSymbol(match, aProgram, bProgram, aSymbolIdentifier, bSymbolIdentifier);
                    matchedSymbols.add(symbolMatch);
                }
            }
        }
        return matchedSymbols;
    }

    private static void hashSymbols(Program program, AddressSetView set, int minSymbolNameLength, boolean includeExternals, TaskMonitor monitor, HashMap<SymbolPath, Boolean> uniqueSymbolPathMap, HashMap<SymbolIdentifier, Match> symbolMatches, boolean isAProg, boolean ignoreNamespace) throws CancelledException {
        monitor.setMessage("Hashing symbols in " + program.getName());
        for (Symbol symbol : program.getSymbolTable().getAllSymbols(true)) {
            String name;
            SymbolType symbolType;
            monitor.incrementProgress(1L);
            monitor.checkCanceled();
            if (symbol.getSource() == SourceType.DEFAULT && !MatchSymbol.isSymbolAString(program, symbol) || symbol.getParentNamespace() instanceof Function || (symbolType = symbol.getSymbolType()) != SymbolType.FUNCTION && symbolType != SymbolType.LABEL || !set.contains(symbol.getAddress()) && (!symbol.isExternal() || !includeExternals) || (name = symbol.getName()).length() < minSymbolNameLength) continue;
            MatchSymbol.hashSymbol(uniqueSymbolPathMap, symbolMatches, symbol, isAProg, ignoreNamespace);
        }
    }

    private static void hashSymbol(HashMap<SymbolPath, Boolean> uniqueSymbolPathMap, HashMap<SymbolIdentifier, Match> symbolMatches, Symbol symbol, boolean isProgA, boolean ignoreNamespace) {
        ExternalLocation externalLocation;
        Program program = symbol.getProgram();
        if (symbol.isExternal() && (externalLocation = program.getExternalManager().getExternalLocation(symbol)) != null && MatchSymbol.hashExternalLocationOriginalName(uniqueSymbolPathMap, symbolMatches, externalLocation, isProgA, ignoreNamespace)) {
            return;
        }
        SymbolPath symbolPath = new SymbolPath(symbol);
        if (!symbol.isExternal()) {
            symbolPath = MatchSymbol.getCleanSymbolPath(symbolPath, symbol.getAddress());
        }
        MatchSymbol.updateUniqueSymbolPathMap(uniqueSymbolPathMap, symbolPath);
        SymbolMatchType symbolMatchType = MatchSymbol.getSymbolMatchType(symbol);
        if (symbolMatchType == SymbolMatchType.OTHER) {
            return;
        }
        MatchSymbol.hashSymbolName(symbolMatches, symbolPath, symbolMatchType == SymbolMatchType.FUNCTION, ignoreNamespace, symbol.getAddress(), program, isProgA);
    }

    private static SymbolMatchType getSymbolMatchType(Symbol symbol) {
        if (symbol.getSymbolType() == SymbolType.FUNCTION) {
            return SymbolMatchType.FUNCTION;
        }
        if (symbol.getSymbolType() != SymbolType.LABEL) {
            return SymbolMatchType.OTHER;
        }
        if (symbol.isExternal()) {
            return SymbolMatchType.DATA;
        }
        Listing listing = symbol.getProgram().getListing();
        if (listing.getFunctionAt(symbol.getAddress()) != null) {
            return SymbolMatchType.FUNCTION;
        }
        if (listing.getDataAt(symbol.getAddress()) != null) {
            return SymbolMatchType.DATA;
        }
        return SymbolMatchType.OTHER;
    }

    private static void updateUniqueSymbolPathMap(HashMap<SymbolPath, Boolean> uniqueSymbolPathMap, SymbolPath symbolPath) {
        if (uniqueSymbolPathMap == null) {
            return;
        }
        Boolean hasUniqueSymbolPath = uniqueSymbolPathMap.get(symbolPath);
        if (hasUniqueSymbolPath == null) {
            uniqueSymbolPathMap.put(symbolPath, true);
        } else if (hasUniqueSymbolPath.booleanValue()) {
            uniqueSymbolPathMap.put(symbolPath, false);
        }
    }

    private static boolean hashExternalLocationOriginalName(HashMap<SymbolPath, Boolean> uniqueSymbolPathMap, HashMap<SymbolIdentifier, Match> symbolMatches, ExternalLocation externalLocation, boolean isProgA, boolean ignoreNamespace) {
        String originalImportedName = externalLocation.getOriginalImportedName();
        if (originalImportedName != null) {
            Symbol s = externalLocation.getSymbol();
            Library lib = NamespaceUtils.getLibrary((Namespace)s.getParentNamespace());
            SymbolPath libPath = new SymbolPath(lib.getSymbol());
            SymbolPath symbolPath = new SymbolPath(libPath, originalImportedName);
            MatchSymbol.updateUniqueSymbolPathMap(uniqueSymbolPathMap, symbolPath);
            MatchSymbol.hashSymbolName(symbolMatches, symbolPath, externalLocation.isFunction(), ignoreNamespace, externalLocation.getExternalSpaceAddress(), s.getProgram(), isProgA);
            return true;
        }
        return false;
    }

    private static SymbolPath getCleanSymbolPath(SymbolPath path, Address address) {
        if (!address.isMemoryAddress()) {
            return path;
        }
        String symbolName = path.getName();
        String cleanName = SymbolUtilities.getCleanSymbolName((String)symbolName, (Address)address);
        if (!cleanName.equals(symbolName)) {
            return new SymbolPath(path.getParent(), cleanName);
        }
        return path;
    }

    private static void hashSymbolName(HashMap<SymbolIdentifier, Match> symbolMatches, SymbolPath symbolPath, boolean isFunction, boolean ignoreNamespace, Address address, Program aProgram, boolean isProgA) {
        SymbolIdentifier symbolIdentifier = new SymbolIdentifier(symbolPath, address, isFunction, ignoreNamespace);
        Match subMatch = symbolMatches.get(symbolIdentifier);
        if (subMatch == null) {
            subMatch = new Match();
            symbolMatches.put(symbolIdentifier, subMatch);
        }
        subMatch.add(symbolIdentifier, isProgA);
    }

    private static boolean isSymbolAString(Program prog, Symbol symbol) {
        Data data;
        Address symAddr = symbol.getAddress();
        return symAddr != null && (data = prog.getListing().getDataAt(symAddr)) != null && data.hasStringValue();
    }

    public static class MatchedSymbol {
        private Match match;
        private final Program aProg;
        private final Program bProg;
        private final SymbolIdentifier aSymbol;
        private final SymbolIdentifier bSymbol;

        MatchedSymbol(Match match, Program aProg, Program bProg, SymbolIdentifier aSymbol, SymbolIdentifier bSymbol) {
            this.match = match;
            this.aProg = aProg;
            this.bProg = bProg;
            this.aSymbol = aSymbol;
            this.bSymbol = bSymbol;
        }

        public Program getAProgram() {
            return this.aProg;
        }

        public Program getBProgram() {
            return this.bProg;
        }

        public Address getASymbolAddress() {
            return this.aSymbol.address;
        }

        public Address getBSymbolAddress() {
            return this.bSymbol.address;
        }

        public int getMatchCount() {
            return this.match.retainedMatchCount;
        }

        public SymbolType getMatchType() {
            return this.aSymbol.isFunction ? SymbolType.FUNCTION : SymbolType.LABEL;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.aSymbol.hashCode();
            result = 31 * result + this.bSymbol.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchedSymbol other = (MatchedSymbol)obj;
            if (this.match != other.match) {
                return false;
            }
            if (!SystemUtilities.isEqual((Object)this.aSymbol, (Object)other.aSymbol)) {
                return false;
            }
            if (this.aProg != other.aProg) {
                return false;
            }
            if (!SystemUtilities.isEqual((Object)this.bSymbol, (Object)other.bSymbol)) {
                return false;
            }
            return this.bProg == other.bProg;
        }
    }

    private static class Match {
        final List<SymbolIdentifier> aSymbols = new ArrayList<SymbolIdentifier>();
        final List<SymbolIdentifier> bSymbols = new ArrayList<SymbolIdentifier>();
        int retainedMatchCount;

        private Match() {
        }

        void add(SymbolIdentifier symbolIdentifier, boolean isProgA) {
            if (isProgA) {
                this.aSymbols.add(symbolIdentifier);
            } else {
                this.bSymbols.add(symbolIdentifier);
            }
        }
    }

    private static class SymbolIdentifier {
        final boolean isFunction;
        final SymbolPath symbolPath;
        final Address address;
        final boolean ignoreNamespace;

        SymbolIdentifier(SymbolPath symbolPath, Address address, boolean isFunction, boolean ignoreNamespace) {
            this.isFunction = isFunction;
            this.symbolPath = symbolPath;
            this.address = address;
            this.ignoreNamespace = ignoreNamespace;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isFunction ? 1231 : 1237);
            result = 31 * result + (this.address.isExternalAddress() ? 1231 : 1237);
            result = this.ignoreNamespace ? 31 * result + this.symbolPath.getName().hashCode() : 31 * result + this.symbolPath.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SymbolIdentifier other = (SymbolIdentifier)obj;
            if (this.isFunction != other.isFunction || this.isExternalSymbol() != other.isExternalSymbol()) {
                return false;
            }
            if (this.ignoreNamespace) {
                return this.getName().equals(other.getName());
            }
            return this.symbolPath.equals((Object)other.symbolPath);
        }

        String getName() {
            return this.symbolPath.getName();
        }

        boolean isMemorySymbol() {
            return this.address.isMemoryAddress();
        }

        boolean isExternalSymbol() {
            return this.address.isExternalAddress();
        }
    }

    private static enum SymbolMatchType {
        FUNCTION,
        DATA,
        OTHER;

    }
}

