/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import ghidra.app.plugin.core.stackeditor.BiDirectionDataType;
import ghidra.app.plugin.core.stackeditor.StackPieceDataType;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.util.Collections;
import java.util.Iterator;

public class StackFrameDataType
extends BiDirectionDataType {
    private static final long serialVersionUID = 1L;
    static String DUMMY_FUNCTION_NAME = "StackWithoutFunction";
    private static final String UNKNOWN_PREFIX = "unknown_";
    StackFrame stack;
    int returnAddressOffset;
    boolean growsNegative;
    Function function;

    public StackFrameDataType(StackFrame stack, DataTypeManager dtm) {
        super(stack.getFunction() != null ? stack.getFunction().getName() : "StackWithoutFunction", 0, 0, stack.getParameterOffset(), dtm);
        this.stack = stack;
        this.initialize();
    }

    public StackFrameDataType(StackFrameDataType stackDt, DataTypeManager dtm) {
        super(stackDt.getCategoryPath(), stackDt.getName(), stackDt.getNegativeLength(), stackDt.getPositiveLength(), stackDt.splitOffset, dtm);
        this.setDescription(stackDt.getDescription());
        this.function = stackDt.function;
        this.growsNegative = stackDt.growsNegative;
        this.returnAddressOffset = stackDt.returnAddressOffset;
        this.stack = stackDt.stack;
        this.defaultSettings = stackDt.defaultSettings;
        for (DataTypeComponentImpl dtc : stackDt.components) {
            this.replaceAtOffset(dtc.getOffset(), dtc.getDataType(), dtc.getLength(), dtc.getFieldName(), dtc.getComment());
        }
    }

    StackFrame getStackFrame() {
        return this.stack;
    }

    private void initialize() {
        int posLength;
        int negLength;
        this.function = this.stack.getFunction();
        int paramSize = this.stack.getParameterSize();
        int localSize = this.stack.getLocalSize();
        this.returnAddressOffset = this.stack.getReturnAddressOffset();
        this.growsNegative = this.stack.growsNegative();
        if (this.growsNegative) {
            negLength = -localSize;
            posLength = paramSize;
        } else {
            negLength = -paramSize;
            posLength = localSize;
        }
        this.growStructure(posLength);
        this.growStructure(negLength);
        Variable[] stackVars = this.stack.getStackVariables();
        for (int i = stackVars.length - 1; i >= 0; --i) {
            Variable var = stackVars[i];
            VariableStorage storage = var.getVariableStorage();
            Varnode stackVarnode = storage.getLastVarnode();
            int length = stackVarnode.getSize();
            int offset = (int)stackVarnode.getOffset();
            if (offset < negLength + this.splitOffset || offset + length - 1 > posLength + this.splitOffset) continue;
            String comment = var.getComment();
            if (comment != null && (comment = comment.trim()).length() == 0) {
                comment = null;
            }
            String varName = var.getName();
            Object dt = var.getDataType();
            if (!storage.isStackStorage()) {
                dt = new StackPieceDataType(var, this.getDataTypeManager());
            }
            this.replaceAtOffset(offset, (DataType)dt, length, this.isDefaultName(varName) ? null : varName, comment);
        }
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    boolean isDefaultName(String varName) {
        if (varName == null) {
            return false;
        }
        return SymbolUtilities.isDefaultLocalStackName((String)varName) || SymbolUtilities.isDefaultParameterName((String)varName);
    }

    @Override
    public StackFrameDataType clone(DataTypeManager dtm) {
        return new StackFrameDataType(this, dtm);
    }

    int getMinOffset() {
        return this.splitOffset - this.negativeLength;
    }

    int getMaxOffset() {
        return this.splitOffset + this.positiveLength - 1;
    }

    public static String getHexString(int offset, boolean showPrefix) {
        String prefix = showPrefix ? "0x" : "";
        return offset >= 0 ? prefix + Integer.toHexString(offset) : "-" + prefix + Integer.toHexString(-offset);
    }

    public DataTypeComponent getDefinedComponentAtOffset(int offset) {
        if (offset < this.getMinOffset() || offset > this.getMaxOffset()) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
        if (index >= 0) {
            return (DataTypeComponent)this.components.get(index);
        }
        return null;
    }

    public DataTypeComponent getDefinedComponentAtOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal >= this.getNumComponents()) {
            throw new ArrayIndexOutOfBoundsException(ordinal);
        }
        int index = Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
        if (index >= 0) {
            return (DataTypeComponent)this.components.get(index);
        }
        return null;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getFrameSize() {
        return this.getLength();
    }

    public int getLocalSize() {
        return this.growsNegative ? this.negativeLength : this.positiveLength;
    }

    public int getParameterSize() {
        return this.growsNegative ? this.positiveLength : this.negativeLength;
    }

    public int getParameterOffset() {
        return this.splitOffset;
    }

    public boolean setLocalSize(int size) {
        return this.adjustStackFrameSize(size, this.getLocalSize(), this.growsNegative);
    }

    public boolean setParameterSize(int newParamSize) {
        return this.adjustStackFrameSize(newParamSize, this.getParameterSize(), !this.growsNegative);
    }

    private boolean adjustStackFrameSize(int newSize, int oldSize, boolean isNegative) {
        boolean shrinking;
        if (newSize < 0) {
            return false;
        }
        int delta = newSize - oldSize;
        if (delta == 0) {
            return true;
        }
        boolean bl = shrinking = delta < 0;
        if (!shrinking) {
            this.growStructure(isNegative ? -delta : delta);
            return true;
        }
        if (isNegative) {
            int oldOffset = this.getMinOffset();
            int newOffset = oldOffset - delta;
            this.deleteRange(oldOffset, newOffset - 1);
        } else {
            int oldOffset = this.getMaxOffset();
            int newOffset = oldOffset + delta;
            this.deleteRange(newOffset + 1, oldOffset);
        }
        return true;
    }

    void shiftParamOffset(int offset, int deltaOrdinal, int deltaLength) {
        int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
        if (index < 0) {
            index = -index - 1;
        }
        this.adjustOffsets(index, offset, deltaOrdinal, deltaLength);
        this.numComponents += deltaOrdinal;
        this.notifySizeChanged();
    }

    private void clearRange(int minOffset, int maxOffset) {
        int last;
        int first = Collections.binarySearch(this.components, new Integer(minOffset), offsetComparator);
        if (first < 0) {
            first = -first - 1;
        }
        if ((last = Collections.binarySearch(this.components, new Integer(maxOffset), offsetComparator)) < 0) {
            last = -last - 2;
        }
        for (int index = first; index < last; ++index) {
            this.clearComponent(index);
        }
    }

    private void deleteRange(int minOffset, int maxOffset) {
        int minOrdinal = this.getComponentAt(minOffset).getOrdinal();
        this.clearComponent(minOrdinal);
        int maxOrdinal = this.getComponentAt(maxOffset).getOrdinal();
        this.clearComponent(maxOrdinal);
        minOrdinal = this.getComponentAt(minOffset).getOrdinal();
        for (int i = maxOrdinal = this.getComponentAt(maxOffset).getOrdinal(); i >= minOrdinal; --i) {
            this.delete(i);
        }
    }

    public int getReturnAddressOffset() {
        return this.returnAddressOffset;
    }

    public void clearComponentAt(int offset) {
        if (offset < this.getMinOffset() || offset > this.getMaxOffset()) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
        if (index >= 0) {
            this.clearComponent(index);
        }
    }

    public Variable[] getStackVariables() {
        Variable[] vars = new Variable[this.components.size()];
        Iterator iter = this.components.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataTypeComponent dtc = (DataTypeComponent)iter.next();
            String fieldName = dtc.getFieldName();
            int offset = dtc.getOffset();
            try {
                vars[i] = new LocalVariableImpl(fieldName, dtc.getDataType(), offset, this.function.getProgram());
            }
            catch (InvalidInputException e) {
                try {
                    vars[i] = new LocalVariableImpl(fieldName, null, offset, this.function.getProgram());
                }
                catch (InvalidInputException e1) {
                    throw new AssertException();
                }
            }
            vars[i].setComment(dtc.getComment());
            ++i;
        }
        return vars;
    }

    public boolean growsNegative() {
        return this.growsNegative;
    }

    public boolean setName(int ordinal, String name) {
        String comment;
        int length;
        this.validateName(ordinal, name);
        DataTypeComponentImpl comp = this.getComponent(ordinal);
        String fieldName = comp.getFieldName();
        if (name != null && ((name = name.trim()).length() == 0 || this.isDefaultName(name))) {
            name = null;
        }
        if (SystemUtilities.isEqual((Object)name, (Object)fieldName)) {
            return false;
        }
        DataType dt = comp.getDataType();
        if (this.canDefineComponent(dt, length = comp.getLength(), name, comment = comp.getComment())) {
            DataTypeComponent newComp = this.replace(comp.getOrdinal(), dt, length, name, comment);
            return newComp != null;
        }
        this.clearComponent(ordinal);
        return true;
    }

    public boolean setComment(int ordinal, String comment) {
        String fieldName;
        int length;
        DataTypeComponentImpl comp = this.getComponent(ordinal);
        String oldComment = comp.getComment();
        if (comment != null && (comment = comment.trim()).length() == 0) {
            comment = null;
        }
        if (comment == null ? oldComment == null : comment.equals(oldComment)) {
            return false;
        }
        DataType dt = comp.getDataType();
        if (this.canDefineComponent(dt, length = comp.getLength(), fieldName = comp.getFieldName(), comment)) {
            DataTypeComponent newComp = this.replace(comp.getOrdinal(), dt, length, fieldName, comment);
            return newComp != null;
        }
        this.clearComponent(ordinal);
        return true;
    }

    private boolean canDefineComponent(DataType dt, int length, String newName, String comment) {
        if (comment != null && (comment = comment.trim()).length() == 0) {
            comment = null;
        }
        return !dt.isEquivalent(DataType.DEFAULT) || newName != null && newName.length() != 0 || comment != null;
    }

    void validateName(int ordinal, String newName) {
    }

    public DataTypeComponent setOffset(int ordinal, int newOffset) throws InvalidInputException {
        DataTypeComponentImpl comp = this.getComponent(ordinal);
        int oldOffset = comp.getOffset();
        int compLength = comp.getLength();
        if (newOffset == oldOffset) {
            return comp;
        }
        if (oldOffset >= this.splitOffset && newOffset < this.splitOffset || oldOffset < this.splitOffset && newOffset >= this.splitOffset) {
            throw new InvalidInputException("Cannot move a stack variable/parameter across the parameter offset.");
        }
        this.clearComponent(ordinal);
        DataTypeComponent existing = this.getDefinedComponentAt(newOffset);
        if (existing != null) {
            this.replaceAtOffset(oldOffset, comp.getDataType(), comp.getLength(), comp.getFieldName(), comp.getComment());
            throw new InvalidInputException("There is already a stack variable at offset " + StackFrameDataType.getHexString(newOffset, true) + ".");
        }
        existing = this.getComponentAt(newOffset);
        int mrl = this.getMaxLength(newOffset);
        if (mrl != -1 && compLength > mrl) {
            this.replaceAtOffset(oldOffset, comp.getDataType(), comp.getLength(), comp.getFieldName(), comp.getComment());
            throw new InvalidInputException(comp.getDataType().getDisplayName() + " doesn't fit at offset " + StackFrameDataType.getHexString(newOffset, true) + ". It needs " + compLength + " bytes, but " + mrl + " bytes are available.");
        }
        String defaultName = this.getDefaultName((DataTypeComponent)comp);
        String oldName = comp.getFieldName();
        boolean isDefault = oldName == null || oldName.equals(defaultName);
        DataTypeComponent newComp = this.replaceAtOffset(newOffset, comp.getDataType(), comp.getLength(), isDefault ? null : oldName, comp.getComment());
        return newComp;
    }

    public DataTypeComponent setDataType(int ordinal, DataType type, int length) {
        DataTypeComponentImpl dtc = this.getComponent(ordinal);
        return this.replace(ordinal, type, length, dtc.getFieldName(), dtc.getComment());
    }

    public int getMaxLength(int offset) {
        if (offset < this.getMinOffset() || offset > this.getMaxOffset()) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        int nextOffset = offset;
        int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
        index = index >= 0 ? ++index : -index - 1;
        nextOffset = index < this.components.size() ? ((DataTypeComponentImpl)this.components.get(index)).getOffset() : this.getMaxOffset() + 1;
        if (offset < 0 && nextOffset > 0) {
            nextOffset = 0;
        }
        if (offset < this.splitOffset && nextOffset > this.splitOffset) {
            nextOffset = this.splitOffset;
        }
        return nextOffset - offset;
    }

    public String getDefaultName(DataTypeComponent element) {
        boolean isLocal;
        int offset = element.getOffset();
        int paramBaseOffset = this.getParameterOffset();
        boolean bl = this.growsNegative ? offset < paramBaseOffset : (isLocal = offset >= paramBaseOffset);
        if (isLocal) {
            return SymbolUtilities.getDefaultLocalName((Program)this.function.getProgram(), (int)offset, (int)0);
        }
        int index = this.getParameterIndex(element);
        if (index >= 0) {
            return SymbolUtilities.getDefaultParamName((int)index);
        }
        return UNKNOWN_PREFIX + Integer.toHexString(Math.abs(offset));
    }

    private int getParameterIndex(DataTypeComponent element) {
        int numComps = this.components.size();
        int firstIndex = -1;
        int myIndex = -1;
        if (this.growsNegative) {
            DataTypeComponent dtc;
            int currentOffset;
            for (int i = numComps - 1; i >= 0 && (currentOffset = (dtc = (DataTypeComponent)this.components.get(i)).getOffset()) >= this.splitOffset; --i) {
                firstIndex = i;
                if (dtc != element) continue;
                myIndex = i;
            }
            if (myIndex >= 0) {
                return myIndex - firstIndex;
            }
        } else {
            DataTypeComponent dtc;
            int currentOffset;
            for (int i = 0; i < numComps && (currentOffset = (dtc = (DataTypeComponent)this.components.get(i)).getOffset()) < this.splitOffset; ++i) {
                firstIndex = i;
                if (dtc != element) continue;
                myIndex = i;
            }
            if (myIndex >= 0) {
                return firstIndex - myIndex;
            }
        }
        return 0;
    }

    public boolean isStackVariable(int ordinal) {
        if (ordinal < 0 || ordinal >= this.getNumComponents()) {
            return false;
        }
        int index = Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
        return index >= 0;
    }
}

