/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.TaskScheduler;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.searchmem.AsciiSearchFormat;
import ghidra.app.plugin.core.searchmem.BinarySearchFormat;
import ghidra.app.plugin.core.searchmem.DecimalSearchFormat;
import ghidra.app.plugin.core.searchmem.HexSearchFormat;
import ghidra.app.plugin.core.searchmem.MemSearchPlugin;
import ghidra.app.plugin.core.searchmem.RegExSearchFormat;
import ghidra.app.plugin.core.searchmem.SearchAllSearchInfo;
import ghidra.app.plugin.core.searchmem.SearchData;
import ghidra.app.plugin.core.searchmem.SearchFormat;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.layout.VariableRowHeightGridLayout;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.search.memory.CodeUnitSearchInfo;
import ghidra.util.search.memory.SearchInfo;
import ghidra.util.task.Task;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

class MemSearchDialog
extends DialogComponentProvider {
    static final String ADVANCED_BUTTON_NAME = "mem.search.advanced";
    private static final String CODE_UNIT_SCOPE_NAME = "Code Unit Scope";
    private static final int DEFAULT_MAX_ENTRIES = 10;
    public static final String ENTER_TEXT_MESSAGE = "Please enter a search value";
    private static final SearchData DEFAULT_SEARCH_DATA = SearchData.createInvalidInputSearchData("Please enter a search value");
    private static final int INPUT_FIELD_MIN_SIZE_WIDTH = 140;
    private static final int INPUT_FIELD_MIN_SIZE_HEIGHT = 25;
    MemSearchPlugin plugin;
    boolean isMnemonic;
    private JButton nextButton;
    private JButton previousButton;
    private JButton allButton;
    private JTextField valueField;
    private GhidraComboBox<String> valueComboBox;
    private List<String> history = new LinkedList<String>();
    private JLabel hexSeqField;
    private CardLayout formatOptionsLayout;
    private JRadioButton searchSelectionRadioButton;
    private JLabel alignLabel;
    private JTextField alignField;
    private JPanel formatOptionsPanel;
    private JRadioButton loadedBlocks;
    private JRadioButton allBlocks;
    private boolean navigatableHasSelection;
    private ChangeListener changeListener = e -> this.updateDisplay();
    private SearchData searchData = DEFAULT_SEARCH_DATA;
    private SearchFormat[] allFormats = new SearchFormat[]{new HexSearchFormat(this.changeListener), new AsciiSearchFormat(this.changeListener), new DecimalSearchFormat(this.changeListener), new BinarySearchFormat(this.changeListener), new RegExSearchFormat(this.changeListener)};
    private SearchFormat currentFormat = this.allFormats[0];
    private JRadioButton littleEndian;
    private JRadioButton bigEndian;
    private Container advancedPanel;
    private JRadioButton searchAllRadioButton;
    private List<JCheckBox> codeUnitTypesList;
    private JPanel mainPanel;
    private JToggleButton advancedButton;
    private boolean isSearching;
    private boolean hasValidSearchData;
    private boolean searchEnabled = true;

    MemSearchDialog(MemSearchPlugin plugin, boolean isBigEndian, boolean isMnemonic) {
        super("Search Memory", false, true, true, true);
        this.plugin = plugin;
        this.isMnemonic = isMnemonic;
        this.setHelpLocation(new HelpLocation("Search", "Search_Memory"));
        this.mainPanel = this.buildMainPanel();
        this.addWorkPanel(this.mainPanel);
        this.buildButtons();
        this.setEndianess(isBigEndian);
        this.setAlignment(1);
        this.setUseSharedLocation(true);
    }

    void setBytes(byte[] bytes) {
        if (this.valueField != null) {
            this.valueField.setText(null);
        }
        String convertBytesToString = NumericUtilities.convertBytesToString((byte[])bytes, (String)" ");
        this.valueField.setText(convertBytesToString);
    }

    void setAlignment(int alignment) {
        this.alignField.setText("" + alignment);
    }

    public void setSearchText(String maskedString) {
        this.valueField.setText(maskedString);
        this.updateDisplay();
    }

    void setEndianess(boolean isBigEndian) {
        if (isBigEndian) {
            this.bigEndian.setSelected(isBigEndian);
        } else {
            this.littleEndian.setSelected(true);
        }
        this.updateDisplay();
    }

    public void taskCancelled(Task task) {
        super.taskCancelled(task);
        this.isSearching = false;
        this.updateSearchButtonEnablement();
        this.clearStatusText();
    }

    public void taskCompleted(Task task) {
        super.taskCompleted(task);
        this.isSearching = false;
        this.updateSearchButtonEnablement();
    }

    private void setEndianEnabled(boolean enabled) {
        this.littleEndian.setEnabled(enabled);
        this.bigEndian.setEnabled(enabled);
    }

    protected void executeProgressTask(Task task, int delay) {
        super.executeProgressTask(task, delay);
    }

    private void updateSearchButtonEnablement() {
        this.nextButton.setEnabled(this.searchEnabled && !this.isSearching && this.hasValidSearchData);
        this.previousButton.setEnabled(this.searchEnabled && !this.isSearching && this.hasValidSearchData && this.currentFormat.supportsBackwardsSearch());
        this.allButton.setEnabled(this.searchEnabled && !this.isSearching && this.hasValidSearchData);
    }

    void setHasSelection(boolean hasSelection, boolean autoRestrictSelection) {
        this.searchSelectionRadioButton.setEnabled(hasSelection);
        if (this.navigatableHasSelection == hasSelection) {
            return;
        }
        if (autoRestrictSelection) {
            this.navigatableHasSelection = hasSelection;
            if (hasSelection && !this.isMnemonic) {
                this.searchSelectionRadioButton.setSelected(true);
            } else {
                this.searchAllRadioButton.setSelected(true);
            }
        }
    }

    protected void dismissCallback() {
        this.valueField.setText(null);
        this.hexSeqField.setText(null);
        this.cancelCurrentTask();
        this.close();
    }

    void show(ComponentProvider provider) {
        this.clearStatusText();
        this.valueField.requestFocus();
        this.valueField.selectAll();
        PluginTool tool = this.plugin.getTool();
        tool.showDialog((DialogComponentProvider)this, provider);
    }

    private void addToHistory(String input) {
        this.history.remove(input);
        this.history.add(0, input);
        this.truncateHistoryAsNeeded();
        this.updateCombo();
    }

    private void updateCombo() {
        String[] list = new String[this.history.size()];
        this.history.toArray(list);
        this.valueComboBox.setModel(new DefaultComboBoxModel<String>(list));
    }

    private void truncateHistoryAsNeeded() {
        int maxEntries = 10;
        int historySize = this.history.size();
        if (historySize > maxEntries) {
            int numToRemove = historySize - maxEntries;
            for (int i = 0; i < numToRemove; ++i) {
                this.history.remove(this.history.size() - 1);
            }
        }
    }

    private CodeUnitSearchInfo createCodeUnitSearchInfo() {
        return new CodeUnitSearchInfo(this.codeUnitTypesList.get(0).isSelected(), this.codeUnitTypesList.get(1).isSelected(), this.codeUnitTypesList.get(2).isSelected());
    }

    private void nextPreviousCallback(boolean forward) {
        int alignment = 1;
        try {
            alignment = this.getAlignment();
        }
        catch (InvalidInputException e) {
            this.plugin.disableSearchAgain();
            this.setStatusText(e.getMessage());
            this.alignField.selectAll();
            return;
        }
        if (this.searchData.isValidSearchData()) {
            if (this.plugin.searchOnce(new SearchInfo(this.searchData, 1, this.searchSelectionRadioButton.isSelected(), forward, alignment, this.allBlocks.isSelected(), this.createCodeUnitSearchInfo(), this.plugin.createTaskListener()))) {
                this.addToHistory(this.valueField.getText());
                this.setStatusText("Searching...");
                this.isSearching = true;
                this.updateSearchButtonEnablement();
            }
        } else {
            this.plugin.disableSearchAgain();
            this.setStatusText(this.searchData.getStatusMessage());
        }
    }

    private void allCallback() {
        int alignment = 1;
        try {
            alignment = this.getAlignment();
        }
        catch (InvalidInputException e) {
            this.plugin.disableSearchAgain();
            this.setStatusText(e.getMessage());
            this.alignField.selectAll();
            return;
        }
        if (this.searchData.isValidSearchData()) {
            if (this.plugin.searchAll(new SearchAllSearchInfo(this.searchData, this.plugin.getSearchLimit(), this.searchSelectionRadioButton.isSelected(), true, alignment, this.allBlocks.isSelected(), this.createCodeUnitSearchInfo()))) {
                this.addToHistory(this.valueField.getText());
                this.setStatusText("Searching...");
                this.isSearching = true;
                this.updateSearchButtonEnablement();
            }
        } else {
            this.plugin.disableSearchAgain();
            this.setStatusText(this.searchData.getStatusMessage());
        }
    }

    private JPanel buildSearchPanel() {
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        labelPanel.setLayout(new GridLayout(0, 1));
        labelPanel.add((Component)new GLabel("Search Value: "));
        labelPanel.add((Component)new GLabel("Hex Sequence: "));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new GridLayout(0, 1));
        this.valueComboBox = new GhidraComboBox();
        this.valueComboBox.setEditable(true);
        this.valueField = (JTextField)this.valueComboBox.getEditor().getEditorComponent();
        this.valueField.setToolTipText(this.currentFormat.getToolTip());
        this.valueField.setDocument(new RestrictedInputDocument());
        this.valueField.addActionListener(ev -> {
            if (this.nextButton.isEnabled()) {
                this.nextPreviousCallback(true);
            }
        });
        inputPanel.add((Component)this.valueComboBox);
        this.hexSeqField = new GDLabel();
        this.hexSeqField.setName("HexSequenceField");
        this.hexSeqField.setBorder(BorderFactory.createLoweredBevelBorder());
        Dimension size = new Dimension(140, 25);
        this.valueComboBox.setPreferredSize(size);
        this.valueComboBox.setMinimumSize(size);
        this.hexSeqField.setPreferredSize(size);
        this.hexSeqField.setMinimumSize(size);
        inputPanel.add(this.hexSeqField);
        JPanel searchPanel = new JPanel(new BorderLayout());
        searchPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        searchPanel.add((Component)labelPanel, "West");
        searchPanel.add((Component)inputPanel, "Center");
        return searchPanel;
    }

    private SearchFormat findFormat(String name) {
        for (SearchFormat element : this.allFormats) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return this.allFormats[0];
    }

    private JPanel buildMainPanel() {
        JPanel newMainPanel = new JPanel();
        newMainPanel.setLayout(new BorderLayout());
        newMainPanel.add((Component)this.buildSearchPanel(), "North");
        newMainPanel.add((Component)this.buildOptionsPanel(), "Center");
        this.advancedPanel = this.buildAdvancedPanel();
        JPanel searchOptionsPanel = new JPanel(new BorderLayout());
        newMainPanel.add((Component)searchOptionsPanel, "South");
        return newMainPanel;
    }

    private void setAdvancedPanelVisible(boolean visible) {
        if (visible) {
            this.mainPanel.add((Component)this.advancedPanel, "East");
        } else {
            this.mainPanel.remove(this.advancedPanel);
        }
        this.repack();
    }

    private Container createSeparatorPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        panel.add(new JSeparator(1));
        return panel;
    }

    private Container buildAdvancedPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
        panel.add((Component)this.createSeparatorPanel(), "West");
        panel.add(this.buildAdvancedPanelContents());
        return panel;
    }

    private Container buildAdvancedPanelContents() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.add(this.buildEndienessPanel());
        panel.add(this.buildCodeUnitTypesPanel());
        panel.add(this.buildAlignmentPanel());
        return panel;
    }

    private Container buildEndienessPanel() {
        ButtonGroup endianGroup = new ButtonGroup();
        this.littleEndian = new GRadioButton("Little Endian", true);
        this.bigEndian = new GRadioButton("Big Endian", false);
        endianGroup.add(this.bigEndian);
        endianGroup.add(this.littleEndian);
        this.littleEndian.addActionListener(ev -> {
            this.currentFormat.setEndieness(false);
            this.updateDisplay();
        });
        this.bigEndian.addActionListener(ev -> {
            this.currentFormat.setEndieness(true);
            this.updateDisplay();
        });
        JPanel endianPanel = new JPanel();
        endianPanel.setLayout(new BoxLayout(endianPanel, 1));
        endianPanel.add(this.littleEndian);
        endianPanel.add(this.bigEndian);
        endianPanel.setBorder(BorderFactory.createTitledBorder("Byte Order"));
        return endianPanel;
    }

    private Container buildCodeUnitTypesPanel() {
        GCheckBox instructionsCheckBox = new GCheckBox("Instructions", true);
        GCheckBox definedCheckBox = new GCheckBox("Defined Data", true);
        GCheckBox undefinedCheckBox = new GCheckBox("Undefined Data", true);
        ItemListener stateListener = e -> this.validate();
        this.codeUnitTypesList = new ArrayList<JCheckBox>();
        this.codeUnitTypesList.add((JCheckBox)instructionsCheckBox);
        this.codeUnitTypesList.add((JCheckBox)definedCheckBox);
        this.codeUnitTypesList.add((JCheckBox)undefinedCheckBox);
        instructionsCheckBox.addItemListener(stateListener);
        definedCheckBox.addItemListener(stateListener);
        undefinedCheckBox.addItemListener(stateListener);
        JPanel codeUnitTypePanel = new JPanel();
        codeUnitTypePanel.setLayout(new BoxLayout(codeUnitTypePanel, 1));
        codeUnitTypePanel.add((Component)instructionsCheckBox);
        codeUnitTypePanel.add((Component)definedCheckBox);
        codeUnitTypePanel.add((Component)undefinedCheckBox);
        codeUnitTypePanel.setBorder(BorderFactory.createTitledBorder(CODE_UNIT_SCOPE_NAME));
        return codeUnitTypePanel;
    }

    private Component buildSelectionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder("Selection Scope"));
        this.searchSelectionRadioButton = new GRadioButton("Search Selection");
        this.searchAllRadioButton = new GRadioButton("Search All");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.searchSelectionRadioButton);
        buttonGroup.add(this.searchAllRadioButton);
        this.searchAllRadioButton.setSelected(true);
        panel.add(this.searchAllRadioButton);
        panel.add(this.searchSelectionRadioButton);
        JPanel selectionPanel = new JPanel();
        selectionPanel.setLayout(new BorderLayout());
        selectionPanel.add((Component)panel, "North");
        return selectionPanel;
    }

    private Component buildAlignmentPanel() {
        this.alignLabel = new GDLabel("Alignment: ");
        this.alignField = new JTextField(5);
        this.alignField.setName("Alignment");
        this.alignField.setText("0");
        JPanel alignPanel = new JPanel(new FlowLayout(2));
        alignPanel.add(this.alignLabel);
        alignPanel.add(this.alignField);
        return alignPanel;
    }

    private JPanel buildFormatPanel() {
        JPanel formatPanel = new JPanel();
        formatPanel.setBorder(BorderFactory.createTitledBorder("Format"));
        formatPanel.setLayout(new GridLayout(0, 1));
        ButtonGroup formatGroup = new ButtonGroup();
        ActionListener formatButtonListener = ev -> {
            String formatName = ((JRadioButton)ev.getSource()).getText();
            this.currentFormat = this.findFormat(formatName);
            this.formatOptionsLayout.show(this.formatOptionsPanel, this.currentFormat.getName());
            this.updateDisplay();
        };
        for (SearchFormat element : this.allFormats) {
            GRadioButton formatButton = new GRadioButton(element.getName(), true);
            formatButton.setToolTipText(element.getToolTip());
            formatGroup.add((AbstractButton)formatButton);
            formatButton.addActionListener(formatButtonListener);
            formatPanel.add((Component)formatButton);
            if (!element.getName().equals("Binary") || !this.isMnemonic) continue;
            formatButton.setSelected(true);
            this.currentFormat = element;
        }
        return formatPanel;
    }

    private JPanel buildFormatOptionsPanel() {
        this.formatOptionsPanel = new JPanel();
        this.formatOptionsLayout = new CardLayout();
        this.formatOptionsPanel.setLayout(this.formatOptionsLayout);
        for (SearchFormat element : this.allFormats) {
            JPanel panel = element.getOptionsPanel();
            this.formatOptionsPanel.add((Component)panel, element.getName());
        }
        return this.formatOptionsPanel;
    }

    private JPanel buildOptionsPanel() {
        JPanel formatPanel = this.buildFormatPanel();
        this.formatOptionsPanel = this.buildFormatOptionsPanel();
        JPanel extrasPanel = this.buildExtrasPanel();
        JPanel northPanel = new JPanel();
        northPanel.setLayout((LayoutManager)new VariableRowHeightGridLayout(10, 10, 2));
        northPanel.add(formatPanel);
        northPanel.add(this.formatOptionsPanel);
        northPanel.add(extrasPanel);
        northPanel.add(this.buildSelectionPanel());
        this.advancedButton = new JToggleButton("Advanced >>");
        this.advancedButton.setName(ADVANCED_BUTTON_NAME);
        this.advancedButton.addActionListener(e -> {
            boolean selected = this.advancedButton.isSelected();
            if (selected) {
                this.advancedButton.setText("Advanced <<");
            } else {
                this.advancedButton.setText("Advanced >>");
            }
            this.setAdvancedPanelVisible(this.advancedButton.isSelected());
        });
        this.advancedButton.setFocusable(false);
        JPanel advancedButtonPanel = new JPanel();
        advancedButtonPanel.setLayout(new BoxLayout(advancedButtonPanel, 0));
        advancedButtonPanel.add(Box.createHorizontalGlue());
        advancedButtonPanel.add(Box.createVerticalStrut(40));
        advancedButtonPanel.add(this.advancedButton);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 20, 10));
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.add(northPanel);
        optionsPanel.add(advancedButtonPanel);
        return optionsPanel;
    }

    private JPanel buildExtrasPanel() {
        ButtonGroup memoryBlockGroup = new ButtonGroup();
        this.loadedBlocks = new GRadioButton("Loaded Blocks", true);
        this.allBlocks = new GRadioButton("All Blocks", false);
        memoryBlockGroup.add(this.loadedBlocks);
        memoryBlockGroup.add(this.allBlocks);
        this.loadedBlocks.setToolTipText(HTMLUtilities.toHTML((String)"Only searches memory blocks that are loaded in a running executable.\n  Ghidra now includes memory blocks for other data such as section headers.\nThis option exludes these OTHER (non loaded) blocks."));
        this.allBlocks.setToolTipText("Searches all memory blocks including blocks that are not actually loaded in a running executable");
        JPanel directionPanel = new JPanel();
        directionPanel.setLayout(new BoxLayout(directionPanel, 1));
        directionPanel.add(this.loadedBlocks);
        directionPanel.add(this.allBlocks);
        directionPanel.setBorder(BorderFactory.createTitledBorder("Memory Block Types"));
        JPanel extrasPanel = new JPanel();
        extrasPanel.setLayout(new BorderLayout());
        extrasPanel.add((Component)directionPanel, "North");
        return extrasPanel;
    }

    private void buildButtons() {
        this.nextButton = new JButton("Next");
        this.nextButton.setMnemonic('N');
        this.nextButton.addActionListener(ev -> this.nextPreviousCallback(true));
        this.addButton(this.nextButton);
        this.previousButton = new JButton("Previous");
        this.previousButton.setMnemonic('P');
        this.previousButton.addActionListener(ev -> this.nextPreviousCallback(false));
        this.addButton(this.previousButton);
        this.allButton = new JButton("Search All");
        this.allButton.setMnemonic('A');
        this.allButton.addActionListener(ev -> this.allCallback());
        this.allButton.setName("Search All");
        this.addButton(this.allButton);
        this.addDismissButton();
        this.updateSearchButtonEnablement();
    }

    private void updateSearchData(SearchData newSearchData) {
        this.searchData = newSearchData;
        this.hexSeqField.setText(this.searchData.getHexString());
        this.validate();
    }

    private void validate() {
        if (!this.searchData.isValidSearchData() || !this.searchData.isValidInputData()) {
            this.setStatusText(this.searchData.getStatusMessage());
            this.hasValidSearchData = false;
        } else if (!this.isValidCodeUnitSearchType()) {
            this.setStatusText("You must select at least one type of code unit to search in Code Unit Scope");
            this.hasValidSearchData = false;
        } else {
            this.setStatusText("");
            this.hasValidSearchData = true;
        }
        this.updateSearchButtonEnablement();
    }

    private boolean isValidCodeUnitSearchType() {
        for (JCheckBox checkBox : this.codeUnitTypesList) {
            if (!checkBox.isSelected()) continue;
            return true;
        }
        return false;
    }

    protected TaskScheduler getTaskScheduler() {
        return super.getTaskScheduler();
    }

    private void updateDisplay() {
        this.clearStatusText();
        this.updateSearchData();
        this.setEndianEnabled(this.currentFormat.usesEndieness());
        this.updateSearchButtonEnablement();
        this.valueField.setToolTipText(this.currentFormat.getToolTip());
    }

    private void updateSearchData() {
        this.currentFormat.setEndieness(this.bigEndian.isSelected());
        SearchData inputData = this.currentFormat.getSearchData(this.valueField.getText());
        if (this.valueField.getText().trim().length() != 0 && inputData.isValidInputData()) {
            this.updateSearchData(inputData);
        } else {
            this.valueField.setText("");
            this.updateSearchData(DEFAULT_SEARCH_DATA);
        }
    }

    public int getAlignment() throws InvalidInputException {
        String alignStr = this.alignField.getText();
        int len = 0;
        try {
            Integer ilen = Integer.decode(alignStr);
            len = ilen;
        }
        catch (NumberFormatException e) {
            throw new InvalidInputException("The alignment must be a number greater than 0.");
        }
        if (len <= 0) {
            throw new InvalidInputException("The alignment must be a number greater than 0.");
        }
        return len;
    }

    boolean getShowAdvancedOptions() {
        return this.advancedButton.isSelected();
    }

    void setShowAdvancedOptions(boolean selected) {
        if (this.advancedButton.isSelected() != selected) {
            this.advancedButton.doClick();
        }
    }

    void setSearchEnabled(boolean b) {
        this.searchEnabled = b;
    }

    void searchCompleted() {
        this.isSearching = false;
        this.updateSearchButtonEnablement();
    }

    String getSearchText() {
        return this.valueComboBox.getText();
    }

    public class RestrictedInputDocument
    extends DefaultStyledDocument {
        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            MemSearchDialog.this.clearStatusText();
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(offs, currentText.length());
            String proposedText = beforeOffset + str + afterOffset;
            String match = this.handleHistoryMatch(currentText, proposedText);
            if (match != null) {
                super.insertString(offs, match.substring(beforeOffset.length()), a);
                MemSearchDialog.this.valueField.setSelectionStart(proposedText.length());
                MemSearchDialog.this.valueField.setSelectionEnd(match.length());
                return;
            }
            SearchData inputData = MemSearchDialog.this.currentFormat.getSearchData(proposedText);
            if (inputData.isValidInputData()) {
                MemSearchDialog.this.updateSearchData(inputData);
                super.insertString(offs, str, a);
            } else {
                MemSearchDialog.this.setStatusText(inputData.getStatusMessage());
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            MemSearchDialog.this.clearStatusText();
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(len + offs, currentText.length());
            String proposedResult = beforeOffset + afterOffset;
            if (proposedResult.length() == 0) {
                MemSearchDialog.this.updateSearchData(DEFAULT_SEARCH_DATA);
                super.remove(offs, len);
                return;
            }
            SearchData inputData = MemSearchDialog.this.currentFormat.getSearchData(proposedResult);
            if (inputData.isValidInputData()) {
                super.remove(offs, len);
                MemSearchDialog.this.updateSearchData(inputData);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private String handleHistoryMatch(String currentText, String proposedText) {
            SearchData matchData;
            boolean textAppended = proposedText.startsWith(currentText);
            String match = this.findHistoryMatchString(proposedText);
            if (match != null && textAppended && (matchData = MemSearchDialog.this.currentFormat.getSearchData(match)).isValidInputData()) {
                MemSearchDialog.this.updateSearchData(matchData);
                return match;
            }
            return null;
        }

        private String findHistoryMatchString(String input) {
            for (String historyString : MemSearchDialog.this.history) {
                if (!historyString.startsWith(input)) continue;
                return historyString;
            }
            return null;
        }
    }
}

