/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import generic.json.Json;
import ghidra.util.HTMLUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LocationReferenceContext {
    private static final String EMBOLDEN_START = "<span style=\"background-color: #a3e4d7; color: black;\"><b><font size=4>";
    private static final String EMBOLDEN_END = "</font></b></span>";
    public static final LocationReferenceContext EMPTY_CONTEXT = new LocationReferenceContext();
    private final List<Part> parts;

    public static LocationReferenceContext get(String text) {
        return text == null ? EMPTY_CONTEXT : new LocationReferenceContext(text);
    }

    public static LocationReferenceContext get(LocationReferenceContext context) {
        return context == null ? EMPTY_CONTEXT : context;
    }

    private LocationReferenceContext() {
        this.parts = List.of(new BasicPart(""));
    }

    private LocationReferenceContext(String context) {
        Objects.requireNonNull(context);
        this.parts = List.of(new BasicPart(context));
    }

    LocationReferenceContext(List<Part> parts) {
        this.parts = parts;
    }

    public String getPlainText() {
        StringBuilder buffy = new StringBuilder();
        for (Part part : this.parts) {
            buffy.append(part.getText());
        }
        return buffy.toString();
    }

    public String getBoldMatchingText() {
        StringBuilder buffy = new StringBuilder();
        for (Part part : this.parts) {
            buffy.append(part.getHtmlText());
        }
        return "<HTML>" + buffy.toString();
    }

    public List<String> getMatches() {
        ArrayList<String> matches = new ArrayList<String>();
        for (Part part : this.parts) {
            if (!(part instanceof MatchPart)) continue;
            matches.add(part.getText());
        }
        return matches;
    }

    public String toString() {
        return Json.toString((Object)this);
    }

    static class MatchPart
    extends Part {
        MatchPart(String text) {
            super(text);
        }

        @Override
        String getText(String start, String end) {
            return start + this.text + end;
        }

        @Override
        String getHtmlText() {
            String escaped = HTMLUtilities.escapeHTML((String)this.text);
            String updated = MatchPart.fixBreakingSpaces(escaped);
            return LocationReferenceContext.EMBOLDEN_START + updated + LocationReferenceContext.EMBOLDEN_END;
        }
    }

    static class BasicPart
    extends Part {
        BasicPart(String text) {
            super(text);
        }

        @Override
        String getText(String start, String end) {
            return this.text;
        }

        @Override
        String getHtmlText() {
            String escaped = HTMLUtilities.escapeHTML((String)this.text);
            String updated = BasicPart.fixBreakingSpaces(escaped);
            return updated;
        }
    }

    static abstract class Part {
        protected String text;

        Part(String text) {
            this.text = text;
        }

        String getText() {
            return this.text;
        }

        abstract String getHtmlText();

        abstract String getText(String var1, String var2);

        static String fixBreakingSpaces(String s) {
            String updated = s.replaceAll("\\s", "&nbsp;");
            return updated;
        }

        public String toString() {
            return Json.toString((Object)this);
        }
    }
}

