/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.symbol.EquateManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

class RenameEquateCmd
implements Command {
    private String oldEquateName;
    private String newEquateName;
    private Enum enoom;
    private Address addr;
    private int opIndex;
    private String msg;

    RenameEquateCmd(String oldEquateName, String newEquateName, Address addr, int opIndex) {
        this.oldEquateName = oldEquateName;
        this.newEquateName = newEquateName;
        this.addr = addr;
        this.opIndex = opIndex;
    }

    RenameEquateCmd(String oldEquateName, Enum enoom, Address addr, int opIndex) {
        this.oldEquateName = oldEquateName;
        this.enoom = enoom;
        this.addr = addr;
        this.opIndex = opIndex;
    }

    public String getName() {
        return "Rename Equate";
    }

    public boolean applyTo(DomainObject obj) {
        Equate toEquate;
        Program program = (Program)obj;
        EquateTable etable = program.getEquateTable();
        Equate fromEquate = etable.getEquate(this.oldEquateName);
        if (fromEquate == null) {
            this.msg = "Equate not found: " + this.oldEquateName;
            return false;
        }
        long value = fromEquate.getValue();
        if (fromEquate.getReferenceCount() <= 1) {
            etable.removeEquate(this.oldEquateName);
        } else {
            fromEquate.removeReference(this.addr, this.opIndex);
        }
        if (this.newEquateName == null && this.enoom != null) {
            this.enoom = (Enum)program.getDataTypeManager().addDataType((DataType)this.enoom, null);
            this.newEquateName = EquateManager.formatNameForEquate((UniversalID)this.enoom.getUniversalID(), (long)value);
        }
        if ((toEquate = etable.getEquate(this.newEquateName)) == null) {
            try {
                toEquate = etable.createEquate(this.newEquateName, value);
            }
            catch (DuplicateNameException e) {
                throw new AssertException();
            }
            catch (InvalidInputException e) {
                this.msg = "Invalid equate name: " + this.newEquateName;
                return false;
            }
        }
        toEquate.addReference(this.addr, this.opIndex);
        return true;
    }

    public String getStatusMsg() {
        return this.msg;
    }
}

