/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.util;

import docking.widgets.OptionDialog;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import ghidra.app.plugin.core.datamgr.DataTypeSyncInfo;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ProgramArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataTypeTreeCopyMoveTask
extends Task {
    private static final int NODE_COUNT_FOR_COLLAPSING_TREE = 100;
    private DataTypeArchiveGTree gTree;
    private GTreeNode destinationNode;
    private List<GTreeNode> droppedNodes;
    private Archive sourceArchive;
    private Archive destinationArchive;
    private ActionType actionType;
    private DataTypeConflictHandler conflictHandler;
    private List<String> errors = new ArrayList<String>();

    DataTypeTreeCopyMoveTask() {
        super("Drag/Drop", true, true, true);
    }

    public DataTypeTreeCopyMoveTask(GTreeNode destinationNode, List<GTreeNode> droppedNodeList, ActionType actionType, DataTypeArchiveGTree gTree, DataTypeConflictHandler conflictHandler) {
        super("Drag/Drop", true, true, true);
        this.destinationNode = destinationNode;
        this.droppedNodes = droppedNodeList;
        this.actionType = actionType;
        this.gTree = gTree;
        this.conflictHandler = conflictHandler;
        this.destinationArchive = this.findArchive(destinationNode);
        GTreeNode firstNode = this.droppedNodes.get(0);
        this.sourceArchive = this.findArchive(firstNode);
    }

    private Archive findArchive(GTreeNode node) {
        while (node != null) {
            if (node instanceof ArchiveNode) {
                return ((ArchiveNode)node).getArchive();
            }
            node = node.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) throws CancelledException {
        int nodeCount = this.droppedNodes.size();
        this.filterRedundantNodes();
        if (this.checkForDifferentSourceArchives()) {
            return;
        }
        GTreeState treeState = this.gTree.getTreeState();
        try {
            if (nodeCount > 100) {
                this.collapseArchives();
            }
            if (this.needToCreateAssociation()) {
                this.associateDataTypes(monitor);
            }
            this.doCopy(monitor);
        }
        catch (CancelledException e) {
            return;
        }
        finally {
            this.gTree.restoreTreeState(treeState);
        }
        this.reportErrors();
    }

    private void reportErrors() {
        if (this.errors.isEmpty()) {
            return;
        }
        Object message = this.errors.get(0);
        int n = this.errors.size();
        if (n > 1) {
            message = "Encountered " + n + " errors copying/moving.  See the log for details";
        }
        Msg.showError((Object)((Object)this), (Component)((Object)this.gTree), (String)"Encountered Errors Copying/Moving", (Object)message);
    }

    private boolean checkForDifferentSourceArchives() {
        for (GTreeNode node : this.droppedNodes) {
            if (this.sourceArchive == this.findArchive(node)) continue;
            Msg.showError((Object)((Object)this), (Component)((Object)this.gTree), (String)"Copy Failed", (Object)"All dragged data types must be from the same archive!");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopy(TaskMonitor monitor) {
        DataTypeManager dtm = this.destinationArchive.getDataTypeManager();
        int txId = dtm.startTransaction("Copy/Move Category/DataType");
        try {
            if (this.destinationNode instanceof DataTypeNode) {
                this.dragNodeToDataType();
            } else {
                this.dragNodesToCategory(monitor);
            }
        }
        finally {
            dtm.endTransaction(txId, true);
        }
    }

    private boolean needToCreateAssociation() {
        return this.sourceArchive != this.destinationArchive && !(this.destinationArchive instanceof ProgramArchive) && this.sourceArchive instanceof ProgramArchive;
    }

    private void collapseArchives() {
        GTreeNode root = this.gTree.getModelRoot();
        List children = root.getChildren();
        for (GTreeNode archive : children) {
            this.gTree.collapseAll(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void associateDataTypes(TaskMonitor monitor) throws CancelledException {
        if (!this.promptToAssociateTypes(monitor)) {
            return;
        }
        monitor.initialize((long)this.droppedNodes.size());
        SourceArchive destination = this.destinationArchive.getDataTypeManager().getLocalSourceArchive();
        DataTypeManager dtm = this.sourceArchive.getDataTypeManager();
        int txId = dtm.startTransaction("Associate DataTypes");
        try {
            for (GTreeNode node : this.droppedNodes) {
                monitor.checkCanceled();
                if (node instanceof DataTypeNode) {
                    DataType dt = ((DataTypeNode)node).getDataType();
                    this.associateDataType(dt, dtm, destination);
                } else if (node instanceof CategoryNode) {
                    Category cat = ((CategoryNode)node).getCategory();
                    this.associateDataTypes(cat, dtm, destination);
                }
                monitor.incrementProgress(1L);
            }
        }
        finally {
            dtm.endTransaction(txId, true);
        }
    }

    private boolean promptToAssociateTypes(TaskMonitor monitor) throws CancelledException {
        if (!this.containsUnassociatedTypes(monitor)) {
            return false;
        }
        int result = this.askToAssociateDataTypes();
        if (result == 0) {
            throw new CancelledException();
        }
        return result == 1;
    }

    private boolean containsUnassociatedTypes(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Checking for types to associate");
        monitor.initialize((long)this.droppedNodes.size());
        for (GTreeNode node : this.droppedNodes) {
            DataType dt;
            monitor.checkCanceled();
            if (node instanceof DataTypeNode ? this.isLocal(dt = ((DataTypeNode)node).getDataType()) : node instanceof CategoryNode && this.containsUnassociatedTypes(((CategoryNode)node).getCategory(), monitor)) {
                return true;
            }
            monitor.incrementProgress(1L);
        }
        return false;
    }

    private boolean containsUnassociatedTypes(Category cat, TaskMonitor monitor) throws CancelledException {
        Category[] categories;
        DataType[] types;
        for (DataType dt : types = cat.getDataTypes()) {
            monitor.checkCanceled();
            if (!this.isLocal(dt)) continue;
            return true;
        }
        for (Category child : categories = cat.getCategories()) {
            monitor.checkCanceled();
            if (!this.containsUnassociatedTypes(child, monitor)) continue;
            return true;
        }
        return false;
    }

    private void associateDataType(DataType dt, DataTypeManager dtm, SourceArchive source) {
        if (!this.isLocal(dt)) {
            return;
        }
        dtm.associateDataTypeWithArchive(dt, source);
    }

    private void associateDataTypes(Category cat, DataTypeManager dtm, SourceArchive destination) {
        Category[] categories;
        DataType[] dataTypes;
        for (DataType dataType : dataTypes = cat.getDataTypes()) {
            this.associateDataType(dataType, dtm, destination);
        }
        for (Category category : categories = cat.getCategories()) {
            this.associateDataTypes(category, dtm, destination);
        }
    }

    private void dragNodesToCategory(TaskMonitor monitor) {
        monitor.setMessage("Drag/Drop Categories/Data Types");
        monitor.initialize((long)this.droppedNodes.size());
        Category toCategory = this.getCategory(this.destinationNode);
        for (GTreeNode node : this.droppedNodes) {
            if (monitor.isCancelled()) break;
            monitor.setMessage("Adding " + node.getName());
            if (this.actionType == ActionType.COPY || this.sourceArchive != this.destinationArchive) {
                this.copyNode(toCategory, node, monitor);
            } else {
                this.moveNode(toCategory, node, monitor);
            }
            monitor.incrementProgress(1L);
        }
    }

    private void copyNode(Category toCategory, GTreeNode node, TaskMonitor monitor) {
        if (node instanceof DataTypeNode) {
            DataType nodeDt = ((DataTypeNode)node).getDataType();
            this.copyDataType(toCategory, nodeDt);
        } else if (node instanceof CategoryNode) {
            Category category = ((CategoryNode)node).getCategory();
            this.copyCategory(toCategory, category, monitor);
        }
    }

    private void copyDataType(Category toCategory, DataType dataType) {
        DataType resolvedDt;
        DataType newDt;
        DataTypeManager nodeDtm;
        DataTypeManager dtm = toCategory.getDataTypeManager();
        boolean sameManager = dtm == (nodeDtm = dataType.getDataTypeManager());
        DataType dataType2 = newDt = !sameManager ? dataType.clone(nodeDtm) : dataType.copy(nodeDtm);
        if (sameManager && newDt.getCategoryPath().equals((Object)toCategory.getCategoryPath())) {
            this.renameAsCopy(toCategory, newDt);
        }
        if ((resolvedDt = toCategory.addDataType(newDt, this.conflictHandler)) instanceof Pointer || resolvedDt instanceof Array || resolvedDt instanceof BuiltInDataType || resolvedDt instanceof MissingBuiltInDataType) {
            return;
        }
        if (!resolvedDt.getCategoryPath().equals((Object)toCategory.getCategoryPath())) {
            this.errors.add("Data type copy failed.  Another copy of this data type already exists at " + resolvedDt.getPathName());
        }
    }

    private void renameAsCopy(Category destinationCategory, DataType dataType) {
        String dtName = dataType.getName();
        String baseName = this.getBaseName(dtName);
        String copyName = this.getNextCopyName(destinationCategory, baseName);
        try {
            dataType.setName(copyName);
        }
        catch (InvalidNameException | DuplicateNameException e) {
            this.errors.add("Problem creating copy of " + baseName + ". " + e.getMessage());
        }
    }

    String getBaseName(String dtName) {
        Pattern p = Pattern.compile("Copy_(?:\\d+_)*of_(.*)");
        Matcher matcher = p.matcher(dtName);
        if (!matcher.matches()) {
            return dtName;
        }
        String baseName = matcher.group(1);
        return baseName;
    }

    String getNextCopyName(Category destinationCategory, String baseName) {
        String format = "Copy_%d_of_" + baseName;
        for (int i = 1; i < 100; ++i) {
            String copyName = String.format(format, i);
            if (destinationCategory.getDataType(copyName) != null) continue;
            return copyName;
        }
        return String.format(format, System.currentTimeMillis());
    }

    private void moveNode(Category destinationCategory, GTreeNode node, TaskMonitor monitor) {
        if (node instanceof DataTypeNode) {
            DataType dataType = ((DataTypeNode)node).getDataType();
            this.moveDataType(destinationCategory, dataType);
        } else if (node instanceof CategoryNode) {
            Category category = ((CategoryNode)node).getCategory();
            this.moveCategory(destinationCategory, category, monitor);
        }
    }

    private void moveCategory(Category toCategory, Category category, TaskMonitor monitor) {
        if (category.getParent() == toCategory) {
            return;
        }
        try {
            CategoryPath path = toCategory.getCategoryPath();
            if (path.isAncestorOrSelf(category.getCategoryPath())) {
                this.errors.add("Cannot move a parent node onto a child node.  Moving " + category + " to " + toCategory);
                return;
            }
            toCategory.moveCategory(category, monitor);
        }
        catch (DuplicateNameException e) {
            this.errors.add("Move failed due to duplicate name.   Moving " + category + " to " + toCategory + ": " + e.getMessage());
        }
    }

    private void moveDataType(Category toCategory, DataType dataType) {
        if (dataType.getCategoryPath().equals((Object)toCategory.getCategoryPath())) {
            this.errors.add("Move failed.  DataType is already in this category.  Category " + toCategory + "; Data type: " + dataType);
            return;
        }
        try {
            toCategory.moveDataType(dataType, this.conflictHandler);
        }
        catch (DataTypeDependencyException e) {
            this.errors.add("Move failed.  DataType is already in this category.  Category " + toCategory + "; Data type: " + dataType + ". " + e.getMessage());
        }
    }

    private void copyCategory(Category toCategory, Category category, TaskMonitor monitor) {
        boolean sameManager;
        CategoryPath toPath = toCategory.getCategoryPath();
        boolean bl = sameManager = toCategory.getDataTypeManager() == category.getDataTypeManager();
        if (sameManager && toPath.isAncestorOrSelf(category.getCategoryPath())) {
            this.errors.add("Copy failed.  Cannot copy a parent node onto a child node. Moving " + category + " to " + toCategory);
            return;
        }
        toCategory.copyCategory(category, this.conflictHandler, monitor);
    }

    private Category getCategory(GTreeNode node) {
        if (node instanceof ArchiveNode) {
            return ((ArchiveNode)node).getArchive().getDataTypeManager().getRootCategory();
        }
        if (node instanceof CategoryNode) {
            return ((CategoryNode)node).getCategory();
        }
        throw new AssertException("Expected node to be either an ArchiveNode or CategoryNode but was " + node.getClass());
    }

    private boolean isAssociatedEitherWay(DataType dt1, DataType dt2) {
        return this.isAssociated(dt1, dt2) || this.isAssociated(dt2, dt1);
    }

    private boolean isAssociated(DataType sourceDt, DataType destinationDt) {
        UniversalID destinationID = destinationDt.getUniversalID();
        if (destinationID == null || !destinationID.equals((Object)sourceDt.getUniversalID())) {
            return false;
        }
        if (!this.haveSameSourceArchive(sourceDt, destinationDt)) {
            return false;
        }
        return this.isLocal(sourceDt);
    }

    private boolean haveSameSourceArchive(DataType dt1, DataType dt2) {
        SourceArchive s1 = dt1.getSourceArchive();
        SourceArchive s2 = dt2.getSourceArchive();
        return s1.getSourceArchiveID().equals((Object)s2.getSourceArchiveID());
    }

    private boolean isLocal(DataType dt) {
        UniversalID sourceId = dt.getSourceArchive().getSourceArchiveID();
        UniversalID dtmId = dt.getDataTypeManager().getUniversalID();
        return sourceId.equals((Object)dtmId);
    }

    private void dragNodeToDataType() {
        DataType destinationDt = ((DataTypeNode)this.destinationNode).getDataType();
        GTreeNode node = this.droppedNodes.get(0);
        DataType replacementDt = ((DataTypeNode)node).getDataType();
        if (this.sourceArchive != this.destinationArchive) {
            if (this.isAssociatedEitherWay(replacementDt, destinationDt)) {
                this.handleAssociatedType(destinationDt, replacementDt);
                return;
            }
            replacementDt = replacementDt.clone(replacementDt.getDataTypeManager());
        } else if (this.actionType == ActionType.COPY) {
            replacementDt = replacementDt.copy(replacementDt.getDataTypeManager());
        }
        this.replaceDataType(destinationDt, replacementDt);
    }

    private void handleAssociatedType(DataType destinationDt, DataType replacementDt) {
        if (this.isLocal(destinationDt)) {
            DataTypeSyncInfo syncInfo = new DataTypeSyncInfo(replacementDt, destinationDt.getDataTypeManager());
            if (!syncInfo.canCommit()) {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)((Object)this.gTree), (String)"Commit Data Type", (Object)"No changes to commit");
            } else if (this.confirmCommit()) {
                DataTypeSynchronizer.commit(destinationDt.getDataTypeManager(), replacementDt);
            }
        } else {
            DataTypeSyncInfo syncInfo = new DataTypeSyncInfo(destinationDt, replacementDt.getDataTypeManager());
            if (!syncInfo.canUpdate()) {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)((Object)this.gTree), (String)"Update Data Type", (Object)"No changes to copy");
            } else if (this.confirmUpdate()) {
                DataTypeSynchronizer.update(destinationDt.getDataTypeManager(), replacementDt);
            }
        }
    }

    private boolean confirmCommit() {
        return this.confirm("Commit Data Type?", "Do you want to commit the changes to this data type back to the source Archive? \n(Warning: any changes in the source archive will be overwritten.)");
    }

    private boolean confirmUpdate() {
        return this.confirm("Update Data Type?", "Do you want to update this data type with the changes in the source Archive?\n(Warning: any local changes will be overwritten.)");
    }

    private boolean confirm(String title, String message) {
        int choice = OptionDialog.showYesNoDialog((Component)((Object)this.gTree), (String)title, (String)message);
        return choice == 1;
    }

    private int askToAssociateDataTypes() {
        return OptionDialog.showYesNoCancelDialog((Component)((Object)this.gTree), (String)"Associate DataTypes?", (String)"Do you want to associate local datatypes with the target archive?");
    }

    private void replaceDataType(DataType existingDt, DataType replacementDt) {
        int choice = OptionDialog.showYesNoDialog((Component)((Object)this.gTree), (String)"Replace Data Type?", (String)("Replace " + existingDt.getPathName() + "\nwith " + replacementDt.getPathName() + "?"));
        if (choice == 1) {
            try {
                DataTypeManager dtMgr = existingDt.getDataTypeManager();
                dtMgr.replaceDataType(existingDt, replacementDt, true);
            }
            catch (DataTypeDependencyException e) {
                this.errors.add("Replace failed.  Existing type " + existingDt + "; replacment type " + replacementDt + ". " + e.getMessage());
            }
        }
    }

    private void filterRedundantNodes() {
        HashSet<GTreeNode> nodeSet = new HashSet<GTreeNode>(this.droppedNodes);
        ArrayList<GTreeNode> filteredList = new ArrayList<GTreeNode>();
        for (GTreeNode node : nodeSet) {
            if (this.containsAncestor(nodeSet, node)) continue;
            filteredList.add(node);
        }
        this.droppedNodes = filteredList;
    }

    private boolean containsAncestor(Set<GTreeNode> nodeSet, GTreeNode node) {
        GTreeNode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        if (nodeSet.contains(parent)) {
            return true;
        }
        return this.containsAncestor(nodeSet, parent);
    }

    public static enum ActionType {
        COPY,
        MOVE;

    }
}

