/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.actions.PopupActionProvider;
import docking.widgets.table.GTable;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.bookmark.AddBookmarkAction;
import ghidra.app.plugin.core.bookmark.BookmarkDeleteCmd;
import ghidra.app.plugin.core.bookmark.BookmarkEditCmd;
import ghidra.app.plugin.core.bookmark.BookmarkNavigator;
import ghidra.app.plugin.core.bookmark.BookmarkProvider;
import ghidra.app.plugin.core.bookmark.CreateBookmarkDialog;
import ghidra.app.plugin.core.bookmark.DeleteBookmarkAction;
import ghidra.app.plugin.core.bookmark.FilterDialog;
import ghidra.app.plugin.core.bookmark.FilterState;
import ghidra.app.services.BookmarkService;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerService;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.task.SwingUpdateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import resources.Icons;
import resources.MultiIconBuilder;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Manage Bookmarks", description="This plugin allows the user to add, edit, delete, and show bookmarks. It adds navigation markers at addresses where bookmarks reside.", servicesRequired={GoToService.class, MarkerService.class}, servicesProvided={BookmarkService.class}, eventsProduced={ProgramSelectionPluginEvent.class})
public class BookmarkPlugin
extends ProgramPlugin
implements DomainObjectListener,
PopupActionProvider,
BookmarkService {
    private static final int MAX_DELETE_ACTIONS = 10;
    static final int TIMER_DELAY = 500;
    public static final int MIN_TIMEOUT = 1000;
    public static final int MAX_TIMEOUT = 1200000;
    private BookmarkProvider provider;
    private DockingAction addAction;
    private DockingAction deleteAction;
    private CreateBookmarkDialog createDialog;
    private GoToService goToService;
    private MarkerService markerService;
    private BookmarkManager bookmarkMgr;
    private SwingUpdateManager repaintMgr;
    private Map<String, BookmarkNavigator> bookmarkNavigators = new HashMap<String, BookmarkNavigator>();
    private NavUpdater navUpdater;

    public BookmarkPlugin(PluginTool tool) {
        super(tool, true, true);
        this.provider = new BookmarkProvider(tool, this);
        this.provider.addToTool();
        this.createActions();
    }

    public void readConfigState(SaveState saveState) {
        super.readConfigState(saveState);
        this.provider.readConfigState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        if (this.provider != null) {
            this.provider.writeConfigState(saveState);
        }
    }

    private void createActions() {
        this.addAction = new AddBookmarkAction(this);
        this.addAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)this.addAction);
        MultiIconBuilder builder = new MultiIconBuilder((Icon)Icons.CONFIGURE_FILTER_ICON);
        builder.addLowerRightIcon((Icon)ResourceManager.loadImage((String)"images/check.png"));
        final ImageIcon filterTypesChanged = builder.build();
        final ImageIcon filterTypesUnchanged = Icons.CONFIGURE_FILTER_ICON;
        DockingAction filterAction = new DockingAction("Filter Bookmarks", this.getName()){

            public void actionPerformed(ActionContext context) {
                BookmarkPlugin.this.filterBookmarks();
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (BookmarkPlugin.this.currentProgram == null) {
                    this.setToolBarData(new ToolBarData(filterTypesUnchanged));
                    return false;
                }
                boolean hasTypeFilter = BookmarkPlugin.this.provider.hasTypeFilterApplied();
                Icon icon = hasTypeFilter ? filterTypesChanged : filterTypesUnchanged;
                this.setToolBarData(new ToolBarData(icon));
                return true;
            }
        };
        filterAction.setToolBarData(new ToolBarData((Icon)filterTypesUnchanged));
        filterAction.setDescription("Adjust Filters");
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)filterAction);
        this.deleteAction = new DockingAction("Delete Bookmarks", this.getName()){

            public void actionPerformed(ActionContext context) {
                BookmarkPlugin.this.provider.delete();
            }
        };
        ImageIcon icon = ResourceManager.loadImage((String)"images/edit-delete.png");
        this.deleteAction.setKeyBindingData(new KeyBindingData(127, 0));
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}, (Icon)icon));
        this.deleteAction.setDescription("Delete Selected Bookmarks");
        this.deleteAction.setEnabled(true);
        this.deleteAction.setToolBarData(new ToolBarData((Icon)icon));
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.deleteAction);
        DockingAction selectionAction = new DockingAction("Select Bookmark Locations", this.getName()){

            public void actionPerformed(ActionContext context) {
                BookmarkPlugin.this.select(BookmarkPlugin.this.provider.getBookmarkLocations());
            }
        };
        icon = ResourceManager.loadImage((String)"images/text_align_justify.png");
        selectionAction.setPopupMenuData(new MenuData(new String[]{"Select Bookmark Locations"}, (Icon)icon));
        selectionAction.setToolBarData(new ToolBarData((Icon)icon));
        selectionAction.setEnabled(true);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)selectionAction);
        SelectionNavigationAction selectionNavigationAction = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)selectionNavigationAction);
    }

    public void filterBookmarks() {
        FilterDialog d = new FilterDialog(this.provider, this.currentProgram);
        this.tool.showDialog((DialogComponentProvider)d, (ComponentProvider)this.provider);
        this.provider.contextChanged();
    }

    public synchronized void dispose() {
        this.navUpdater.dispose();
        this.tool.removePopupActionProvider((PopupActionProvider)this);
        if (this.repaintMgr != null) {
            this.repaintMgr.dispose();
        }
        if (this.addAction != null) {
            this.addAction.dispose();
            this.addAction = null;
        }
        if (this.provider != null) {
            this.provider.dispose();
            this.provider = null;
        }
        if (this.createDialog != null) {
            this.createDialog.dispose();
            this.createDialog = null;
        }
        this.goToService = null;
        this.disposeAllBookmarkers();
        this.markerService = null;
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        this.currentProgram = null;
        super.dispose();
    }

    protected void init() {
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
        this.provider.setGoToService(this.goToService);
        this.markerService = (MarkerService)this.tool.getService(MarkerService.class);
        this.tool.addPopupActionProvider((PopupActionProvider)this);
        this.navUpdater = new NavUpdater();
        this.repaintMgr = new SwingUpdateManager(500, () -> this.provider.repaint());
    }

    MarkerService getMarkerService() {
        return this.markerService;
    }

    private void initializeBookmarkers() {
        if (this.currentProgram == null) {
            return;
        }
        BookmarkManager mgr = this.currentProgram.getBookmarkManager();
        BookmarkNavigator.defineBookmarkTypes(this.currentProgram);
        Runnable r = () -> {
            if (this.currentProgram == null) {
                return;
            }
            BookmarkPlugin bookmarkPlugin = this;
            synchronized (bookmarkPlugin) {
                BookmarkType[] types;
                for (BookmarkType element : types = mgr.getBookmarkTypes()) {
                    this.getBookmarkNavigator(element);
                    this.scheduleUpdate(element.getTypeString());
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private void disposeAllBookmarkers() {
        for (BookmarkNavigator nav : this.bookmarkNavigators.values()) {
            nav.dispose();
        }
        this.bookmarkNavigators.clear();
    }

    private BookmarkNavigator getBookmarkNavigator(BookmarkType type) {
        if (type == null) {
            return null;
        }
        String typeString = type.getTypeString();
        BookmarkNavigator nav = this.bookmarkNavigators.get(typeString);
        if (nav == null) {
            nav = new BookmarkNavigator(this.markerService, this.currentProgram.getBookmarkManager(), type);
            this.bookmarkNavigators.put(typeString, nav);
        }
        return nav;
    }

    private synchronized void scheduleUpdate(String type) {
        this.navUpdater.addType(type);
    }

    public synchronized void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(4) || ev.containsEvent(23) || ev.containsEvent(21)) {
            this.scheduleUpdate(null);
            this.provider.reload();
            return;
        }
        block6: for (int i = 0; i < ev.numRecords(); ++i) {
            DomainObjectChangeRecord record = ev.getChangeRecord(i);
            int eventType = record.getEventType();
            if (!(record instanceof ProgramChangeRecord)) continue;
            switch (eventType) {
                case 123: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Bookmark bookmark = (Bookmark)rec.getObject();
                    this.bookmarkRemoved(bookmark);
                    continue block6;
                }
                case 122: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Bookmark bookmark = (Bookmark)rec.getObject();
                    this.bookmarkAdded(bookmark);
                    continue block6;
                }
                case 124: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Bookmark bookmark = (Bookmark)rec.getObject();
                    this.bookmarkChanged(bookmark);
                    continue block6;
                }
                case 120: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    BookmarkType bookmarkType = (BookmarkType)rec.getObject();
                    if (bookmarkType == null) continue block6;
                    this.typeAdded(bookmarkType.getTypeString());
                    continue block6;
                }
                default: {
                    this.repaintMgr.update();
                }
            }
        }
    }

    @Override
    public void setBookmarksVisible(boolean visible) {
        this.tool.showComponentProvider((ComponentProvider)this.provider, visible);
    }

    private void typeAdded(String type) {
        this.provider.typeAdded(type);
        this.getBookmarkNavigator(this.bookmarkMgr.getBookmarkType(type));
    }

    private void bookmarkChanged(Bookmark bookmark) {
        if (bookmark == null) {
            this.scheduleUpdate(null);
            this.provider.reload();
            return;
        }
        BookmarkNavigator nav = this.getBookmarkNavigator(bookmark.getType());
        nav.add(bookmark.getAddress());
        this.scheduleUpdate(bookmark.getType().getTypeString());
        this.provider.bookmarkChanged(bookmark);
    }

    private void bookmarkAdded(Bookmark bookmark) {
        if (bookmark == null) {
            this.scheduleUpdate(null);
            this.provider.reload();
            return;
        }
        BookmarkNavigator nav = this.getBookmarkNavigator(bookmark.getType());
        nav.add(bookmark.getAddress());
        this.provider.bookmarkAdded(bookmark);
    }

    private void bookmarkRemoved(Bookmark bookmark) {
        if (bookmark == null) {
            this.scheduleUpdate(null);
            this.provider.reload();
            return;
        }
        String type = bookmark.getTypeString();
        BookmarkNavigator nav = this.bookmarkNavigators.get(type);
        if (nav != null) {
            Address addr = bookmark.getAddress();
            Bookmark[] bookmarks = this.currentProgram.getBookmarkManager().getBookmarks(addr, type);
            if (bookmarks.length == 0) {
                nav.clear(addr);
            }
        }
        this.provider.bookmarkRemoved(bookmark);
    }

    @Override
    protected synchronized void programDeactivated(Program program) {
        this.provider.setProgram(null);
        this.navUpdater.setProgram(null);
        program.removeListener((DomainObjectListener)this);
        this.disposeAllBookmarkers();
        this.bookmarkMgr = null;
    }

    public Object getTransientState() {
        return this.provider.getFilterState();
    }

    public void restoreTransientState(Object state) {
        this.provider.restoreFilterState((FilterState)state);
    }

    @Override
    protected synchronized void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.navUpdater.setProgram(program);
        this.initializeBookmarkers();
        this.provider.setProgram(program);
        this.bookmarkMgr = program.getBookmarkManager();
    }

    void showAddBookmarkDialog(Address location) {
        Listing listing = this.currentProgram.getListing();
        CodeUnit currCU = listing.getCodeUnitContaining(location);
        if (currCU == null) {
            return;
        }
        boolean hasSelection = this.currentSelection != null && !this.currentSelection.isEmpty();
        this.createDialog = new CreateBookmarkDialog(this, currCU, hasSelection);
        this.tool.showDialog((DialogComponentProvider)this.createDialog);
    }

    public void setNote(Address addr, String category, String comment) {
        CompoundCmd cmd = new CompoundCmd("Set Note Bookmark");
        if (addr != null) {
            cmd.add((Command)new BookmarkDeleteCmd(addr, "Note"));
            cmd.add((Command)new BookmarkEditCmd(addr, "Note", category, comment));
        } else {
            AddressSet set = new AddressSet();
            AddressRangeIterator iter = this.currentSelection.getAddressRanges();
            while (iter.hasNext()) {
                Address minAddr = ((AddressRange)iter.next()).getMinAddress();
                set.addRange(minAddr, minAddr);
            }
            cmd.add((Command)new BookmarkDeleteCmd((AddressSetView)set, "Note"));
            cmd.add((Command)new BookmarkEditCmd((AddressSetView)set, "Note", category, comment));
        }
        this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
    }

    void deleteBookmark(Bookmark bookmark) {
        BookmarkDeleteCmd cmd = new BookmarkDeleteCmd(bookmark);
        this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
    }

    private void select(ProgramSelection selection) {
        this.firePluginEvent(new ProgramSelectionPluginEvent(this.getName(), selection, this.currentProgram));
    }

    public List<DockingActionIf> getPopupActions(Tool activeTool, ActionContext context) {
        Object contextObject = context.getContextObject();
        if (!(contextObject instanceof MarkerLocation)) {
            return null;
        }
        MarkerLocation loc = (MarkerLocation)contextObject;
        BookmarkManager mgr = this.currentProgram.getBookmarkManager();
        Address address = loc.getAddr();
        Bookmark[] bookmarks = mgr.getBookmarks(address);
        ArrayList<DockingActionIf> defaultBookmarkList = new ArrayList<DockingActionIf>();
        for (Bookmark element : bookmarks) {
            DeleteBookmarkAction action = new DeleteBookmarkAction(this, element, false);
            action.setEnabled(true);
            defaultBookmarkList.add((DockingActionIf)action);
        }
        ArrayList<DockingActionIf> popupActionList = new ArrayList<DockingActionIf>();
        this.addActionsToList(popupActionList, defaultBookmarkList, 10);
        List<DockingActionIf> actionsForCodeUnitList = this.getActionsForCodeUnit(address, 10 - popupActionList.size());
        this.addActionsToList(popupActionList, actionsForCodeUnitList, 10);
        return popupActionList;
    }

    private List<DockingActionIf> getActionsForCodeUnit(Address primaryAddress, int maxActionsCount) {
        ArrayList<DockingActionIf> actionList = new ArrayList<DockingActionIf>();
        Iterator<String> iter = this.bookmarkNavigators.keySet().iterator();
        while (iter.hasNext() && actionList.size() < maxActionsCount) {
            String bookmarkType = iter.next();
            BookmarkNavigator navigator = this.bookmarkNavigators.get(bookmarkType);
            List<DockingActionIf> typeDeleteActionList = this.getActionsForCodeUnitAndType(primaryAddress, bookmarkType, navigator);
            this.addActionsToList(actionList, typeDeleteActionList, maxActionsCount);
        }
        return actionList;
    }

    private List<DockingActionIf> getActionsForCodeUnitAndType(Address primaryAddress, String type, BookmarkNavigator navigator) {
        Address end;
        ArrayList<DockingActionIf> actionList = new ArrayList<DockingActionIf>();
        CodeUnit cu = this.currentProgram.getListing().getCodeUnitContaining(primaryAddress);
        if (cu == null) {
            return actionList;
        }
        Address start = cu.getMinAddress();
        if (!navigator.intersects(start, end = cu.getMaxAddress())) {
            return actionList;
        }
        for (int i = 1; i < cu.getLength(); ++i) {
            Bookmark[] otherBookmarks;
            Address nextCodeUnitAddress = start.add((long)i);
            if (nextCodeUnitAddress.equals((Object)primaryAddress) || (otherBookmarks = this.bookmarkMgr.getBookmarks(nextCodeUnitAddress, type)).length <= 0) continue;
            DeleteBookmarkAction action = new DeleteBookmarkAction(this, otherBookmarks[0], true);
            action.setEnabled(true);
            actionList.add((DockingActionIf)action);
        }
        return actionList;
    }

    private void addActionsToList(List<DockingActionIf> actionList, List<DockingActionIf> newActionList, int maxActionCount) {
        for (int i = 0; i < newActionList.size() && actionList.size() < maxActionCount; ++i) {
            actionList.add(newActionList.get(i));
        }
    }

    GTable getBookmarkTable() {
        return this.provider.getBookmarkTable();
    }

    private class NavUpdater
    implements Runnable {
        private Set<String> types = new HashSet<String>();
        private SwingUpdateManager updateMgr = new SwingUpdateManager(1000, 1200000, () -> this.timerExpired());
        private boolean running;
        private volatile Program program;

        NavUpdater() {
        }

        private synchronized void timerExpired() {
            if (this.running) {
                this.updateMgr.updateLater();
            } else {
                Thread t = new Thread((Runnable)this, "Bookmark Plugin Nav Updater");
                t.setDaemon(true);
                t.setPriority(2);
                t.setName("Bookmark Navigation Update");
                t.start();
            }
        }

        public synchronized void addType(String type) {
            if (type != null) {
                this.types.add(type);
            } else {
                Iterator<String> it = BookmarkPlugin.this.bookmarkNavigators.keySet().iterator();
                while (it.hasNext()) {
                    this.types.add(it.next());
                }
            }
            this.updateMgr.update();
        }

        void dispose() {
            this.updateMgr.dispose();
        }

        synchronized void setProgram(Program program) {
            this.program = program;
            this.types.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NavUpdater navUpdater;
            block10: {
                Program myProgram = this.program;
                Set<String> myTypes = null;
                navUpdater = this;
                synchronized (navUpdater) {
                    if (this.types.isEmpty()) {
                        return;
                    }
                    myTypes = this.types;
                    this.types = new HashSet<String>();
                    this.running = true;
                }
                try {
                    for (String type : myTypes) {
                        this.updateNav(type);
                    }
                }
                catch (Throwable t) {
                    if (this.updateMgr.isDisposed() || this.program != myProgram) break block10;
                    Msg.showError((Object)BookmarkPlugin.this, null, (String)"Unexpected Error", (Object)"Unexpected exception update bookmark markers", (Throwable)t);
                }
            }
            navUpdater = this;
            synchronized (navUpdater) {
                this.running = false;
            }
        }

        private void updateNav(String type) {
            BookmarkNavigator nav = BookmarkPlugin.this.bookmarkNavigators.get(type);
            if (nav != null) {
                nav.updateBookmarkers(this.getAddresses(type));
            }
        }

        private AddressSet getAddresses(String type) {
            AddressSet set = new AddressSet();
            Iterator it = BookmarkPlugin.this.bookmarkMgr.getBookmarksIterator(type);
            while (it.hasNext()) {
                Bookmark bm = (Bookmark)it.next();
                Address addr = bm.getAddress();
                set.addRange(addr, addr);
            }
            return set;
        }
    }
}

