/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.DescriptionLevel;
import SWIG.SBProcess;
import SWIG.SBStream;
import SWIG.SBTarget;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.cmd.LldbContinueCommand;
import agent.lldb.model.iface2.LldbModelTargetDebugContainer;
import agent.lldb.model.iface2.LldbModelTargetModuleContainer;
import agent.lldb.model.iface2.LldbModelTargetProcessContainer;
import agent.lldb.model.iface2.LldbModelTargetSession;
import agent.lldb.model.impl.LldbModelTargetDebugContainerImpl;
import agent.lldb.model.impl.LldbModelTargetModuleContainerImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetProcessContainerImpl;
import agent.lldb.model.impl.LldbModelTargetSessionAttributesImpl;
import agent.lldb.model.impl.LldbModelTargetSessionContainerImpl;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Session", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Debug", type=LldbModelTargetDebugContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Attributes", type=LldbModelTargetSessionAttributesImpl.class, fixed=true), @TargetAttributeType(name="Processes", type=LldbModelTargetProcessContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Modules", type=LldbModelTargetModuleContainerImpl.class, required=true, fixed=true), @TargetAttributeType(type=Void.class)})
public class LldbModelTargetSessionImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetSession {
    protected static final String Lldb_PROMPT = "(kd)";
    protected final LldbModelTargetDebugContainer debug;
    protected final LldbModelTargetModuleContainer modules;
    protected final LldbModelTargetSessionAttributesImpl attributes;
    protected final LldbModelTargetProcessContainerImpl processes;
    protected String debugger = "kd";

    protected static String indexSession(SBTarget session) {
        return DebugClient.getId(session);
    }

    protected static String keySession(SBTarget session) {
        return PathUtils.makeKey((String)LldbModelTargetSessionImpl.indexSession(session));
    }

    public LldbModelTargetSessionImpl(LldbModelTargetSessionContainerImpl sessions, SBTarget session) {
        super(sessions.getModel(), (TargetObject)sessions, LldbModelTargetSessionImpl.keySession(session), session, "Session");
        this.getManager().getClient().addBroadcaster(session);
        this.debug = new LldbModelTargetDebugContainerImpl(this);
        this.attributes = new LldbModelTargetSessionAttributesImpl(this);
        this.processes = new LldbModelTargetProcessContainerImpl(this);
        this.modules = new LldbModelTargetModuleContainerImpl(this);
        this.changeAttributes(List.of(), List.of(this.debug, this.attributes, this.processes, this.modules), Map.of("_display", this.getDescription(0), "_accessible", this.accessible, "_prompt", "(lldb)", "_state", TargetExecutionStateful.TargetExecutionState.ALIVE), "Initialized");
        this.getManager().addEventsListener(this);
    }

    @Override
    public String getDescription(int level) {
        SBStream stream = new SBStream();
        SBTarget session = (SBTarget)this.getModelObject();
        DescriptionLevel detail = DescriptionLevel.swigToEnum((int)level);
        session.GetDescription(stream, detail);
        return stream.GetData();
    }

    @Override
    public CompletableFuture<Void> setActive() {
        return this.getManager().setActiveSession(this.getSession());
    }

    @Override
    public boolean isAccessible() {
        return this.accessible;
    }

    @Override
    public LldbModelTargetProcessContainer getProcesses() {
        return this.processes;
    }

    @Override
    public LldbModelTargetModuleContainer getModules() {
        return this.modules;
    }

    public SBTarget getSession() {
        return (SBTarget)this.getModelObject();
    }

    @Override
    public CompletableFuture<Void> resume() {
        SBProcess currentProcess = this.getManager().getCurrentProcess();
        return this.model.gateFuture(this.getManager().execute(new LldbContinueCommand(this.getManager(), currentProcess)));
    }
}

