/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.ByteOrder;
import SWIG.SBPlatform;
import SWIG.SBProcess;
import SWIG.SBTarget;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbCause;
import agent.lldb.model.iface2.LldbModelTargetSessionAttributes;
import agent.lldb.model.iface2.LldbModelTargetSessionAttributesPlatform;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForProducer;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

@TargetObjectSchemaInfo(name="SessionAttributesPlatform", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)})
public class LldbModelTargetSessionAttributesPlatformImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetSessionAttributesPlatform {
    static String ARCH_ATTRIBUTE_NAME = "Arch";
    static String MANUFACTURER_ATTRIBUTE_NAME = "Manufacturer";
    static String OS_ATTRIBUTE_NAME = "OS";
    static String OS_MM_ATTRIBUTE_NAME = "Major:Minor";
    static String OS_DESC_ATTRIBUTE_NAME = "Description";
    static String DEBUGGER_ATTRIBUTE_NAME = "Debugger";
    static String BUILD_ATTRIBUTE_NAME = "Build";
    static String ENDIAN_ATTRIBUTE_NAME = "Endian";
    static String DIRECTORY_ATTRIBUTE_NAME = "Working Dir";
    SBTarget session = (SBTarget)this.getModelObject();

    public LldbModelTargetSessionAttributesPlatformImpl(LldbModelTargetSessionAttributes attributes) {
        super(attributes.getModel(), (TargetObject)attributes, "Platform", "SessionAttributesPlatform");
        String desc;
        String[] triple = this.session.GetTriple().split("-");
        ByteOrder order = this.session.GetByteOrder();
        SBPlatform platform = this.session.GetPlatform();
        long major = platform.GetOSMajorVersion();
        long minor = platform.GetOSMinorVersion();
        String build = platform.GetOSBuild();
        if (build == null) {
            build = "unknown";
        }
        if ((desc = platform.GetOSDescription()) == null) {
            desc = "unknown";
        }
        String wdir = platform.GetWorkingDirectory();
        this.changeAttributes(List.of(), List.of(), Map.of(ARCH_ATTRIBUTE_NAME, triple[0], MANUFACTURER_ATTRIBUTE_NAME, triple[1], OS_ATTRIBUTE_NAME, triple[2], OS_DESC_ATTRIBUTE_NAME, desc, DEBUGGER_ATTRIBUTE_NAME, "lldb", OS_MM_ATTRIBUTE_NAME, major + ":" + minor, BUILD_ATTRIBUTE_NAME, build, ENDIAN_ATTRIBUTE_NAME, order.toString(), DIRECTORY_ATTRIBUTE_NAME, wdir), "Initialized");
        this.getManager().addEventsListener(this);
    }

    @Override
    public void sessionAdded(SBTarget session, LldbCause cause) {
        this.refreshInternal();
    }

    @Override
    public void processAdded(SBProcess process, LldbCause cause) {
        SBTarget procTarget = process.GetTarget();
        if (!DebugClient.getId(this.session).equals(DebugClient.getId(procTarget))) {
            return;
        }
        this.refreshInternal();
    }

    public void refreshInternal() {
        AtomicReference capture = new AtomicReference();
        AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> this.getManager().consoleCapture("version").handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1)), capture).then(seq -> this.changeAttributes(List.of(), List.of(), Map.of(DEBUGGER_ATTRIBUTE_NAME, (String)capture.get()), "Refreshed")).finish();
    }
}

