/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBProcess;
import SWIG.SBTarget;
import SWIG.SBThread;
import SWIG.StateType;
import agent.lldb.lldb.DebugClient;
import agent.lldb.lldb.DebugModuleInfo;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.LldbReason;
import agent.lldb.model.iface1.LldbModelTargetConfigurable;
import agent.lldb.model.iface2.LldbModelTargetModuleContainer;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.iface2.LldbModelTargetProcessContainer;
import agent.lldb.model.iface2.LldbModelTargetSession;
import agent.lldb.model.iface2.LldbModelTargetThreadContainer;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetProcessImpl;
import agent.lldb.model.impl.LldbModelTargetSessionImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ProcessContainer", elements={@TargetElementType(type=LldbModelTargetProcessImpl.class)}, attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetProcessContainerImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetProcessContainer,
LldbModelTargetConfigurable {
    private LldbModelTargetSessionImpl session;

    public LldbModelTargetProcessContainerImpl(LldbModelTargetSessionImpl session) {
        super(session.getModel(), (TargetObject)session, "Processes", "ProcessContainer");
        this.session = session;
        this.changeAttributes(List.of(), Map.of("_base", 16), "Initialized");
        this.getManager().addEventsListener(this);
    }

    @Override
    public void processAdded(SBProcess proc, LldbCause cause) {
        LldbModelTargetSession session = (LldbModelTargetSession)this.getParent();
        SBTarget parentTarget = (SBTarget)session.getModelObject();
        SBTarget procTarget = proc.GetTarget();
        if (!DebugClient.getId(parentTarget).equals(DebugClient.getId(procTarget))) {
            return;
        }
        session.setAccessible(true);
        LldbModelTargetProcess process = this.getTargetProcess(proc);
        this.changeElements(List.of(), List.of(process), Map.of(), "Added");
        process.processStarted(proc);
        ((DebuggerModelListener)this.getListeners().fire).event((TargetObject)this.getProxy(), null, TargetEventScope.TargetEventType.PROCESS_CREATED, "Process " + DebugClient.getId(proc) + " started " + process.getName(), List.of(process));
    }

    @Override
    public void processReplaced(SBProcess proc, LldbCause cause) {
        LldbModelTargetSession session = (LldbModelTargetSession)this.getParent();
        session.setAccessible(true);
        LldbModelTargetProcess process = this.getTargetProcess(proc);
        this.changeElements(List.of(), List.of(process), Map.of(), "Added");
    }

    @Override
    public void processStarted(SBProcess proc, LldbCause cause) {
        LldbModelTargetProcess process = this.getTargetProcess(proc);
        process.processStarted(proc);
    }

    @Override
    public void processRemoved(String processId, LldbCause cause) {
        this.changeElements(List.of(processId), List.of(), Map.of(), "Removed");
    }

    @Override
    public void threadCreated(SBThread thread, LldbCause cause) {
        LldbModelTargetProcess process = this.getTargetProcess(thread.GetProcess());
        LldbModelTargetThreadContainer threads = process.getThreads();
        if (threads != null) {
            threads.threadCreated(thread);
        }
    }

    @Override
    public void threadReplaced(SBThread thread, LldbCause cause) {
        LldbModelTargetProcess process = this.getTargetProcess(thread.GetProcess());
        process.getThreads().threadReplaced(thread);
    }

    @Override
    public void threadStateChanged(SBThread thread, StateType state, LldbCause cause, LldbReason reason) {
        LldbModelTargetProcess process = this.getTargetProcess(thread.GetProcess());
        process.threadStateChanged(thread, state, cause, reason);
    }

    @Override
    public void threadExited(SBThread thread, SBProcess proc, LldbCause cause) {
        LldbModelTargetProcess process = this.getTargetProcess(proc);
        if (process != null) {
            process.getThreads().threadExited(thread);
        }
    }

    @Override
    public void moduleLoaded(SBProcess proc, DebugModuleInfo info, int index, LldbCause cause) {
        LldbModelTargetModuleContainer modules = this.session.getModules();
        if (modules != null) {
            modules.libraryLoaded(info, index);
        }
    }

    @Override
    public void moduleUnloaded(SBProcess proc, DebugModuleInfo info, int index, LldbCause cause) {
        LldbModelTargetModuleContainer modules = this.session.getModules();
        if (modules != null) {
            modules.libraryUnloaded(info, index);
        }
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.getManager().listProcesses(this.session.getSession()).thenAccept(byIID -> {
            List processes;
            LldbModelTargetProcessContainerImpl lldbModelTargetProcessContainerImpl = this;
            synchronized (lldbModelTargetProcessContainerImpl) {
                processes = byIID.values().stream().map(this::getTargetProcess).collect(Collectors.toList());
            }
            this.setElements(processes, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized LldbModelTargetProcess getTargetProcess(SBProcess process) {
        TargetObject targetObject = this.getMapObject(process);
        if (targetObject != null) {
            LldbModelTargetProcess targetProcess = (LldbModelTargetProcess)targetObject;
            targetProcess.setModelObject(process);
            return targetProcess;
        }
        return new LldbModelTargetProcessImpl(this, process);
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (TargetObject child : this.getCachedElements().values()) {
                        if (!(child instanceof LldbModelTargetProcessImpl)) continue;
                        LldbModelTargetProcessImpl targetProcess = (LldbModelTargetProcessImpl)child;
                        targetProcess.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }
}

