/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBModule;
import SWIG.SBSection;
import agent.lldb.model.iface2.LldbModelTargetModule;
import agent.lldb.model.iface2.LldbModelTargetModuleSection;
import agent.lldb.model.iface2.LldbModelTargetModuleSectionContainer;
import agent.lldb.model.impl.LldbModelTargetModuleSectionImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRangeImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="SectionContainer", elements={@TargetElementType(type=LldbModelTargetModuleSectionImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetModuleSectionContainerImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetModuleSectionContainer {
    protected final LldbModelTargetModule module;

    public LldbModelTargetModuleSectionContainerImpl(LldbModelTargetModule module) {
        super(module.getModel(), (TargetObject)module, "Sections", "ModuleSections");
        this.module = module;
        this.requestElements(false);
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.getManager().listModuleSections(this.module.getModule()).thenAccept(byStart -> {
            LldbModelTargetModuleSectionContainerImpl lldbModelTargetModuleSectionContainerImpl = this;
            synchronized (lldbModelTargetModuleSectionContainerImpl) {
                List sections = byStart.values().stream().map(this::getModuleSection).collect(Collectors.toList());
                this.setElements(sections, "Refreshed");
                this.updateRange();
            }
        });
    }

    protected synchronized LldbModelTargetModuleSection getModuleSection(SBSection section) {
        TargetObject targetObject = this.getMapObject(section);
        if (targetObject != null) {
            LldbModelTargetModuleSection targetSection = (LldbModelTargetModuleSection)targetObject;
            targetSection.setModelObject(section);
            return targetSection;
        }
        return new LldbModelTargetModuleSectionImpl(this, section);
    }

    public void updateRange() {
        Map elements = this.getCachedElements();
        Address min = null;
        Address max = null;
        for (TargetObject element : elements.values()) {
            Address stop;
            LldbModelTargetModuleSectionImpl section = (LldbModelTargetModuleSectionImpl)element;
            Address start = section.getStart();
            if (start.getOffset() > 0L && (min == null || min.getOffset() > start.getOffset())) {
                min = start;
            }
            if ((stop = section.getEnd()).getOffset() <= 0L || max != null && max.getOffset() >= stop.getOffset()) continue;
            max = stop;
        }
        this.module.setRange(new AddressRangeImpl(min, max));
    }

    public SBModule getModule() {
        return this.module.getModule();
    }
}

