/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import agent.lldb.model.iface1.LldbModelTargetConfigurable;
import agent.lldb.model.iface2.LldbModelTargetAvailable;
import agent.lldb.model.iface2.LldbModelTargetAvailableContainer;
import agent.lldb.model.iface2.LldbModelTargetRoot;
import agent.lldb.model.impl.LldbModelTargetAvailableImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

@TargetObjectSchemaInfo(name="AvailableContainer", elements={@TargetElementType(type=LldbModelTargetAvailableImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ALWAYS, attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetAvailableContainerImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetAvailableContainer,
LldbModelTargetConfigurable {
    protected final Map<String, LldbModelTargetAvailable> attachablesById = new WeakValueHashMap();

    public LldbModelTargetAvailableContainerImpl(LldbModelTargetRoot root) {
        super(root.getModel(), (TargetObject)root, "Available", "AvailableContainer");
        this.changeAttributes(List.of(), Map.of("_base", 16), "Initialized");
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.getManager().listAvailableProcesses().thenAccept(list -> {
            List available;
            LldbModelTargetAvailableContainerImpl lldbModelTargetAvailableContainerImpl = this;
            synchronized (lldbModelTargetAvailableContainerImpl) {
                available = list.stream().map(this::getTargetAttachableEx).collect(Collectors.toList());
            }
            this.setElements(available, Map.of(), "Refreshed");
        });
    }

    public synchronized LldbModelTargetAvailable getTargetAttachableEx(Pair<String, String> pair) {
        return this.attachablesById.computeIfAbsent((String)pair.getLeft(), i -> new LldbModelTargetAvailableImpl(this, (String)pair.getLeft(), (String)pair.getRight()));
    }

    @Override
    public synchronized LldbModelTargetAvailable getTargetAttachable(String pid) {
        return this.attachablesById.computeIfAbsent(pid, i -> new LldbModelTargetAvailableImpl(this, pid));
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (LldbModelTargetAvailable child : this.attachablesById.values()) {
                        child.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }
}

