/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBProcess;
import SWIG.SBThread;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.LldbEventsListener;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;

public class LldbDetachCommand
extends AbstractLldbCommand<Void> {
    private final SBProcess process;

    public LldbDetachCommand(LldbManagerImpl manager, SBProcess process) {
        super(manager);
        this.process = process;
    }

    @Override
    public Void complete(LldbPendingCommand<?> pending) {
        String pid = DebugClient.getId(this.process);
        int i = 0;
        while ((long)i < this.process.GetNumThreads()) {
            SBThread t = this.process.GetThreadAtIndex((long)i);
            this.manager.removeThread(pid, DebugClient.getId(t));
            ++i;
        }
        ((LldbEventsListener)this.manager.getEventListeners().fire).processRemoved(pid, LldbCause.Causes.UNCLAIMED);
        return null;
    }

    @Override
    public void invoke() {
        DebugClient client = this.manager.getClient();
        client.detachCurrentProcess();
    }
}

