/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.lldb;

import agent.lldb.lldb.DebugValue;
import ghidra.comm.util.BitmaskSet;
import ghidra.comm.util.BitmaskUniverse;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public interface DebugRegisters {
    public int getNumberRegisters();

    public DebugRegisterDescription getDescription(int var1);

    default public Set<DebugRegisterDescription> getAllDescriptions() {
        LinkedHashSet<DebugRegisterDescription> result = new LinkedHashSet<DebugRegisterDescription>();
        int count = this.getNumberRegisters();
        for (int i = 0; i < count; ++i) {
            result.add(this.getDescription(i));
        }
        return result;
    }

    public int getIndexByName(String var1);

    default public int[] getIndicesByNames(String ... names) {
        int[] indices = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            indices[i] = this.getIndexByName(names[i]);
        }
        return indices;
    }

    public DebugValue getValue(int var1);

    public Map<Integer, DebugValue> getValues(DebugRegisterSource var1, Collection<Integer> var2);

    default public DebugValue getValueByName(String name) {
        int indexByName = this.getIndexByName(name);
        if (indexByName >= 0) {
            return this.getValue(indexByName);
        }
        return null;
    }

    public void setValue(int var1, DebugValue var2);

    public void setValues(DebugRegisterSource var1, Map<Integer, DebugValue> var2);

    default public void setValueByName(String name, DebugValue value) {
        this.setValue(this.getIndexByName(name), value);
    }

    public static class DebugRegisterDescription {
        public final String name;
        public final int index;
        public final DebugValue.DebugValueType type;
        public final Set<DebugRegisterFlags> flags;
        public final int subregMaster;
        public final int subregLengthBits;
        public final long subregMask;
        public final int subregShift;

        public DebugRegisterDescription(String name, int index, DebugValue.DebugValueType type, BitmaskSet<DebugRegisterFlags> flags, int subregMaster, int subregLengthBits, long subregMask, int subregShift) {
            this.name = name;
            this.index = index;
            this.type = type;
            this.flags = Collections.unmodifiableSet(flags);
            this.subregMaster = subregMaster;
            this.subregLengthBits = subregLengthBits;
            this.subregMask = subregMask;
            this.subregShift = subregShift;
        }

        public String toString() {
            return String.format("<%s: name='%s' index=%d type=%s flags=%s subregMaster=%d subregLengthBits=%d subregMask=%x subregShift=%d>", new Object[]{this.getClass().getSimpleName(), this.name, this.index, this.type, this.flags, this.subregMaster, this.subregLengthBits, this.subregMask, this.subregShift});
        }
    }

    public static enum DebugRegisterFlags implements BitmaskUniverse
    {
        SUB_REGISTER(1);

        private final int mask;

        private DebugRegisterFlags(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum DebugRegisterSource {
        DEBUG_REGSRC_DEBUGGEE,
        DEBUG_REGSRC_EXPLICIT,
        DEBUG_REGSRC_FRAME;

    }
}

