/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.spatial;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.layout.event.LayoutStateChange;
import org.jungrapht.visualization.layout.event.LayoutVertexPositionChange;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.util.RadiusVertexAccessor;
import org.jungrapht.visualization.spatial.AbstractSpatial;
import org.jungrapht.visualization.spatial.rtree.TreeNode;
import org.jungrapht.visualization.util.RadiusGraphElementAccessor;

public interface Spatial<T, NT>
extends LayoutStateChange.Listener,
LayoutVertexPositionChange.Listener<NT> {
    public void setActive(boolean var1);

    public boolean isActive();

    public List<Shape> getGrid();

    public Collection<Shape> getPickShapes();

    public void clear();

    public void recalculate();

    public Rectangle2D getLayoutArea();

    public void setBounds(Rectangle2D var1);

    default public Rectangle2D getUnion(Rectangle2D rect, Point2D p) {
        rect.add(p);
        return rect;
    }

    default public Rectangle2D getUnion(Rectangle2D rect, double x, double y) {
        rect.add(x, y);
        return rect;
    }

    public void update(T var1, Point var2);

    public Set<? extends TreeNode> getContainingLeafs(Point2D var1);

    public Set<? extends TreeNode> getContainingLeafs(double var1, double var3);

    public TreeNode getContainingLeaf(Object var1);

    public Set<T> getVisibleElements(Shape var1);

    public T getClosestElement(Point2D var1);

    public T getClosestElement(double var1, double var3);

    public LayoutModel getLayoutModel();

    public static abstract class NoOp<T, NT>
    extends AbstractSpatial<T, NT> {
        private TreeNode treeVertex;

        public NoOp(LayoutModel<NT> layoutModel) {
            super(layoutModel);
            this.treeVertex = new DegenerateTreeVertex<NT>(layoutModel);
        }

        @Override
        public List<Shape> getGrid() {
            return Collections.singletonList(this.getLayoutArea());
        }

        @Override
        public void clear() {
        }

        @Override
        public void recalculate() {
        }

        @Override
        public Rectangle2D getLayoutArea() {
            return new Rectangle2D.Double(0.0, 0.0, this.layoutModel.getWidth(), this.layoutModel.getHeight());
        }

        @Override
        public void setBounds(Rectangle2D bounds) {
        }

        @Override
        public void update(T element, Point location) {
        }

        @Override
        public Set<? extends TreeNode> getContainingLeafs(Point2D p) {
            return Collections.singleton(this.treeVertex);
        }

        @Override
        public Set<? extends TreeNode> getContainingLeafs(double x, double y) {
            return Collections.singleton(this.treeVertex);
        }

        @Override
        public TreeNode getContainingLeaf(Object element) {
            return this.treeVertex;
        }

        public void layoutVertexPositionChanged(LayoutVertexPositionChange.Event<NT> evt) {
        }

        public void layoutVertexPositionChanged(LayoutVertexPositionChange.GraphEvent<NT> evt) {
        }

        public static class Edge<E, V>
        extends NoOp<E, V> {
            private VisualizationModel<V, E> visualizationModel;
            RadiusGraphElementAccessor<V, E> accessor;

            public Edge(VisualizationModel<V, E> visualizationModel) {
                super(visualizationModel.getLayoutModel());
                this.visualizationModel = visualizationModel;
                this.accessor = new RadiusGraphElementAccessor();
            }

            @Override
            public Set<E> getVisibleElements(Shape shape) {
                return this.visualizationModel.getGraph().edgeSet();
            }

            @Override
            public void setActive(boolean active) {
            }

            @Override
            public E getClosestElement(Point2D p) {
                return this.getClosestElement(p.getX(), p.getY());
            }

            @Override
            public E getClosestElement(double x, double y) {
                return this.accessor.getEdge(this.layoutModel, x, y);
            }
        }

        public static class Vertex<V>
        extends NoOp<V, V> {
            RadiusVertexAccessor<V> accessor = new RadiusVertexAccessor();

            public Vertex(LayoutModel<V> layoutModel) {
                super(layoutModel);
            }

            @Override
            public Set<V> getVisibleElements(Shape shape) {
                return this.layoutModel.getGraph().vertexSet();
            }

            @Override
            public void setActive(boolean active) {
            }

            @Override
            public V getClosestElement(Point2D p) {
                return this.getClosestElement(p.getX(), p.getY());
            }

            @Override
            public V getClosestElement(double x, double y) {
                return null;
            }
        }

        public static class DegenerateTreeVertex<V>
        implements TreeNode {
            LayoutModel<V> layoutModel;

            public DegenerateTreeVertex(LayoutModel<V> layoutModel) {
                this.layoutModel = layoutModel;
            }

            @Override
            public Rectangle2D getBounds() {
                return new Rectangle2D.Double(0.0, 0.0, this.layoutModel.getWidth(), this.layoutModel.getHeight());
            }

            public List<? extends TreeNode> getChildren() {
                return Collections.emptyList();
            }
        }
    }
}

