/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.Modifiers;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslatingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    private static final Logger log = LoggerFactory.getLogger(TranslatingGraphMousePlugin.class);
    protected int translatingMask;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public TranslatingGraphMousePlugin() {
        this(TranslatingGraphMousePlugin.builder());
    }

    public TranslatingGraphMousePlugin(Builder<V, E, ?, ?> builder) {
        this.translatingMask = builder.translatingMask;
        log.trace("setModifiers({})", (Object)this.translatingMask);
        this.cursor = Cursor.getPredefinedCursor(13);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        log.trace("mousePressed in {}", (Object)this.getClass().getName());
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = e.getModifiersEx() == this.translatingMask;
        this.down = e.getPoint();
        if (accepted) {
            vv.setCursor(this.cursor);
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        log.trace("mouseReleased in {}", (Object)this.getClass().getName());
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        this.down = null;
        vv.setCursor(Cursor.getPredefinedCursor(0));
        if (e.getModifiersEx() == this.translatingMask) {
            e.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean accepted;
        if (this.down == null) {
            return;
        }
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean bl = accepted = e.getModifiersEx() == this.translatingMask;
        if (accepted) {
            MutableTransformer modelTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
            vv.setCursor(this.cursor);
            try {
                Point2D q = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(this.down);
                Point2D p = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(e.getPoint());
                float dx = (float)(p.getX() - q.getX());
                float dy = (float)(p.getY() - q.getY());
                modelTransformer.translate(dx, dy);
                this.down.x = e.getX();
                this.down.y = e.getY();
            }
            catch (RuntimeException ex) {
                log.error("down = {}, e = {}", (Object)this.down, (Object)e);
                throw ex;
            }
            e.consume();
            vv.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "\n translatingMask :" + Modifiers.maskStrings.get(this.translatingMask);
    }

    public static class Builder<V, E, T extends TranslatingGraphMousePlugin<V, E>, B extends Builder<V, E, T, B>> {
        protected int translatingMask = Modifiers.masks.get(System.getProperty("jungrapht.translatingMask", "MB1"));

        protected Builder() {
        }

        public B self() {
            return (B)this;
        }

        public B translatingMask(int rotatingMask) {
            this.translatingMask = this.translatingMask;
            return this.self();
        }

        public T build() {
            return (T)new TranslatingGraphMousePlugin(this);
        }
    }
}

