/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.decorators.EdgeShape;
import org.jungrapht.visualization.decorators.ExpandXY;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;

public class SelectedEdgePaintable<V, E>
implements VisualizationServer.Paintable {
    private final VisualizationServer<V, E> visualizationServer;
    private Function<E, Paint> selectionPaintFunction;
    private float selectionStrokeMultiplier;
    private BasicStroke selectionStroke;
    protected Function<VisualizationServer<V, E>, Collection<E>> selectedEdgeFunction;
    private boolean useTransform = true;
    private double minScale;

    public static <V, E> Builder<V, E, ?> builder(VisualizationServer<V, E> visualizationServer) {
        return new Builder(visualizationServer);
    }

    private SelectedEdgePaintable(Builder<V, E, ?> builder) {
        this(builder.visualizationServer, builder.selectionPaintFunction, builder.selectionStrokeMultiplier, builder.selectionStroke, builder.minScale, builder.selectedEdgeFunction);
    }

    private SelectedEdgePaintable(VisualizationServer<V, E> visualizationServer, Function<E, Paint> selectionPaintFunction, float selectionStrokeMultiplier, BasicStroke selectionStroke, double minScale, Function<VisualizationServer<V, E>, Collection<E>> selectedEdgeFunction) {
        this.visualizationServer = visualizationServer;
        this.selectionPaintFunction = selectionPaintFunction;
        this.selectionStrokeMultiplier = selectionStrokeMultiplier;
        this.selectionStroke = selectionStroke;
        this.minScale = minScale;
        this.selectedEdgeFunction = selectedEdgeFunction != null ? selectedEdgeFunction : vs -> this.getSelectedEdges((VisualizationServer<V, E>)vs);
    }

    protected Collection<E> getSelectedEdges(VisualizationServer<V, E> visualizationServer) {
        LayoutModel layoutModel = visualizationServer.getVisualizationModel().getLayoutModel();
        RenderContext renderContext = visualizationServer.getRenderContext();
        return visualizationServer.getSelectedEdges().stream().filter(e -> {
            Object u = layoutModel.getGraph().getEdgeSource(e);
            Object v = layoutModel.getGraph().getEdgeTarget(e);
            Predicate vertexIncludePredicate = renderContext.getVertexIncludePredicate();
            Predicate edgeIncludePredicate = renderContext.getEdgeIncludePredicate();
            return edgeIncludePredicate.test(e) && vertexIncludePredicate.test(u) && vertexIncludePredicate.test(v);
        }).collect(Collectors.toList());
    }

    @Override
    public void paint(Graphics g) {
        this.getSelectedEdges(this.visualizationServer).stream().forEach(edge -> this.paintEdgeHighlight(this.visualizationServer.getRenderContext(), this.visualizationServer.getVisualizationModel().getLayoutModel(), edge));
    }

    protected void paintEdgeHighlight(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        Graphics2D g2d = renderContext.getGraphicsContext().getDelegate();
        Stroke savedStroke = this.visualizationServer.getRenderContext().edgeStrokeFunction().apply(e);
        if (savedStroke instanceof BasicStroke) {
            BasicStroke savedBasicStroke = (BasicStroke)savedStroke;
            float viewScale = (float)renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW).getScale();
            BasicStroke stroke = new BasicStroke(savedBasicStroke.getLineWidth() * this.selectionStrokeMultiplier / viewScale, this.selectionStroke.getEndCap(), this.selectionStroke.getLineJoin(), this.selectionStroke.getMiterLimit(), this.selectionStroke.getDashArray(), this.selectionStroke.getDashPhase());
            g2d.setStroke(stroke);
        }
        int[] coords = new int[4];
        boolean[] loop = new boolean[1];
        Shape edgeShape = this.prepareFinalEdgeShape(renderContext, layoutModel, e, coords, loop);
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Paint oldPaint = g.getPaint();
        g.setPaint(this.selectionPaintFunction.apply(e));
        g.draw(edgeShape);
        g.setPaint(oldPaint);
        g2d.setStroke(savedStroke);
    }

    protected Shape prepareFinalEdgeShape(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e, int[] coords, boolean[] loop) {
        Object source = layoutModel.getGraph().getEdgeSource(e);
        Object target = layoutModel.getGraph().getEdgeTarget(e);
        Point sourcePoint = (Point)layoutModel.apply(source);
        Point targetPoint = (Point)layoutModel.apply(target);
        Point2D sourcePoint2D = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(sourcePoint.x, sourcePoint.y));
        Point2D targetPoint2D = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(targetPoint.x, targetPoint.y));
        float sourcePoint2DX = (float)sourcePoint2D.getX();
        float sourcePoint2DY = (float)sourcePoint2D.getY();
        float targetPoint2DX = (float)targetPoint2D.getX();
        float targetPoint2DY = (float)targetPoint2D.getY();
        coords[0] = (int)sourcePoint2DX;
        coords[1] = (int)sourcePoint2DY;
        coords[2] = (int)targetPoint2DX;
        coords[3] = (int)targetPoint2DY;
        boolean isLoop = loop[0] = source.equals(target);
        Shape targetShape = renderContext.getVertexShapeFunction().apply(target);
        Shape edgeShape = this.getEdgeShape(renderContext.getEdgeShapeFunction(), e, layoutModel.getGraph());
        AffineTransform xform = AffineTransform.getTranslateInstance(sourcePoint2DX, sourcePoint2DY);
        if (isLoop) {
            Rectangle2D targetShapeBounds2D = targetShape.getBounds2D();
            xform.scale(targetShapeBounds2D.getWidth(), targetShapeBounds2D.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
        } else {
            float dx = targetPoint2DX - sourcePoint2DX;
            float dy = targetPoint2DY - sourcePoint2DY;
            float thetaRadians = (float)Math.atan2(dy, dx);
            xform.rotate(thetaRadians);
            double dist = Math.sqrt(dx * dx + dy * dy);
            if (edgeShape instanceof ExpandXY) {
                MutableTransformer layoutTransformer = renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
                double scaleX = layoutTransformer.getScaleX();
                double scaleY = layoutTransformer.getScaleY();
                AffineTransform singleAxisScalingTransform = AffineTransform.getScaleInstance(1.0, scaleX / scaleY);
                edgeShape = singleAxisScalingTransform.createTransformedShape(edgeShape);
                xform.scale(dist, dist);
            } else {
                xform.scale(dist, 1.0);
            }
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        return edgeShape;
    }

    protected Shape getEdgeShape(BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction, E edge, Graph<V, E> graph) {
        if (edgeShapeFunction instanceof EdgeShape.ArticulatedLine) {
            return edgeShapeFunction.apply(graph, edge);
        }
        return EdgeShape.line().apply(graph, edge);
    }

    @Override
    public boolean useTransform() {
        return this.useTransform;
    }

    static {
        PropertyLoader.load();
    }

    public static class Builder<V, E, B extends Builder<V, E, B>> {
        private final VisualizationServer<V, E> visualizationServer;
        private Function<E, Paint> selectionPaintFunction = e -> Color.red;
        private float selectionStrokeMultiplier = 2.0f;
        private BasicStroke selectionStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{20.0f, 5.0f, 10.0f, 5.0f}, 0.0f);
        private Function<VisualizationServer<V, E>, Collection<E>> selectedEdgeFunction;
        private double minScale = 0.2;

        protected B self() {
            return (B)this;
        }

        public B selectionPaintFunction(Function<E, Paint> selectionPaintFunction) {
            this.selectionPaintFunction = selectionPaintFunction;
            return this.self();
        }

        public B selectionStrokeMultiplier(float selectionStrokeMultiplier) {
            this.selectionStrokeMultiplier = selectionStrokeMultiplier;
            return this.self();
        }

        public B selectionStroke(BasicStroke selectionStroke) {
            this.selectionStroke = selectionStroke;
            return this.self();
        }

        public B selectedEdgeFunction(Function<VisualizationServer<V, E>, Collection<E>> selectedEdgeFunction) {
            this.selectedEdgeFunction = selectedEdgeFunction;
            return this.self();
        }

        public B minScale(double minScale) {
            this.minScale = minScale;
            return this.self();
        }

        public SelectedEdgePaintable<V, E> build() {
            return new SelectedEdgePaintable(this);
        }

        private Builder(VisualizationServer<V, E> visualizationServer) {
            this.visualizationServer = visualizationServer;
        }
    }
}

