/*
 * Decompiled with CFR 0.152.
 */
package generic.jar;

import generic.jar.JarEntryFilter;
import generic.jar.JarEntryNode;
import generic.jar.JarEntryRootNode;
import generic.jar.Resource;
import generic.jar.ResourceFile;
import generic.jar.ResourceFileFilter;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import utilities.util.FileUtilities;
import utility.application.ApplicationSettings;

public class JarResource
implements Resource {
    private final JarEntryRootNode root;
    private final JarEntryNode node;
    private final String name;
    private final String path;

    public JarResource(File jarFile, JarEntryFilter filter) throws IOException {
        this.root = new JarEntryRootNode(jarFile, filter);
        this.node = this.root;
        this.name = this.root.getName();
        this.path = this.root.getPath();
    }

    public JarResource(JarResource parent, String path) {
        String myPath;
        JarEntryNode myNode;
        String myName;
        this.root = parent.root;
        path = path.replace('\\', '/');
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() == 0) {
            myName = parent.getName();
            myNode = parent.node;
            myPath = parent.path;
        } else {
            String[] split = path.split("/");
            myName = split[split.length - 1];
            myNode = parent.node == null ? null : parent.node.getNode(split);
            myPath = myNode != null ? myNode.getPath() : parent.path + "/" + path;
        }
        this.name = myName;
        this.node = myNode;
        this.path = myPath;
    }

    JarResource(JarEntryRootNode root, JarEntryNode node) {
        this.root = root;
        this.node = node;
        this.name = node.getName();
        this.path = node.getPath();
    }

    @Override
    public String getAbsolutePath() {
        Object jarPath;
        try {
            jarPath = this.root.toURL().toExternalForm();
        }
        catch (IOException e) {
            jarPath = "file:" + this.root.getFile().getAbsolutePath();
        }
        return "jar:" + (String)jarPath + "!/" + this.path;
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return new URL(this.getAbsolutePath());
    }

    @Override
    public URI toURI() {
        try {
            return new URI(this.getAbsolutePath());
        }
        catch (URISyntaxException e) {
            throw new AssertException("Unexpected exception getting URI: " + this);
        }
    }

    @Override
    public ResourceFile[] listFiles() {
        if (!this.isDirectory()) {
            return null;
        }
        List<JarEntryNode> children = this.node.getChildren();
        ResourceFile[] files = new ResourceFile[children.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new ResourceFile(new JarResource(this.root, children.get(i)));
        }
        return files;
    }

    @Override
    public ResourceFile[] listFiles(ResourceFileFilter filter) {
        if (!this.isDirectory()) {
            return null;
        }
        ArrayList<ResourceFile> fileList = new ArrayList<ResourceFile>();
        List<JarEntryNode> children = this.node.getChildren();
        for (JarEntryNode jarEntryNode : children) {
            ResourceFile file = new ResourceFile(new JarResource(this.root, jarEntryNode));
            if (!filter.accept(file)) continue;
            fileList.add(file);
        }
        return fileList.toArray(new ResourceFile[fileList.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDirectory() {
        return this.node == null ? false : this.node.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.node == null ? false : this.node.isFile();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.node == null || this.isDirectory()) {
            throw new FileNotFoundException(this.path + " does not exist or is a directory");
        }
        return this.node.getInputStream();
    }

    @Override
    public Resource getParent() {
        if (this.node != null) {
            if (this.node == this.root) {
                return null;
            }
            return new JarResource(this.root, this.node.getParent());
        }
        JarResource rootResource = new JarResource(this.root, this.root);
        String parentPath = this.getParentPath();
        if (parentPath == null) {
            return rootResource;
        }
        return new JarResource(rootResource, parentPath);
    }

    private String getParentPath() {
        String[] split = this.path.split("/");
        if (split.length == 1) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(split[0]);
        for (int i = 1; i < split.length; ++i) {
            buf.append("/");
            buf.append(split[i]);
        }
        return buf.toString();
    }

    @Override
    public long lastModified() {
        if (this.node != null) {
            return this.node.lastModified();
        }
        return 0L;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public boolean exists() {
        return this.node != null;
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        throw new FileNotFoundException("Cannot write to a file inside of a jar file!");
    }

    @Override
    public Resource getResource(String childPath) {
        if (childPath == null || childPath.length() == 0) {
            return this;
        }
        return new JarResource(this, childPath);
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public File getResourceAsFile(ResourceFile resourceFile) {
        File fileCopy;
        File userCopyDir = this.getFileCacheDirectory();
        if (!userCopyDir.exists()) {
            FileUtilities.mkdirs(userCopyDir);
        }
        if (!(fileCopy = new File(userCopyDir, this.name)).exists()) {
            try {
                FileUtilities.copyFile(resourceFile, fileCopy, false, null);
                fileCopy.setExecutable(true);
            }
            catch (IOException e) {
                Msg.error(this, "Resource file copy failed:  " + resourceFile, e);
            }
        }
        return fileCopy;
    }

    private File getFileCacheDirectory() {
        File settingsDir = ApplicationSettings.getUserApplicationSettingsDirectory();
        return new File(settingsDir, "jar.resource.copied.files");
    }

    @Override
    public long length() {
        return this.node.length();
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.getAbsolutePath();
    }

    @Override
    public Resource getCanonicalResource() {
        return this;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        JarResource other = (JarResource)obj;
        return this.root == other.root && this.name.equals(other.name) && this.path.equals(other.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    @Override
    public File getFileSystemRoot() {
        return this.root.getFile();
    }
}

