/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.java;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.java.JavaClassConstants;
import ghidra.file.formats.java.JavaClassDecompilerFileSystem;
import ghidra.file.jad.JadProcessWrapper;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import utilities.util.ArrayUtilities;

public class JavaClassDecompilerFileSystemFactory
implements GFileSystemFactoryByteProvider<JavaClassDecompilerFileSystem>,
GFileSystemProbeBytesOnly {
    public int getBytesRequired() {
        return JavaClassConstants.MAGIC_BYTES.length;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return JadProcessWrapper.isJadPresent() && ArrayUtilities.arrayRangesEquals((byte[])startBytes, (int)0, (byte[])JavaClassConstants.MAGIC_BYTES, (int)0, (int)JavaClassConstants.MAGIC_BYTES.length) && "class".equalsIgnoreCase(FilenameUtils.getExtension((String)containerFSRL.getName()));
    }

    public JavaClassDecompilerFileSystem create(FSRLRoot targetFSRL, ByteProvider provider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        JavaClassDecompilerFileSystem fs = new JavaClassDecompilerFileSystem(targetFSRL, provider, fsService, monitor);
        return fs;
    }
}

