/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dmg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.ios.dmg.DmgHeader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DmgHeaderV2
extends DmgHeader {
    private byte[] signature;
    private int version;
    private int ivSize;
    private int unknown0;
    private int unknown1;
    private int unknown2;
    private int unknown3;
    private int unknown4;
    private byte[] uuid;
    private int blockSize;
    private long dataSize;
    private long dataOffset;

    public DmgHeaderV2(BinaryReader reader) throws IOException {
        if (reader.isLittleEndian()) {
            throw new IOException("binary reader must be BIG endian");
        }
        this.signature = reader.readNextByteArray(8);
        this.version = reader.readNextInt();
        this.ivSize = reader.readNextInt();
        this.unknown0 = reader.readNextInt();
        this.unknown1 = reader.readNextInt();
        this.unknown2 = reader.readNextInt();
        this.unknown3 = reader.readNextInt();
        this.unknown4 = reader.readNextInt();
        this.uuid = reader.readNextByteArray(16);
        this.blockSize = reader.readNextInt();
        this.dataSize = reader.readNextLong();
        this.dataOffset = reader.readNextLong();
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public int getIvSize() {
        return this.ivSize;
    }

    public int getUnknown0() {
        return this.unknown0;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public int getUnknown3() {
        return this.unknown3;
    }

    public int getUnknown4() {
        return this.unknown4;
    }

    public byte[] getUUID() {
        return this.uuid;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public long getDataOffset() {
        return this.dataOffset;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = (StructureDataType)StructConverterUtil.toDataType((Object)this);
        DataTypeComponentImpl component0 = struct.getComponent(0);
        struct.replace(0, (DataType)new StringDataType(), component0.getLength());
        return struct;
    }
}

