/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4XattrIbodyHeader
implements StructConverter {
    static final int SIZEOF = 4;
    private int h_magic;

    public Ext4XattrIbodyHeader(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4XattrIbodyHeader(BinaryReader reader) throws IOException {
        this.h_magic = reader.readNextInt();
    }

    public int getH_magic() {
        return this.h_magic;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_xattr_ibody_header", 0);
        structure.add(DWORD, "h_magic", null);
        return structure;
    }

    public boolean isValid() {
        return this.h_magic == -368967680;
    }
}

