/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.vdex.UnsupportedVdexVersionException;
import ghidra.file.formats.android.vdex.VdexConstants;
import ghidra.file.formats.android.vdex.VdexHeader;
import ghidra.file.formats.android.vdex.VdexHeader_10;
import ghidra.file.formats.android.vdex.VdexHeader_11;
import ghidra.file.formats.android.vdex.VdexHeader_Oreo;
import ghidra.file.formats.android.vdex.VdexHeader_Pie;
import ghidra.file.formats.android.vdex.android12.VdexHeader_12;
import java.io.IOException;

public final class VdexFactory {
    public static VdexHeader getVdexHeader(BinaryReader reader) throws IOException, UnsupportedVdexVersionException {
        String magic = reader.readAsciiString(0L, "vdex".length());
        String version = reader.readAsciiString(4L, 4);
        if (magic.equals("vdex") && VdexConstants.isSupportedVersion(version)) {
            if (version.equals("006") || version.equals("010")) {
                return new VdexHeader_Oreo(reader);
            }
            if (version.equals("019")) {
                return new VdexHeader_Pie(reader);
            }
            if (version.equals("021")) {
                return new VdexHeader_10(reader);
            }
            if (version.equals("021")) {
                return new VdexHeader_11(reader);
            }
            if (version.equals("027")) {
                return new VdexHeader_12(reader);
            }
        }
        throw new UnsupportedVdexVersionException(magic, version);
    }
}

