/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.tlt;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable;
import ghidra.file.formats.android.oat.tlt.TypeLookupTableEntry;
import ghidra.file.formats.android.oat.tlt.TypeLookupTableEntry_Android10;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TypeLookupTable_Android10
extends TypeLookupTable {
    private int dex_file_begin_;
    private int mask_bits_;
    private int entries_;
    private int owns_entries_;
    protected List<TypeLookupTableEntry> entryList = new ArrayList<TypeLookupTableEntry>();

    public TypeLookupTable_Android10(BinaryReader reader) throws IOException {
        TypeLookupTableEntry_Android10 entry;
        this.dex_file_begin_ = reader.readNextInt();
        this.mask_bits_ = reader.readNextInt();
        this.entries_ = reader.readNextInt();
        this.owns_entries_ = reader.readNextInt();
        do {
            entry = new TypeLookupTableEntry_Android10(reader);
            this.entryList.add(entry);
        } while (!entry.isEmpty());
    }

    public int getDexFileBegin() {
        return this.dex_file_begin_;
    }

    public int getMaskBits() {
        return this.mask_bits_;
    }

    public int getEntries() {
        return this.entries_;
    }

    public boolean isOwnsEntries() {
        return this.owns_entries_ == 0;
    }

    public List<TypeLookupTableEntry> getEntryList() {
        return this.entryList;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(TypeLookupTable_Android10.class.getSimpleName() + "_" + this.entryList.size(), 0);
        structure.add(DWORD, "dex_file_begin_", null);
        structure.add(DWORD, "mask_bits_", null);
        structure.add(DWORD, "entries_", null);
        structure.add(DWORD, "owns_entries_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

