/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.tlt;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.tlt.TypeLookupTableEntry;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TypeLookupTableEntry_Android10
extends TypeLookupTableEntry {
    public TypeLookupTableEntry_Android10(BinaryReader reader) throws IOException {
        this.str_offset_ = reader.readNextInt();
        this.data_ = reader.readNextInt();
    }

    public boolean isLast(int mask_bits) {
        return this.getNextPosDelta(mask_bits) == 0;
    }

    public int getNextPosDelta(int mask_bits) {
        return this.data_ & this.getMask(mask_bits);
    }

    public int getMask(int mask_bits) {
        return ~(-1 << mask_bits);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(TypeLookupTableEntry_Android10.class.getSimpleName(), 0);
        structure.add(DWORD, "str_offset_", null);
        structure.add(DWORD, "data_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

