/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.oatdexfile;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.dex.format.ClassDefItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.EncodedMethod;
import ghidra.file.formats.android.dex.format.MethodIDItem;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatUtilities;
import ghidra.file.formats.android.oat.oatclass.OatClass;
import ghidra.file.formats.android.oat.oatclass.OatClassFactory;
import ghidra.file.formats.android.oat.oatclass.OatClassType;
import ghidra.file.formats.android.oat.oatmethod.OatMethodOffsets;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeaderFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public final class OatDexFileUtilities {
    static void markupLookupTableData(Class<?> caller, Address address, DexHeader dexHeader, OatHeader oatHeader, Program program, TaskMonitor monitor, MessageLog log) {
        if (dexHeader == null) {
            log.appendMsg(caller.getSimpleName() + "- markupLookupTableData() - no dex header, skipping...");
            return;
        }
        monitor.setMessage("OAT - Processing Lookup Table Data...");
        monitor.setMaximum((long)dexHeader.getClassDefsIdsSize());
        monitor.setProgress(0L);
        Symbol oatDataSymbol = OatUtilities.getOatDataSymbol(program);
        DWordDataType dword = new DWordDataType();
        try {
            for (int i = 0; i < dexHeader.getClassDefsIdsSize(); ++i) {
                program.getListing().clearCodeUnits(address, address, false, monitor);
                program.getListing().createData(address, (DataType)dword);
                int value = program.getMemory().getInt(address);
                Address destinationAddress = oatDataSymbol.getAddress().add((long)value);
                program.getReferenceManager().addMemoryReference(address, destinationAddress, RefType.DATA, SourceType.ANALYSIS, 0);
                address = address.add((long)dword.getLength());
                ClassDefItem classDefItem = dexHeader.getClassDefs().get(i);
                String className = DexUtil.convertTypeIndexToString(dexHeader, classDefItem.getClassIndex());
                Namespace classNameSpace = DexUtil.createNameSpaceFromMangledClassName(program, className);
                MemoryByteProvider oatClassHeaderProvider = new MemoryByteProvider(program.getMemory(), destinationAddress);
                BinaryReader oatClassHeaderReader = new BinaryReader((ByteProvider)oatClassHeaderProvider, !program.getLanguage().isBigEndian());
                OatClass oatClassHeader = OatClassFactory.getOatClass(oatClassHeaderReader, classDefItem.getClassDataItem(), oatHeader.getVersion());
                OatDexFileUtilities.markupMethod(oatHeader, oatClassHeader, dexHeader, classDefItem, program, oatDataSymbol, classNameSpace, log, monitor);
                OatDexFileUtilities.markupClassHeaderData(program, oatDataSymbol, destinationAddress, oatHeader, oatClassHeader, log, monitor);
                monitor.setProgress((long)i);
            }
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
        }
    }

    static void markupMethod(OatHeader oatHeader, OatClass oatClassHeader, DexHeader dexHeader, ClassDefItem classDefItem, Program program, Symbol oatDataSymbol, Namespace classNameSpace, MessageLog log, TaskMonitor monitor) throws CancelledException, InvalidInputException {
        if (classDefItem.getClassDataOffset() == 0) {
            return;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        List<EncodedMethod> allMethods = OatUtilities.getAllMethods(classDefItem.getClassDataItem());
        if (oatClassHeader.getType() == OatClassType.kOatClassAllCompiled) {
            for (int j = 0; j < oatClassHeader.getMethodOffsets().size(); ++j) {
                monitor.checkCanceled();
                OatMethodOffsets methodOffset = oatClassHeader.getMethodOffsets().get(j);
                if (methodOffset.getCodeOffset() == 0) continue;
                Address toAddr = oatDataSymbol.getAddress().add((long)methodOffset.getCodeOffset());
                toAddr = OatUtilities.adjustForThumbAsNeeded(oatHeader, program, toAddr, log);
                EncodedMethod encodedMethod = allMethods.get(j);
                MethodIDItem methodID = dexHeader.getMethods().get(encodedMethod.getMethodIndex());
                String methodName = DexUtil.convertToString(dexHeader, methodID.getNameIndex());
                symbolTable.createLabel(toAddr, methodName, classNameSpace, SourceType.ANALYSIS);
            }
        } else if (oatClassHeader.getType() == OatClassType.kOatClassSomeCompiled) {
            int offset = 0;
            for (int j = 0; j < allMethods.size(); ++j) {
                OatMethodOffsets methodOffset;
                monitor.checkCanceled();
                if (!oatClassHeader.isMethodNative(j) || (methodOffset = oatClassHeader.getMethodOffsets().get(offset++)).getCodeOffset() == 0) continue;
                Address toAddr = oatDataSymbol.getAddress().add((long)methodOffset.getCodeOffset());
                toAddr = OatUtilities.adjustForThumbAsNeeded(oatHeader, program, toAddr, log);
                EncodedMethod encodedMethod = allMethods.get(j);
                MethodIDItem methodID = dexHeader.getMethods().get(encodedMethod.getMethodIndex());
                String methodName = DexUtil.convertToString(dexHeader, methodID.getNameIndex());
                symbolTable.createLabel(toAddr, methodName, classNameSpace, SourceType.ANALYSIS);
            }
        } else if (oatClassHeader.getType() != OatClassType.kOatClassNoneCompiled && oatClassHeader.getType() == OatClassType.kOatClassMax) {
            throw new RuntimeException("invalid state!!");
        }
    }

    static void markupClassHeaderData(Program program, Symbol oatDataSymbol, Address address, OatHeader oatHeader, OatClass oatClassHeader, MessageLog log, TaskMonitor monitor) throws Exception {
        SymbolTable symbolTable = program.getSymbolTable();
        ReferenceManager referenceManager = program.getReferenceManager();
        Listing listing = program.getListing();
        listing.clearCodeUnits(address, address, false, monitor);
        Data oatClassHeaderData = listing.createData(address, oatClassHeader.toDataType());
        for (int j = 0; j < oatClassHeaderData.getNumComponents(); ++j) {
            Data methodOffsetData;
            Scalar scalar;
            monitor.checkCanceled();
            Data component = oatClassHeaderData.getComponent(j);
            if (!component.getFieldName().startsWith("methods_pointer_") || (scalar = (methodOffsetData = component.getComponent(0)).getScalar(0)).getUnsignedValue() == 0L) continue;
            Address toAddr = oatDataSymbol.getAddress().add(scalar.getUnsignedValue());
            toAddr = OatUtilities.adjustForThumbAsNeeded(oatHeader, program, toAddr, log);
            referenceManager.addMemoryReference(component.getMinAddress(), toAddr, RefType.READ, SourceType.ANALYSIS, 0);
            symbolTable.addExternalEntryPoint(toAddr);
            Address quickHeaderAddress = toAddr.subtract((long)OatQuickMethodHeaderFactory.getOatQuickMethodHeaderSize(oatHeader.getVersion()));
            if (!listing.isUndefined(quickHeaderAddress, quickHeaderAddress)) continue;
            MemoryByteProvider oqmhProvider = new MemoryByteProvider(program.getMemory(), quickHeaderAddress);
            BinaryReader oqmhReader = new BinaryReader((ByteProvider)oqmhProvider, !program.getLanguage().isBigEndian());
            OatQuickMethodHeader quickHeader = OatQuickMethodHeaderFactory.getOatQuickMethodHeader(oqmhReader, oatHeader.getVersion());
            DataType dataType = quickHeader.toDataType();
            try {
                listing.createData(quickHeaderAddress, dataType);
                continue;
            }
            catch (CodeUnitInsertionException e) {
                log.appendMsg(e.getMessage());
            }
        }
    }

    static int getNextPowerOfTwo(int value) {
        int highestBit = Integer.highestOneBit(value);
        value = highestBit == value ? value : highestBit << 1;
        return Math.min(value, 0x100000);
    }

    static void markupOatClassOffsetsPointer(Class<?> caller, Address address, DexHeader dexHeader, OatHeader oatHeader, Program program, TaskMonitor monitor, MessageLog log) {
        if (dexHeader == null) {
            log.appendMsg(caller.getSimpleName() + " - markupOatClassOffsetsPointer() - no dex header, skipping...");
            return;
        }
        monitor.setMessage("Processing Oat Class Offset Pointers...");
        int size = dexHeader.getClassDefsIdsSize();
        size *= 2;
        size = OatDexFileUtilities.getNextPowerOfTwo(size);
        DWordDataType dword = new DWordDataType();
        ArrayDataType array = new ArrayDataType((DataType)dword, size, dword.getLength());
        try {
            program.getListing().createData(address, (DataType)array);
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
        }
    }
}

