/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.lz4;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;

@FileSystemInfo(type="lz4frame", description="LZ4 Frame Format", factory=GFileSystemBaseFactory.class)
public class LZ4FrameFileSystem
extends GFileSystemBase {
    public static final int LZ4F_MAGIC = 407708164;
    public static final byte[] LZ4F_MAGIC_BYTES = new byte[]{4, 34, 77, 24};
    public static final String NAME = "lz4f_decompressed";
    private GFile decompressedLZ4FFile = null;

    public LZ4FrameFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, (long)LZ4F_MAGIC_BYTES.length);
        return Arrays.equals(bytes, LZ4F_MAGIC_BYTES);
    }

    public void open(TaskMonitor monitor) throws IOException, CancelledException {
        try (ByteProvider payloadBP = this.getPayload(monitor, this.root.getFSRL().appendPath(NAME));){
            this.decompressedLZ4FFile = GFileImpl.fromFSRL((GFileSystem)this, (GFile)this.root, (FSRL)payloadBP.getFSRL(), (boolean)false, (long)payloadBP.length());
        }
    }

    private ByteProvider getPayload(TaskMonitor monitor, FSRL payloadFSRL) throws CancelledException, IOException {
        return this.fsService.getDerivedByteProviderPush(this.provider.getFSRL(), payloadFSRL, NAME, -1L, os -> {
            UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor, this.provider.length());
            upwtm.setMessage("Decompressing LZ4 Frame...");
            upwtm.setProgress(0L);
            try (FramedLZ4CompressorInputStream is = new FramedLZ4CompressorInputStream(this.provider.getInputStream(0L));){
                FSUtilities.streamCopy((InputStream)is, (OutputStream)os, (TaskMonitor)upwtm);
            }
        }, monitor);
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (file == this.decompressedLZ4FFile || file.equals(this.decompressedLZ4FFile)) {
            return this.getPayload(monitor, file.getFSRL());
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return (directory == null || directory.equals(this.root)) && this.decompressedLZ4FFile != null ? Arrays.asList(this.decompressedLZ4FFile) : Collections.emptyList();
    }
}

