/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.fbpk.FBPK_Partition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FBPK
implements StructConverter {
    private String magic;
    private int unknown1;
    private String version;
    private int partitionCount;
    private int size;
    private List<FBPK_Partition> partitions = new ArrayList<FBPK_Partition>();

    public FBPK(BinaryReader reader) throws IOException {
        this.magic = reader.readNextAsciiString("FBPK".length());
        this.unknown1 = reader.readNextInt();
        this.version = reader.readNextAsciiString(68);
        this.partitionCount = reader.readNextInt();
        this.size = reader.readNextInt();
        for (int i = 0; i < this.partitionCount; ++i) {
            FBPK_Partition partition = new FBPK_Partition(reader);
            this.partitions.add(partition);
            reader.setPointerIndex(partition.getOffsetToNextPartitionTable());
        }
    }

    public String getMagic() {
        return this.magic;
    }

    public String getVersion() {
        return this.version;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public int getSize() {
        return this.size;
    }

    public List<FBPK_Partition> getPartitions() {
        return this.partitions;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(FBPK.class.getSimpleName(), 0);
        struct.add(STRING, "FBPK".length(), "magic", null);
        struct.add(DWORD, "unknown1", null);
        struct.add(STRING, 68, "version", null);
        struct.add(DWORD, "count", null);
        struct.add(DWORD, "size", null);
        return struct;
    }
}

