/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.bootimg.BootImageHeader;
import ghidra.file.formats.android.bootimg.BootImageHeaderFactory;
import ghidra.file.formats.android.bootimg.BootImageUtil;
import ghidra.file.formats.android.bootimg.VendorBootImageHeader;
import ghidra.file.formats.android.bootimg.VendorBootImageHeaderFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class BootImageAnalyzer
extends FileFormatAnalyzer
implements AnalysisWorker {
    private MessageLog messageLog;

    public String getName() {
        return "Android Boot, Recovery, or Vendor Image Annotation";
    }

    public boolean getDefaultEnablement(Program program) {
        return false;
    }

    public String getDescription() {
        return "Annotates Android Boot, Recovery, or Vendor Image files.";
    }

    public boolean canAnalyze(Program program) {
        try {
            return BootImageUtil.isBootImage(program) || BootImageUtil.isVendorBootImage(program);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isPrototype() {
        return true;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        this.messageLog = log;
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        return manager.scheduleWorker((AnalysisWorker)this, null, false, monitor);
    }

    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        Address address = program.getMinAddress();
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), address);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
        if (BootImageUtil.isBootImage(program)) {
            Address end;
            Address start;
            BootImageHeader header = BootImageHeaderFactory.getBootImageHeader(reader);
            if (!"ANDROID!".equals(header.getMagic())) {
                return false;
            }
            DataType headerDataType = header.toDataType();
            Data headerData = this.createData(program, address, headerDataType);
            if (headerData == null) {
                this.messageLog.appendMsg("Unable to create header data.");
                return false;
            }
            this.createFragment(program, headerDataType.getName(), this.toAddr(program, 0L), this.toAddr(program, header.getPageSize()));
            if (header.getKernelSize() > 0) {
                start = this.toAddr(program, header.getKernelOffset());
                end = this.toAddr(program, header.getKernelOffset() + (long)header.getKernelSize());
                this.createFragment(program, "kernel", start, end);
            }
            if (header.getRamdiskSize() > 0) {
                start = this.toAddr(program, header.getRamdiskOffset());
                end = this.toAddr(program, header.getRamdiskOffset() + header.getRamdiskSize());
                this.createFragment(program, "ramdisk", start, end);
            }
            if (header.getSecondSize() > 0) {
                start = this.toAddr(program, header.getSecondOffset());
                end = this.toAddr(program, header.getSecondOffset() + (long)header.getSecondSize());
                this.createFragment(program, "second stage", start, end);
            }
            this.changeDataSettings(program, monitor);
        } else if (BootImageUtil.isVendorBootImage(program)) {
            Address end;
            Address start;
            VendorBootImageHeader header = VendorBootImageHeaderFactory.getVendorBootImageHeader(reader);
            if (!header.getMagic().equals("VNDRBOOT")) {
                return false;
            }
            DataType headerDataType = header.toDataType();
            Data headerData = this.createData(program, address, headerDataType);
            if (headerData == null) {
                this.messageLog.appendMsg("Unable to create header data.");
            }
            this.createFragment(program, headerDataType.getName(), this.toAddr(program, 0L), this.toAddr(program, headerData.getLength()));
            if (header.getVendorRamdiskSize() > 0) {
                start = this.toAddr(program, header.getVendorRamdiskOffset());
                end = this.toAddr(program, header.getVendorRamdiskOffset() + (long)header.getVendorRamdiskSize());
                this.createFragment(program, "ramdisk", start, end);
            }
            if (header.getDtbSize() > 0) {
                start = this.toAddr(program, header.getDtbOffset());
                end = this.toAddr(program, header.getDtbOffset() + (long)header.getDtbSize());
                this.createFragment(program, "dtb", start, end);
            }
        }
        this.removeEmptyFragments(program);
        return true;
    }

    public String getWorkerName() {
        return "BootImageAnalyzer";
    }
}

