/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.util.HelpLocation;

public class RemoveSecondaryHighlightAction
extends AbstractDecompilerAction {
    public static final String NAME = "Remove Secondary Highlight";

    public RemoveSecondaryHighlightAction() {
        super(NAME);
        this.setPopupMenuData(new MenuData(new String[]{"Secondary Highlight", "Remove Highlight"}, "Decompile"));
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionSecondaryHighlight"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        if (!context.hasRealFunction()) {
            return false;
        }
        ClangToken token = context.getTokenAtCursor();
        if (token == null) {
            return false;
        }
        DecompilerPanel panel = context.getDecompilerPanel();
        TokenHighlights highlightedTokens = panel.getSecondaryHighlightedTokens();
        return highlightedTokens.contains(token);
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ClangToken token = context.getTokenAtCursor();
        DecompilerPanel panel = context.getDecompilerPanel();
        panel.removeSecondaryHighlight(token);
    }
}

