/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.DecompileProcess;
import ghidra.framework.Application;
import ghidra.framework.OSFileNotFoundException;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.Msg;
import java.io.File;

public class DecompileProcessFactory {
    private static String exepath;
    private static final String EXECNAME = "decompile";
    private static final String WIN32_EXECNAME = "decompile.exe";
    private static boolean errorDisplayed;

    public static synchronized DecompileProcess get() {
        DecompileProcessFactory.getExePath();
        DecompileProcess currentProcess = new DecompileProcess(exepath);
        return currentProcess;
    }

    public static synchronized void release(DecompileProcess dp) {
        dp.dispose();
    }

    private static void getExePath() {
        block3: {
            if (exepath != null) {
                return;
            }
            String exeName = Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS ? WIN32_EXECNAME : EXECNAME;
            try {
                File file = Application.getOSFile((String)exeName);
                exepath = file.getAbsolutePath();
            }
            catch (OSFileNotFoundException e) {
                if (errorDisplayed) break block3;
                errorDisplayed = true;
                Msg.showError(DecompileProcessFactory.class, null, (String)"Decompiler missing", (Object)e.getMessage());
            }
        }
    }

    static {
        errorDisplayed = false;
    }
}

