/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.util;

import java.util.IntSummaryStatistics;
import org.jungrapht.visualization.layout.algorithms.util.DimensionConsumer;
import org.jungrapht.visualization.layout.algorithms.util.RectangleConsumer;
import org.jungrapht.visualization.layout.model.Dimension;
import org.jungrapht.visualization.layout.model.Rectangle;

public class DimensionSummaryStatistics
implements DimensionConsumer,
RectangleConsumer {
    private IntSummaryStatistics widths;
    private IntSummaryStatistics heights;

    public DimensionSummaryStatistics() {
        this.widths = new IntSummaryStatistics();
        this.heights = new IntSummaryStatistics();
    }

    public DimensionSummaryStatistics(int count, int min, int max, int sum) throws IllegalArgumentException {
        this.widths = new IntSummaryStatistics(count, min, max, sum);
        this.heights = new IntSummaryStatistics(count, min, max, sum);
    }

    @Override
    public void accept(Dimension dimension) {
        this.widths.accept(dimension.width);
        this.heights.accept(dimension.height);
    }

    @Override
    public void accept(Rectangle rectangle) {
        this.widths.accept((int)rectangle.width);
        this.heights.accept((int)rectangle.height);
    }

    public void combine(DimensionSummaryStatistics other) {
        this.widths.combine(other.widths);
        this.heights.combine(other.heights);
    }

    public final long getCount() {
        return this.widths.getCount();
    }

    public final Dimension getSum() {
        return Dimension.of((int)this.widths.getSum(), (int)this.heights.getSum());
    }

    public final Dimension getMin() {
        return Dimension.of(this.widths.getMin(), this.heights.getMin());
    }

    public final Dimension getMax() {
        return Dimension.of(this.widths.getMax(), this.heights.getMax());
    }

    public final Dimension getAverage() {
        return Dimension.of((int)this.widths.getAverage(), (int)this.heights.getAverage());
    }

    public String toString() {
        return "DimensionSummaryStatistics{widths=" + this.widths + ", heights=" + this.heights + "}";
    }
}

