/*
 * Decompiled with CFR 0.152.
 */
package db;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Bytes;
import db.DBRecord;
import db.Field;
import db.IndexField;
import db.LongField;
import db.SparseRecord;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;

public class Schema {
    private static final String NAME_SEPARATOR = ";";
    static final byte FIELD_EXTENSION_INDICATOR = -1;
    private static final byte SPARSE_FIELD_LIST_EXTENSION = 1;
    private int version;
    private Field keyType;
    private String keyName;
    private Field[] fields;
    private String[] fieldNames;
    private Set<Integer> sparseColumnSet;
    private boolean isVariableLength;
    private int fixedLength;
    private boolean forceUseVariableLengthKeyNodes;

    public Schema(int version, Field keyField, String keyName, Field[] fields, String[] fieldNames, int[] sparseColumns) {
        this.version = version;
        this.keyType = keyField;
        this.keyName = keyName;
        this.fields = fields;
        this.fieldNames = fieldNames;
        if (fields.length != fieldNames.length) {
            throw new IllegalArgumentException("fieldNames and fields lengths differ");
        }
        this.isVariableLength = false;
        this.fixedLength = 0;
        for (int colIndex = 0; colIndex < fields.length; ++colIndex) {
            Field field = fields[colIndex];
            if (field.isVariableLength()) {
                this.isVariableLength = true;
            }
            this.fixedLength += field.length();
            if (fieldNames[colIndex].indexOf(NAME_SEPARATOR) < 0) continue;
            throw new IllegalArgumentException("field names may not contain ';'");
        }
        try {
            this.initializeSparseColumnSet(ArrayUtils.toObject((int[])sparseColumns));
        }
        catch (Field.UnsupportedFieldException e) {
            throw new IllegalArgumentException(e);
        }
        if (this.isVariableLength) {
            this.fixedLength = 0;
        }
    }

    public Schema(int version, Field keyField, String keyName, Field[] fields, String[] fieldNames) {
        this(version, keyField, keyName, fields, fieldNames, null);
    }

    public Schema(int version, String keyName, Field[] fields, String[] fieldNames) {
        this(version, LongField.INSTANCE, keyName, fields, fieldNames, null);
    }

    public Schema(int version, String keyName, Field[] fields, String[] fieldNames, int[] sparseColumns) {
        this(version, LongField.INSTANCE, keyName, fields, fieldNames, sparseColumns);
    }

    public Schema(int version, Class<?> keyClass, String keyName, Class<?>[] fieldClasses, String[] fieldNames) {
        this(version, Schema.getField(keyClass), keyName, Schema.getFields(fieldClasses), fieldNames, null);
    }

    public Schema(int version, Class<?> keyClass, String keyName, Class<?>[] fieldClasses, String[] fieldNames, int[] sparseColumns) {
        this(version, Schema.getField(keyClass), keyName, Schema.getFields(fieldClasses), fieldNames, sparseColumns);
    }

    public Schema(int version, String keyName, Class<?>[] fieldClasses, String[] fieldNames) {
        this(version, LongField.INSTANCE, keyName, Schema.getFields(fieldClasses), fieldNames, null);
    }

    public Schema(int version, String keyName, Class<?>[] fieldClasses, String[] fieldNames, int[] sparseColumns) {
        this(version, LongField.INSTANCE, keyName, Schema.getFields(fieldClasses), fieldNames, sparseColumns);
    }

    Schema(int version, byte encodedKeyFieldType, byte[] encodedFieldTypes, String packedFieldNames) throws Field.UnsupportedFieldException {
        this.version = version;
        this.keyType = Field.getField(encodedKeyFieldType);
        this.parseNames(packedFieldNames);
        this.isVariableLength = false;
        this.fixedLength = 0;
        this.initializeFields(encodedFieldTypes);
        if (this.fieldNames.length != this.fields.length) {
            throw new IllegalArgumentException("fieldNames and column types differ in length");
        }
    }

    public boolean hasSparseColumns() {
        return this.sparseColumnSet != null;
    }

    public boolean isSparseColumn(int columnIndex) {
        return this.sparseColumnSet != null && this.sparseColumnSet.contains(columnIndex);
    }

    private void initializeFields(byte[] encodedFieldTypes) throws Field.UnsupportedFieldException {
        byte b;
        if (encodedFieldTypes.length == 0) {
            this.fields = new Field[0];
            return;
        }
        int index = 0;
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (index < encodedFieldTypes.length && (b = encodedFieldTypes[index++]) != -1) {
            Field f = Field.getField(b);
            fieldList.add(f);
            if (f.isVariableLength()) {
                this.isVariableLength = true;
            }
            this.fixedLength += f.length();
        }
        this.fields = fieldList.toArray(new Field[fieldList.size()]);
        while (index < encodedFieldTypes.length) {
            byte extensionType;
            if ((extensionType = encodedFieldTypes[index++]) == 1) {
                index += this.parseSparseColumnIndexes(encodedFieldTypes, index);
                continue;
            }
            throw new Field.UnsupportedFieldException("Unsupported field extension type: " + extensionType);
        }
        if (this.isVariableLength) {
            this.fixedLength = 0;
        }
    }

    private void initializeSparseColumnSet(Integer[] sparseColumns) throws Field.UnsupportedFieldException {
        if (sparseColumns == null || sparseColumns.length == 0) {
            return;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Integer[] integerArray = sparseColumns;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            if (i2 < 0 || i2 > 127 || i2 >= this.fields.length) {
                throw new Field.UnsupportedFieldException("Sparse column entry out of range: " + i2);
            }
            builder.add((Object)i2);
        }
        this.sparseColumnSet = builder.build();
        if (this.sparseColumnSet.size() != sparseColumns.length) {
            throw new Field.UnsupportedFieldException("Sparse column set contains duplicate entry");
        }
        this.isVariableLength = true;
    }

    private int parseSparseColumnIndexes(byte[] encodedFieldTypes, int index) throws Field.UnsupportedFieldException {
        try {
            int consumed = 0;
            ArrayList<Integer> columnIndexes = new ArrayList<Integer>();
            while (index < encodedFieldTypes.length && encodedFieldTypes[index] != -1) {
                columnIndexes.add(Integer.valueOf(encodedFieldTypes[index++]));
                ++consumed;
            }
            Integer[] sparseColumns = columnIndexes.toArray(new Integer[columnIndexes.size()]);
            this.initializeSparseColumnSet(sparseColumns);
            return consumed;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new Field.UnsupportedFieldException("Incomplete sparse column data");
        }
    }

    private static Field getField(Class<?> fieldClass) {
        if (!Field.class.isAssignableFrom(fieldClass) || fieldClass == Field.class || IndexField.class.isAssignableFrom(fieldClass)) {
            throw new IllegalArgumentException("Invalid Field class: " + fieldClass.getName());
        }
        try {
            return (Field)fieldClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to construct: " + fieldClass.getName(), e);
        }
    }

    private static Field[] getFields(Class<?>[] fieldClasses) {
        Field[] fields = new Field[fieldClasses.length];
        for (int i = 0; i < fieldClasses.length; ++i) {
            fields[i] = Schema.getField(fieldClasses[i]);
        }
        return fields;
    }

    boolean useLongKeyNodes() {
        return !this.forceUseVariableLengthKeyNodes && this.keyType instanceof LongField;
    }

    boolean useVariableKeyNodes() {
        return this.forceUseVariableLengthKeyNodes || this.keyType.isVariableLength();
    }

    boolean useFixedKeyNodes() {
        return !this.useVariableKeyNodes() && !this.useLongKeyNodes();
    }

    void forceUseOfVariableLengthKeyNodes() {
        this.forceUseVariableLengthKeyNodes = true;
    }

    public Field getKeyFieldType() {
        return this.keyType;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    private void parseNames(String packedNames) {
        ArrayList<String> nameList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(packedNames, NAME_SEPARATOR);
        while (st.hasMoreElements()) {
            nameList.add(st.nextToken());
        }
        this.keyName = (String)nameList.remove(0);
        this.fieldNames = new String[nameList.size()];
        nameList.toArray(this.fieldNames);
    }

    String getPackedFieldNames() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.keyName);
        buf.append(NAME_SEPARATOR);
        for (String fieldName : this.fieldNames) {
            buf.append(fieldName);
            buf.append(NAME_SEPARATOR);
        }
        return buf.toString();
    }

    byte getEncodedKeyFieldType() {
        return this.keyType.getFieldType();
    }

    byte[] getEncodedFieldTypes() {
        ArrayList<Byte> encodedDataList = new ArrayList<Byte>();
        for (Field field : this.fields) {
            encodedDataList.add(field.getFieldType());
        }
        if (this.sparseColumnSet != null) {
            encodedDataList.add((byte)-1);
            encodedDataList.add((byte)1);
            Iterator<Integer> iterator = this.sparseColumnSet.iterator();
            while (iterator.hasNext()) {
                int col = (Integer)iterator.next();
                encodedDataList.add((byte)col);
            }
        }
        return Bytes.toArray(encodedDataList);
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    public int getFixedLength() {
        return this.fixedLength;
    }

    public DBRecord createRecord(long key) {
        return this.createRecord(new LongField(key));
    }

    public DBRecord createRecord(Field key) {
        return this.hasSparseColumns() ? new SparseRecord(this, key) : new DBRecord(this, key);
    }

    Field getField(int colIndex) {
        try {
            return this.fields[colIndex].newField();
        }
        catch (Exception e) {
            throw new AssertException(e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Schema)) {
            return false;
        }
        Schema otherSchema = (Schema)obj;
        if (this.version != otherSchema.version || !this.keyType.getClass().equals(otherSchema.keyType.getClass()) || this.fields.length != otherSchema.fields.length) {
            return false;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getClass().equals(otherSchema.fields[i].getClass())) continue;
            return false;
        }
        return Objects.equals(this.sparseColumnSet, otherSchema.sparseColumnSet);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.keyName);
        buf.append("(key,");
        buf.append(this.keyType.getClass().getSimpleName());
        buf.append(")");
        for (int i = 0; i < this.fieldNames.length; ++i) {
            buf.append("\n");
            buf.append(this.fieldNames[i]);
            buf.append("(");
            buf.append(this.fields[i].getClass().getSimpleName());
            buf.append(")");
        }
        return buf.toString();
    }
}

