/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.async.AsyncUtils;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.SleighUseropLibrary;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncPcodeExecutor<T>
extends PcodeExecutor<CompletableFuture<T>> {
    public AsyncPcodeExecutor(SleighLanguage language, PcodeArithmetic<CompletableFuture<T>> arithmetic, PcodeExecutorStatePiece<CompletableFuture<T>, CompletableFuture<T>> state) {
        super(language, arithmetic, state);
    }

    public CompletableFuture<Void> stepOpAsync(PcodeOp op, PcodeFrame frame, SleighUseropLibrary<CompletableFuture<T>> library) {
        if (op.getOpcode() == 5) {
            return this.executeConditionalBranchAsync(op, frame);
        }
        this.stepOp(op, frame, library);
        return AsyncUtils.NIL;
    }

    public CompletableFuture<Void> stepAsync(PcodeFrame frame, SleighUseropLibrary<CompletableFuture<T>> library) {
        try {
            return this.stepOpAsync(frame.nextOp(), frame, library);
        }
        catch (PcodeExecutionException e) {
            e.frame = frame;
            return CompletableFuture.failedFuture(e);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new PcodeExecutionException("Exception during pcode execution", frame, (Throwable)e));
        }
    }

    public CompletableFuture<Void> executeConditionalBranchAsync(PcodeOp op, PcodeFrame frame) {
        Varnode condVar = op.getInput(1);
        CompletableFuture cond = (CompletableFuture)this.state.getVar(condVar);
        return cond.thenAccept(c -> {
            if (this.arithmetic.isTrue((Object)cond)) {
                this.executeBranch(op, frame);
            }
        });
    }

    public CompletableFuture<Void> executeAsync(PcodeProgram program, SleighUseropLibrary<CompletableFuture<T>> library) {
        return this.executeAsync(program.code, program.useropNames, library);
    }

    protected CompletableFuture<Void> executeAsyncLoop(PcodeFrame frame, SleighUseropLibrary<CompletableFuture<T>> library) {
        if (frame.isFinished()) {
            return AsyncUtils.NIL;
        }
        return this.stepAsync(frame, library).thenComposeAsync(__ -> this.executeAsyncLoop(frame, library));
    }

    public CompletableFuture<Void> executeAsync(List<PcodeOp> code, Map<Integer, String> useropNames, SleighUseropLibrary<CompletableFuture<T>> library) {
        PcodeFrame frame = new PcodeFrame((Language)this.language, code, useropNames);
        return this.executeAsyncLoop(frame, library);
    }
}

