/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.service.tracemgr.DebuggerTraceManagerServicePlugin;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.TriConsumer;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

@ServiceInfo(defaultProvider={DebuggerTraceManagerServicePlugin.class})
public interface DebuggerTraceManagerService {
    public Collection<Trace> getOpenTraces();

    public DebuggerCoordinates getCurrent();

    public Trace getCurrentTrace();

    public TraceProgramView getCurrentView();

    public TraceThread getCurrentThread();

    public TraceThread getCurrentThreadFor(Trace var1);

    public long getCurrentSnap();

    public int getCurrentFrame();

    public void openTrace(Trace var1);

    public Trace openTrace(DomainFile var1, int var2);

    public Collection<Trace> openTraces(Collection<DomainFile> var1);

    public CompletableFuture<Void> saveTrace(Trace var1);

    public void closeTrace(Trace var1);

    public void closeAllTraces();

    public void closeOtherTraces(Trace var1);

    public void closeDeadTraces();

    public void activate(DebuggerCoordinates var1);

    public void activateTrace(Trace var1);

    public void activateThread(TraceThread var1);

    public void activateSnap(long var1);

    public void activateTime(TraceSchedule var1);

    public void activateFrame(int var1);

    public void setAutoActivatePresent(boolean var1);

    public boolean isAutoActivatePresent();

    public void addAutoActivatePresentChangeListener(BooleanChangeAdapter var1);

    public void removeAutoActivatePresentChangeListener(BooleanChangeAdapter var1);

    public void setSynchronizeFocus(boolean var1);

    public boolean isSynchronizeFocus();

    public void addSynchronizeFocusChangeListener(BooleanChangeAdapter var1);

    public void removeSynchronizeFocusChangeListener(BooleanChangeAdapter var1);

    public void setSaveTracesByDefault(boolean var1);

    public boolean isSaveTracesByDefault();

    public void addSaveTracesByDefaultChangeListener(BooleanChangeAdapter var1);

    public void removeSaveTracesByDefaultChangeListener(BooleanChangeAdapter var1);

    public void setAutoCloseOnTerminate(boolean var1);

    public boolean isAutoCloseOnTerminate();

    public void addAutoCloseOnTerminateChangeListener(BooleanChangeAdapter var1);

    public void removeAutoCloseOnTerminateChangeListener(BooleanChangeAdapter var1);

    public DebuggerCoordinates resolveCoordinates(DebuggerCoordinates var1);

    public CompletableFuture<Long> materialize(DebuggerCoordinates var1);

    public static interface BooleanChangeAdapter
    extends TriConsumer<Boolean, Boolean, Void> {
        default public void accept(Boolean oldVal, Boolean newVal, Void cause) {
            this.changed(newVal);
        }

        public void changed(Boolean var1);
    }
}

