/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.workflow;

import ghidra.app.plugin.core.debug.service.workflow.AbstractMultiToolTraceListener;
import ghidra.app.plugin.core.debug.service.workflow.DebuggerWorkflowServicePlugin;
import ghidra.app.plugin.core.debug.service.workflow.MultiToolTraceListenerManager;
import ghidra.app.services.DebuggerBot;
import ghidra.app.services.DebuggerBotInfo;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.ProgramManager;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

@DebuggerBotInfo(description="Map sections to open programs", details="Monitors open traces and programs, attempting to map sections by \"best\" match.", help=@HelpInfo(anchor="map_sections"), enabledByDefault=false)
public class MapSectionsDebuggerBot
implements DebuggerBot {
    private DebuggerWorkflowServicePlugin plugin;
    private final MultiToolTraceListenerManager<ForMapNewSectionsTraceListener> listeners = new MultiToolTraceListenerManager<ForMapNewSectionsTraceListener>(x$0 -> new ForMapNewSectionsTraceListener((Trace)x$0));
    private final Set<Trace> traceQueue = new HashSet<Trace>();
    private final AsyncDebouncer<Void> debouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 500L);

    public MapSectionsDebuggerBot() {
        this.debouncer.addListener(this::queueSettled);
    }

    @Override
    public void enable(DebuggerWorkflowServicePlugin wp) {
        this.plugin = wp;
        this.listeners.enable(wp);
        for (PluginTool t : this.plugin.getProxyingPluginTools()) {
            DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)t.getService(DebuggerTraceManagerService.class);
            if (traceManager == null) continue;
            this.queueTraces(traceManager.getOpenTraces());
        }
    }

    @Override
    public void disable() {
        this.plugin = null;
        this.listeners.disable();
    }

    @Override
    public boolean isEnabled() {
        return this.plugin != null;
    }

    @Override
    public void traceOpened(PluginTool tool, Trace trace) {
        this.listeners.traceOpened(tool, trace);
        this.queueTrace(trace);
    }

    @Override
    public void traceClosed(PluginTool tool, Trace trace) {
        this.listeners.traceClosed(tool, trace);
    }

    @Override
    public void programOpened(PluginTool t, Program program) {
        DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)t.getService(DebuggerTraceManagerService.class);
        if (traceManager == null) {
            return;
        }
        this.queueTraces(traceManager.getOpenTraces());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueTrace(Trace trace) {
        Set<Trace> set = this.traceQueue;
        synchronized (set) {
            this.traceQueue.add(trace);
        }
        this.debouncer.contact(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueTraces(Collection<Trace> traces) {
        Set<Trace> set = this.traceQueue;
        synchronized (set) {
            this.traceQueue.addAll(traces);
        }
        this.debouncer.contact(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueSettled(Void __) {
        Set<Trace> traces;
        Set<Trace> set = this.traceQueue;
        synchronized (set) {
            traces = Set.copyOf(this.traceQueue);
            this.traceQueue.clear();
        }
        HashMap<Trace, Pair> toAnalyze = new HashMap<Trace, Pair>();
        for (Trace trace : traces) {
            for (PluginTool tool : this.plugin.getProxyingPluginTools()) {
                ProgramManager programManager;
                DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)tool.getService(DebuggerTraceManagerService.class);
                if (traceManager == null || (programManager = (ProgramManager)tool.getService(ProgramManager.class)) == null || !traceManager.getOpenTraces().contains(trace)) continue;
                Pair programs = toAnalyze.computeIfAbsent(trace, t -> Pair.of((Object)tool, new HashSet()));
                ((Set)programs.getRight()).addAll(List.of(programManager.getAllOpenPrograms()));
            }
        }
        for (Map.Entry entry : toAnalyze.entrySet()) {
            PluginTool tool = (PluginTool)((Pair)entry.getValue()).getLeft();
            Trace trace = (Trace)entry.getKey();
            Set programs = (Set)((Pair)entry.getValue()).getRight();
            this.analyzeTrace(tool, trace, programs);
        }
    }

    private void analyzeTrace(final PluginTool t, final Trace trace, final Set<Program> programs) {
        BackgroundCommand cmd = new BackgroundCommand("Auto-map sections", true, true, false){

            public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
                try {
                    DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)t.getService(DebuggerStaticMappingService.class);
                    Map<TraceModule, DebuggerStaticMappingService.SectionMapProposal> maps = mappingService.proposeSectionMaps(trace.getModuleManager().getAllModules(), programs);
                    Collection<DebuggerStaticMappingService.SectionMapEntry> entries = DebuggerStaticMappingService.SectionMapProposal.flatten(maps.values());
                    entries = DebuggerStaticMappingService.SectionMapProposal.removeOverlapping(entries);
                    mappingService.addSectionMappings(entries, monitor, false);
                    return true;
                }
                catch (CancelledException e) {
                    return false;
                }
            }
        };
        t.executeBackgroundCommand(cmd, (UndoableDomainObject)trace);
    }

    protected class ForMapNewSectionsTraceListener
    extends AbstractMultiToolTraceListener {
        public ForMapNewSectionsTraceListener(Trace trace) {
            super(trace);
            this.listenFor((TraceChangeType)Trace.TraceSectionChangeType.ADDED, this::sectionAdded);
        }

        private void sectionAdded(TraceAddressSpace space, TraceSection section) {
            MapSectionsDebuggerBot.this.queueTrace(this.trace);
        }
    }
}

