/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.utils;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.commons.lang3.exception.ExceptionUtils;

public enum BackgroundUtils {


    public static <T extends UndoableDomainObject> AsyncBackgroundCommand<T> async(PluginTool tool, T obj, String name, boolean hasProgress, boolean canCancel, boolean isModal, BiFunction<T, TaskMonitor, CompletableFuture<?>> futureProducer) {
        AsyncBackgroundCommand<T> cmd = new AsyncBackgroundCommand<T>(name, hasProgress, canCancel, isModal, futureProducer);
        tool.executeBackgroundCommand(cmd, obj);
        return cmd;
    }

    public static class PluginToolExecutorService
    extends AbstractExecutorService {
        private final PluginTool tool;
        private String name;
        private boolean canCancel;
        private boolean hasProgress;
        private boolean isModal;
        private final int delay;

        public PluginToolExecutorService(PluginTool tool, String name, boolean canCancel, boolean hasProgress, boolean isModal, int delay) {
            this.tool = tool;
            this.name = name;
            this.canCancel = canCancel;
            this.hasProgress = hasProgress;
            this.isModal = isModal;
            this.delay = delay;
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(final Runnable command) {
            Task task = new Task(this.name, this.canCancel, this.hasProgress, this.isModal){

                public void run(TaskMonitor monitor) throws CancelledException {
                    command.run();
                }
            };
            this.tool.execute(task, this.delay);
        }
    }

    public static class AsyncBackgroundCommand<T extends UndoableDomainObject>
    extends BackgroundCommand {
        private CompletableFuture<?> promise;
        private final CancelledListener cancelledListener = this::cancelled;
        private final BiFunction<T, TaskMonitor, CompletableFuture<?>> futureProducer;

        private AsyncBackgroundCommand(String name, boolean hasProgress, boolean canCancel, boolean isModal, BiFunction<T, TaskMonitor, CompletableFuture<?>> futureProducer) {
            super(name, hasProgress, canCancel, isModal);
            this.futureProducer = futureProducer;
        }

        private void cancelled() {
            this.promise.cancel(true);
        }

        public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
            this.promise = this.futureProducer.apply((UndoableDomainObject)obj, monitor);
            monitor.addCancelledListener(this.cancelledListener);
            try {
                this.promise.get();
                return true;
            }
            catch (InterruptedException e) {
                this.setStatusMsg("Interrupted");
                return false;
            }
            catch (ExecutionException e) {
                this.setStatusMsg(e.getMessage());
                if (!(e.getCause() instanceof CancellationException)) {
                    return (Boolean)ExceptionUtils.rethrow((Throwable)e.getCause());
                }
                return false;
            }
            catch (CancellationException e) {
                this.setStatusMsg("Cancelled");
                return false;
            }
        }
    }
}

