/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import com.google.common.collect.Range;
import docking.Tool;
import docking.action.DockingAction;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.service.emulation.DebuggerTracePcodeEmulator;
import ghidra.app.plugin.core.debug.service.emulation.ProgramEmulationUtils;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.AsyncLazyMap;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.Msg;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;

@PluginInfo(shortDescription="Debugger Emulation Service Plugin", description="Manages and cache trace emulation states", category="Debugger", packageName="Debugger", status=PluginStatus.UNSTABLE, eventsConsumed={TraceClosedPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class, DebuggerStaticMappingService.class}, servicesProvided={DebuggerEmulationService.class})
public class DebuggerEmulationServicePlugin
extends Plugin
implements DebuggerEmulationService {
    protected static final int MAX_CACHE_SIZE = 5;
    protected static long nextSnap = Long.MIN_VALUE;
    protected final Set<CacheKey> eldest = new LinkedHashSet<CacheKey>();
    protected final NavigableMap<CacheKey, CachedEmulator> cache = new TreeMap<CacheKey, CachedEmulator>();
    protected final AsyncLazyMap<CacheKey, Long> requests = new AsyncLazyMap(new HashMap(), this::doBackgroundEmulate).forgetErrors((key, t) -> true).forgetValues((key, l) -> true);
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerModelService modelService;
    @AutoServiceConsumed
    private DebuggerStaticMappingService staticMappings;
    private AutoService.Wiring autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
    DockingAction actionEmulateProgram;
    DockingAction actionEmulateAddThread;

    public DebuggerEmulationServicePlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.createActions();
    }

    protected void createActions() {
        this.actionEmulateProgram = (DockingAction)DebuggerResources.EmulateProgramAction.builder(this).withContext(ProgramLocationActionContext.class).enabledWhen(this::emulateProgramEnabled).popupWhen(this::emulateProgramEnabled).onAction(this::emulateProgramActivated).buildAndInstall((Tool)this.tool);
        this.actionEmulateAddThread = (DockingAction)DebuggerResources.EmulateAddThreadAction.builder(this).withContext(ProgramLocationActionContext.class).enabledWhen(this::emulateAddThreadEnabled).popupWhen(this::emulateAddThreadEnabled).onAction(this::emulateAddThreadActivated).buildAndInstall((Tool)this.tool);
    }

    private boolean emulateProgramEnabled(ProgramLocationActionContext ctx) {
        Program program = ctx.getProgram();
        return program != null && !(program instanceof TraceProgramView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emulateProgramActivated(ProgramLocationActionContext ctx) {
        Program program = ctx.getProgram();
        if (program == null) {
            return;
        }
        Trace trace = null;
        try {
            trace = ProgramEmulationUtils.launchEmulationTrace(program, ctx.getAddress(), this);
            this.traceManager.openTrace(trace);
            this.traceManager.activateTrace(trace);
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)this.actionEmulateProgram.getDescription(), (Object)"Could not create trace for emulation", (Throwable)e);
        }
        finally {
            if (trace != null) {
                trace.release((Object)this);
            }
        }
    }

    private boolean emulateAddThreadEnabled(ProgramLocationActionContext ctx) {
        Program programOrView = ctx.getProgram();
        if (programOrView instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)programOrView;
            return ProgramEmulationUtils.isEmulatedProgram(view.getTrace());
        }
        DebuggerCoordinates current = this.traceManager.getCurrent();
        if (current.getTrace() == null || !ProgramEmulationUtils.isEmulatedProgram(current.getTrace())) {
            return false;
        }
        TraceLocation traceLoc = this.staticMappings.getOpenMappedLocation(current.getTrace(), ctx.getLocation(), current.getSnap());
        return traceLoc != null;
    }

    private void emulateAddThreadActivated(ProgramLocationActionContext ctx) {
        Program programOrView = ctx.getProgram();
        if (programOrView instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)programOrView;
            Trace trace = view.getTrace();
            Address tracePc = ctx.getAddress();
            ProgramLocation progLoc = this.staticMappings.getOpenMappedLocation((TraceLocation)new DefaultTraceLocation(view.getTrace(), null, Range.singleton((Comparable)Long.valueOf(view.getSnap())), tracePc));
            Program program = progLoc == null ? null : progLoc.getProgram();
            Address programPc = progLoc == null ? null : progLoc.getAddress();
            long snap = view.getViewport().getOrderedSnaps().stream().filter(s -> s >= 0L).findFirst().get();
            TraceThread thread = ProgramEmulationUtils.launchEmulationThread(trace, snap, program, tracePc, programPc);
            this.traceManager.activateThread(thread);
        } else {
            Program program = programOrView;
            Address programPc = ctx.getAddress();
            DebuggerCoordinates current = this.traceManager.getCurrent();
            long snap = current.getSnap();
            Trace trace = current.getTrace();
            TraceLocation traceLoc = this.staticMappings.getOpenMappedLocation(trace, ctx.getLocation(), snap);
            if (traceLoc == null) {
                return;
            }
            Address tracePc = traceLoc.getAddress();
            TraceThread thread = ProgramEmulationUtils.launchEmulationThread(trace, snap, program, tracePc, programPc);
            this.traceManager.activateThread(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map.Entry<CacheKey, CachedEmulator> findNearestPrefix(CacheKey key) {
        NavigableMap<CacheKey, CachedEmulator> navigableMap = this.cache;
        synchronized (navigableMap) {
            Map.Entry<CacheKey, CachedEmulator> candidate = this.cache.floorEntry(key);
            if (candidate == null) {
                return null;
            }
            if (!candidate.getKey().compareKey((CacheKey)key).related) {
                return null;
            }
            return candidate;
        }
    }

    protected CompletableFuture<Long> doBackgroundEmulate(CacheKey key) {
        EmulateTask task = new EmulateTask(key);
        this.tool.execute((Task)task, 500);
        return task.future;
    }

    @Override
    public CompletableFuture<Long> backgroundEmulate(Trace trace, TraceSchedule time) {
        if (!this.traceManager.getOpenTraces().contains(trace)) {
            throw new IllegalArgumentException("Cannot emulate a trace unless it's opened in the tool.");
        }
        if (time.isSnapOnly()) {
            return CompletableFuture.completedFuture(time.getSnap());
        }
        return this.requests.get((Object)new CacheKey(trace, time));
    }

    protected TraceSnapshot findScratch(Trace trace, TraceSchedule time) {
        Collection exist = trace.getTimeManager().getSnapshotsWithSchedule(time);
        if (!exist.isEmpty()) {
            return (TraceSnapshot)exist.iterator().next();
        }
        TraceSnapshot last = trace.getTimeManager().getMostRecentSnapshot(-1L);
        long snap = last == null ? Long.MIN_VALUE : last.getKey() + 1L;
        TraceSnapshot snapshot = trace.getTimeManager().getSnapshot(snap, true);
        snapshot.setDescription("Emulated");
        snapshot.setSchedule(time);
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doEmulate(CacheKey key, TaskMonitor monitor) throws CancelledException {
        TraceSnapshot destSnap;
        DebuggerTracePcodeEmulator emu;
        CachedEmulator ce;
        NavigableMap<CacheKey, CachedEmulator> navigableMap;
        Trace trace = key.trace;
        TraceSchedule time = key.time;
        Map.Entry<CacheKey, CachedEmulator> ancestor = this.findNearestPrefix(key);
        if (ancestor != null) {
            CacheKey prevKey = ancestor.getKey();
            navigableMap = this.cache;
            synchronized (navigableMap) {
                this.cache.remove(prevKey);
                this.eldest.remove(prevKey);
            }
            ce = ancestor.getValue();
            emu = ce.emulator;
            monitor.initialize(time.totalTickCount() - prevKey.time.totalTickCount());
            time.finish(trace, prevKey.time, (PcodeMachine)emu, monitor);
        } else {
            emu = new DebuggerTracePcodeEmulator(this.tool, trace, time.getSnap(), this.modelService == null ? null : this.modelService.getRecorder(trace));
            ce = new CachedEmulator(emu);
            monitor.initialize(time.totalTickCount());
            time.execute(trace, (PcodeMachine)emu, monitor);
        }
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)trace, (String)"Emulate", (boolean)true);){
            destSnap = this.findScratch(trace, time);
            emu.writeDown(trace, destSnap.getKey(), time.getSnap(), false);
        }
        navigableMap = this.cache;
        synchronized (navigableMap) {
            this.cache.put(key, ce);
            this.eldest.add(key);
            assert (this.cache.size() == this.eldest.size());
            while (this.cache.size() > 5) {
                CacheKey expired = this.eldest.iterator().next();
                this.eldest.remove(expired);
                this.cache.remove(expired);
            }
        }
        return destSnap.getKey();
    }

    @Override
    public long emulate(Trace trace, TraceSchedule time, TaskMonitor monitor) throws CancelledException {
        if (!this.traceManager.getOpenTraces().contains(trace)) {
            throw new IllegalArgumentException("Cannot emulate a trace unless it's opened in the tool.");
        }
        if (time.isSnapOnly()) {
            return time.getSnap();
        }
        return this.doEmulate(new CacheKey(trace, time), monitor);
    }

    @Override
    public DebuggerTracePcodeEmulator getCachedEmulator(Trace trace, TraceSchedule time) {
        CachedEmulator ce = (CachedEmulator)this.cache.get(new CacheKey(trace, time));
        return ce == null ? null : ce.emulator;
    }

    @AutoServiceConsumed
    private void setTraceManager(DebuggerTraceManagerService traceManager) {
        this.cache.clear();
    }

    @AutoServiceConsumed
    private void setModelService(DebuggerModelService modelService) {
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent evt = (TraceClosedPluginEvent)event;
            NavigableMap<CacheKey, CachedEmulator> navigableMap = this.cache;
            synchronized (navigableMap) {
                List toRemove = this.eldest.stream().filter(k -> k.trace == evt.getTrace()).collect(Collectors.toList());
                this.cache.keySet().removeAll(toRemove);
                this.eldest.removeAll(toRemove);
                assert (this.cache.size() == this.eldest.size());
            }
        }
    }

    protected class EmulateTask
    extends Task {
        protected final CacheKey key;
        protected final CompletableFuture<Long> future;

        public EmulateTask(CacheKey key) {
            super("Emulate " + key.time + " in " + key.trace, true, true, false, false);
            this.future = new CompletableFuture();
            this.key = key;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            try {
                this.future.complete(DebuggerEmulationServicePlugin.this.doEmulate(this.key, monitor));
            }
            catch (CancelledException e) {
                this.future.completeExceptionally(e);
                throw e;
            }
            catch (Throwable e) {
                this.future.completeExceptionally(e);
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }

    protected static class CachedEmulator {
        final DebuggerTracePcodeEmulator emulator;

        public CachedEmulator(DebuggerTracePcodeEmulator emulator) {
            this.emulator = emulator;
        }
    }

    protected static class CacheKey
    implements Comparable<CacheKey> {
        protected final Trace trace;
        protected final TraceSchedule time;

        public CacheKey(Trace trace, TraceSchedule time) {
            this.trace = trace;
            this.time = time;
        }

        public int hashCode() {
            return Objects.hash(this.trace, this.time);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)obj;
            if (this.trace != that.trace) {
                return false;
            }
            return Objects.equals(this.time, that.time);
        }

        @Override
        public int compareTo(CacheKey that) {
            return this.compareKey((CacheKey)that).compareTo;
        }

        public CompareResult compareKey(CacheKey that) {
            CompareResult result = CompareResult.unrelated((int)Integer.compare(System.identityHashCode(this.trace), System.identityHashCode(that.trace)));
            if (result != CompareResult.EQUALS) {
                return result;
            }
            result = this.time.compareSchedule(that.time);
            if (result != CompareResult.EQUALS) {
                return result;
            }
            return CompareResult.EQUALS;
        }
    }
}

