/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.gdb;

import ghidra.app.plugin.core.debug.service.model.launch.AbstractDebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOpinion;
import ghidra.app.services.DebuggerModelService;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GdbDebuggerProgramLaunchOpinion
implements DebuggerProgramLaunchOpinion {
    @Override
    public Collection<DebuggerProgramLaunchOffer> getOffers(Program program, PluginTool tool, DebuggerModelService service) {
        String exe = program.getExecutablePath();
        if (exe == null || "".equals(exe.trim())) {
            return List.of();
        }
        ArrayList<DebuggerProgramLaunchOffer> offers = new ArrayList<DebuggerProgramLaunchOffer>();
        for (DebuggerModelFactory factory : service.getModelFactories()) {
            if (!factory.isCompatible()) continue;
            String clsName = factory.getClass().getName();
            if (clsName.equals("agent.gdb.GdbInJvmDebuggerModelFactory")) {
                offers.add(new InVmGdbDebuggerProgramLaunchOffer(program, tool, factory));
                continue;
            }
            if (clsName.equals("agent.gdb.gadp.GdbLocalDebuggerModelFactory")) {
                offers.add(new GadpGdbDebuggerProgramLaunchOffer(program, tool, factory));
                continue;
            }
            if (!clsName.equals("agent.gdb.GdbOverSshDebuggerModelFactory")) continue;
            offers.add(new SshGdbDebuggerProgramLaunchOffer(program, tool, factory));
        }
        return offers;
    }

    protected class SshGdbDebuggerProgramLaunchOffer
    extends AbstractGdbDebuggerProgramLaunchOffer {
        private static final String FACTORY_CLS_NAME = "agent.gdb.GdbOverSshDebuggerModelFactory";

        public SshGdbDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "SSH GDB";
        }

        @Override
        public String getQuickTitle() {
            Map opts = this.factory.getOptions();
            return String.format("in GDB via ssh:%s@%s", ((ConfigurableFactory.Property)opts.get("SSH username")).getValue(), ((ConfigurableFactory.Property)opts.get("SSH hostname")).getValue());
        }

        @Override
        public String getMenuTitle() {
            return "in GDB via ssh";
        }
    }

    protected class GadpGdbDebuggerProgramLaunchOffer
    extends AbstractGdbDebuggerProgramLaunchOffer {
        private static final String FACTORY_CLS_NAME = "agent.gdb.gadp.GdbLocalDebuggerModelFactory";

        public GadpGdbDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "GADP GDB";
        }

        @Override
        public String getMenuTitle() {
            return "in GDB locally via GADP";
        }
    }

    protected class InVmGdbDebuggerProgramLaunchOffer
    extends AbstractGdbDebuggerProgramLaunchOffer {
        private static final String FACTORY_CLS_NAME = "agent.gdb.GdbInJvmDebuggerModelFactory";

        public InVmGdbDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "IN-VM GDB";
        }

        @Override
        public String getMenuTitle() {
            return "in GDB locally IN-VM";
        }
    }

    protected static abstract class AbstractGdbDebuggerProgramLaunchOffer
    extends AbstractDebuggerProgramLaunchOffer {
        public AbstractGdbDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        protected List<String> getLauncherPath() {
            return PathUtils.parse((String)"Inferiors[1]");
        }

        @Override
        protected Map<String, ?> generateDefaultLauncherArgs(Map<String, TargetMethod.ParameterDescription<?>> params) {
            return Map.of("args", this.program.getExecutablePath());
        }
    }
}

