/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.dbgeng;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.plugin.core.debug.workflow.DisassemblyInject;
import ghidra.app.plugin.core.debug.workflow.DisassemblyInjectInfo;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.TraceRecorder;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.mem.Memory;
import ghidra.program.util.ProgramContextImpl;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

@DisassemblyInjectInfo(langIDs={"x86:LE:64:default"})
public class DbgengX64DisassemblyInject
implements DisassemblyInject {
    @Override
    public void pre(PluginTool tool, DisassembleCommand command, TraceProgramView view, TraceThread thread, AddressSetView startSet, AddressSetView restricted) {
        Trace trace = view.getTrace();
        AddressRange first = startSet.getFirstRange();
        if (first == null) {
            return;
        }
        DebuggerModelService modelService = (DebuggerModelService)tool.getService(DebuggerModelService.class);
        TraceRecorder recorder = modelService == null ? null : modelService.getRecorder(trace);
        Collection modules = trace.getModuleManager().getModulesAt(view.getSnap(), first.getMinAddress());
        Set modes = modules.stream().map(m -> this.modeForModule(recorder, view, (TraceModule)m)).filter(m -> m != Mode.UNK).collect(Collectors.toSet());
        if (modes.size() != 1) {
            return;
        }
        Mode mode = (Mode)((Object)modes.iterator().next());
        Language lang = trace.getBaseLanguage();
        Register addrsizeReg = lang.getRegister("addrsize");
        Register opsizeReg = lang.getRegister("opsize");
        ProgramContextImpl context = new ProgramContextImpl(lang);
        lang.applyContextSettings((DefaultProgramContext)context);
        RegisterValue ctxVal = context.getDisassemblyContext(first.getMinAddress());
        if (mode == Mode.X64) {
            command.setInitialContext(ctxVal.assign(addrsizeReg, BigInteger.TWO).assign(opsizeReg, BigInteger.TWO));
        } else if (mode == Mode.X86) {
            command.setInitialContext(ctxVal.assign(addrsizeReg, BigInteger.ONE).assign(opsizeReg, BigInteger.ONE));
        }
    }

    protected Mode modeForModule(TraceRecorder recorder, TraceProgramView view, TraceModule module) {
        if (recorder != null && recorder.getSnap() == view.getSnap()) {
            AddressSet set = new AddressSet();
            set.add(module.getBase(), module.getBase());
            try {
                recorder.captureProcessMemory((AddressSetView)set, TaskMonitor.DUMMY, false).get(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                Msg.error((Object)"Could not read module header from target", (Object)e);
            }
        }
        MemoryByteProvider mbp = new MemoryByteProvider((Memory)view.getMemory(), module.getBase());
        try {
            PortableExecutable pe = PortableExecutable.createPortableExecutable((GenericFactory)RethrowContinuesFactory.INSTANCE, (ByteProvider)mbp, (PortableExecutable.SectionLayout)PortableExecutable.SectionLayout.MEMORY, (boolean)false, (boolean)false);
            NTHeader ntHeader = pe.getNTHeader();
            if (ntHeader == null) {
                return Mode.UNK;
            }
            OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
            if (optionalHeader == null) {
                return Mode.UNK;
            }
            return optionalHeader.is64bit() ? Mode.X64 : Mode.X86;
        }
        catch (IOException e) {
            Msg.warn((Object)this, (Object)("Could not parse PE from trace: " + e));
            return Mode.UNK;
        }
    }

    static enum Mode {
        X64,
        X86,
        UNK;

    }
}

